/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.webscripts.metadata;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceDictionary;
import org.alfresco.rest.framework.core.ResourceLookupDictionary;
import org.alfresco.rest.framework.core.ResourceMetadata;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.jacksonextensions.ExecutionResult;
import org.alfresco.rest.framework.jacksonextensions.JacksonHelper;
import org.alfresco.rest.framework.metadata.ResourceMetaDataWriter;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.webscripts.ApiWebScript;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class WebScriptOptionsMetaData
extends ApiWebScript
implements ResourceMetaDataWriter {
    private static Log logger = LogFactory.getLog(WebScriptOptionsMetaData.class);
    private ResourceLookupDictionary lookupDictionary;
    private Map<String, ResourceMetaDataWriter> writers;

    public void setLookupDictionary(ResourceLookupDictionary lookupDictionary) {
        this.lookupDictionary = lookupDictionary;
    }

    @Override
    public void execute(Api api, WebScriptRequest req, WebScriptResponse res) throws IOException {
        ResourceWithMetadata resource;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        ResourceDictionary resourceDic = this.lookupDictionary.getDictionary();
        Map<String, ResourceWithMetadata> apiResources = resourceDic.getAllResources().get(api);
        if (apiResources == null) {
            throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_INVALID_API);
        }
        String collectionName = (String)templateVars.get("collectionResource");
        String resourceName = (String)templateVars.get("relationResource");
        String resourceKey = ResourceDictionary.resourceKey(collectionName, resourceName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Locating resource :" + resourceKey));
        }
        if ((resource = apiResources.get(resourceKey)) == null) {
            resourceKey = ResourceDictionary.propertyResourceKey(collectionName, resourceName);
            resource = apiResources.get(resourceKey);
        }
        ResourceMetaDataWriter writer = this.chooseWriter(req);
        writer.writeMetaData(res.getOutputStream(), resource, apiResources);
    }

    protected ResourceMetaDataWriter chooseWriter(WebScriptRequest req) {
        ResourceMetaDataWriter theWriter;
        if (this.writers != null && (theWriter = this.writers.get(req.getParameter("format"))) != null) {
            return theWriter;
        }
        return this;
    }

    public static Object processResult(ResourceWithMetadata resource, Map<String, ResourceWithMetadata> apiResources) {
        ArrayList<ExecutionResult> results = new ArrayList<ExecutionResult>();
        if (ResourceMetadata.RESOURCE_TYPE.ENTITY.equals((Object)resource.getMetaData().getType())) {
            results.add(new ExecutionResult(resource, null));
            for (ResourceWithMetadata aResource : apiResources.values()) {
                if (!resource.getMetaData().getUniqueId().equals(aResource.getMetaData().getParentResource())) continue;
                results.add(new ExecutionResult(aResource, null));
            }
        }
        if (results.isEmpty()) {
            return new ExecutionResult(resource, null);
        }
        return CollectionWithPagingInfo.asPaged(Paging.DEFAULT, results);
    }

    @Override
    public void writeMetaData(OutputStream out, ResourceWithMetadata resource, Map<String, ResourceWithMetadata> allApiResources) throws IOException {
        final Object result = WebScriptOptionsMetaData.processResult(resource, allApiResources);
        this.assistant.getJsonHelper().withWriter(out, new JacksonHelper.Writer(){

            @Override
            public void writeContents(JsonGenerator generator, ObjectMapper objectMapper) throws JsonGenerationException, JsonMappingException, IOException {
                objectMapper.writeValue(generator, result);
            }
        });
    }

    public void setWriters(Map<String, ResourceMetaDataWriter> writers) {
        this.writers = writers;
    }
}

