/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.alfresco.repo.web.scripts.TempOutputStream;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.util.FileCopyUtils;

public class BufferedRequest
implements WrappingWebScriptRequest,
AutoCloseable {
    private final Supplier<TempOutputStream> streamFactory;
    private final WebScriptRequest req;
    private TempOutputStream bufferStream;
    private InputStream contentStream;
    private BufferedReader contentReader;

    public BufferedRequest(WebScriptRequest req, Supplier<TempOutputStream> streamFactory) {
        this.req = req;
        this.streamFactory = streamFactory;
    }

    private TempOutputStream getBufferedBodyAsTempStream() throws IOException {
        if (this.bufferStream == null) {
            this.bufferStream = this.streamFactory.get();
            try {
                FileCopyUtils.copy((InputStream)this.req.getContent().getInputStream(), (OutputStream)this.bufferStream);
            }
            catch (IOException e) {
                this.bufferStream.destroy();
                throw e;
            }
        }
        return this.bufferStream;
    }

    private InputStream bufferInputStream() throws IOException {
        if (this.contentReader != null) {
            throw new IllegalStateException("Reader in use");
        }
        if (this.contentStream == null) {
            this.contentStream = this.getBufferedBodyAsTempStream().toNewInputStream();
        }
        return this.contentStream;
    }

    public void reset() {
        if (this.contentStream != null) {
            try {
                this.contentStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.contentStream = null;
        }
        if (this.contentReader != null) {
            try {
                this.contentReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.contentReader = null;
        }
    }

    @Override
    public void close() {
        this.reset();
        if (this.bufferStream != null) {
            try {
                this.bufferStream.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bufferStream = null;
        }
    }

    public WebScriptRequest getNext() {
        return this.req;
    }

    public boolean forceSuccessStatus() {
        return this.req.forceSuccessStatus();
    }

    public String getAgent() {
        return this.req.getAgent();
    }

    public Content getContent() {
        final Content wrapped = this.req.getContent();
        return new Content(){

            public String getContent() throws IOException {
                return wrapped.getContent();
            }

            public String getEncoding() {
                return wrapped.getEncoding();
            }

            public String getMimetype() {
                return wrapped.getMimetype();
            }

            public long getSize() {
                return wrapped.getSize();
            }

            public InputStream getInputStream() {
                if (BufferedRequest.this.contentReader != null) {
                    throw new IllegalStateException("Reader in use");
                }
                if (BufferedRequest.this.contentStream == null) {
                    try {
                        BufferedRequest.this.contentStream = BufferedRequest.this.bufferInputStream();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return BufferedRequest.this.contentStream;
            }

            public BufferedReader getReader() throws IOException {
                if (BufferedRequest.this.contentStream != null) {
                    throw new IllegalStateException("Input Stream in use");
                }
                if (BufferedRequest.this.contentReader == null) {
                    String encoding = wrapped.getEncoding();
                    InputStream in = BufferedRequest.this.bufferInputStream();
                    BufferedRequest.this.contentReader = new BufferedReader(new InputStreamReader(in, encoding == null ? "ISO-8859-1" : encoding));
                }
                return BufferedRequest.this.contentReader;
            }
        };
    }

    public String getContentType() {
        return this.req.getContentType();
    }

    public String getContextPath() {
        return this.req.getContextPath();
    }

    public String getExtensionPath() {
        return this.req.getExtensionPath();
    }

    public String getFormat() {
        return this.req.getFormat();
    }

    public Description.FormatStyle getFormatStyle() {
        return this.req.getFormatStyle();
    }

    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    public String[] getHeaderNames() {
        return this.req.getHeaderNames();
    }

    public String[] getHeaderValues(String name) {
        return this.req.getHeaderValues(name);
    }

    public String getJSONCallback() {
        return this.req.getJSONCallback();
    }

    public String getParameter(String name) {
        return this.req.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.req.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.req.getParameterValues(name);
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getQueryString() {
        return this.req.getQueryString();
    }

    public Runtime getRuntime() {
        return this.req.getRuntime();
    }

    public String getServerPath() {
        return this.req.getServerPath();
    }

    public String getServiceContextPath() {
        return this.req.getServiceContextPath();
    }

    public Match getServiceMatch() {
        return this.req.getServiceMatch();
    }

    public String getServicePath() {
        return this.req.getServicePath();
    }

    public String getURL() {
        return this.req.getURL();
    }

    public boolean isGuest() {
        return this.req.isGuest();
    }

    public Object parseContent() {
        return this.req.parseContent();
    }
}

