/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.alfresco.rest.framework.resource.UniqueId;
import org.alfresco.service.cmr.repository.NodeRef;

public class Tag
implements Comparable<Tag> {
    private NodeRef nodeRef;
    private String tag;
    private Long count;

    public Tag() {
    }

    public Tag(NodeRef nodeRef, String tag) {
        this.nodeRef = nodeRef;
        this.setTag(tag);
    }

    @JsonProperty(value="id")
    @UniqueId
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public void setNodeRef(NodeRef nodeRef) {
        this.nodeRef = nodeRef;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = Optional.ofNullable(tag).map(String::toLowerCase).orElse(null);
    }

    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    @Override
    public int compareTo(Tag o) {
        int ret = this.getTag().compareTo(o.getTag());
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag1 = (Tag)o;
        return Objects.equals(this.nodeRef, tag1.nodeRef) && Objects.equals(this.tag, tag1.tag) && Objects.equals(this.count, tag1.count);
    }

    public int hashCode() {
        return Objects.hash(this.nodeRef, this.tag, this.count);
    }

    public String toString() {
        return "Tag{nodeRef=" + String.valueOf(this.nodeRef) + ", tag='" + this.tag + "', count=" + this.count + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private NodeRef nodeRef;
        private String tag;
        private Long count;

        public Builder nodeRef(NodeRef nodeRef) {
            this.nodeRef = nodeRef;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder count(Long count) {
            this.count = count;
            return this;
        }

        public Tag create() {
            Tag tag = new Tag();
            tag.setNodeRef(this.nodeRef);
            tag.setTag(this.tag);
            tag.setCount(this.count);
            return tag;
        }
    }
}

