/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.discussion;

import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import org.alfresco.repo.web.scripts.discussion.AbstractDiscussionWebScript;
import org.alfresco.service.cmr.discussion.PostInfo;
import org.alfresco.service.cmr.discussion.TopicInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ForumPostDelete
extends AbstractDiscussionWebScript {
    private static final String MSG_NODE_MARKED_REMOVED = "forum-post.msg.marked.removed";
    private static final String MSG_NODE_DELETED = "forum-post.msg.deleted";
    private static final String DELETED_POST_TEXT = "[[deleted]]";

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef nodeRef, TopicInfo topic, PostInfo post, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        ResourceBundle rb = this.getResources();
        Map<String, Object> model = this.buildCommonModel(site, topic, post, req);
        String message = null;
        if (post != null) {
            message = this.doDeletePost(topic, post, rb);
        } else if (topic != null) {
            message = this.doDeleteTopic(topic, site, req, json, rb);
        } else {
            String error = "Node was of the wrong type, only Topic and Post are supported";
            throw new WebScriptException(400, error);
        }
        model.put("message", message);
        return model;
    }

    private String doDeleteTopic(TopicInfo topic, SiteInfo site, WebScriptRequest req, JSONObject json, ResourceBundle rb) {
        this.discussionService.deleteTopic(topic);
        if (site != null) {
            this.addActivityEntry("post", "deleted", topic, null, site, req, json);
        }
        String message = rb.getString(MSG_NODE_DELETED);
        return MessageFormat.format(message, topic.getNodeRef());
    }

    private String doDeletePost(TopicInfo topic, PostInfo post, ResourceBundle rb) {
        post.setTitle(DELETED_POST_TEXT);
        post.setContents(DELETED_POST_TEXT);
        this.discussionService.updatePost(post);
        String message = rb.getString(MSG_NODE_MARKED_REMOVED);
        return MessageFormat.format(message, post.getNodeRef());
    }
}

