/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.nodes.AbstractNodeRelation;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

@RelationshipResource(name="parents", entityResource=NodesEntityResource.class, title="Node Parents")
public class NodeParentsRelation
extends AbstractNodeRelation
implements RelationshipResourceAction.Read<Node> {
    private static final Set<String> WHERE_PARAMS_PARENTS = new HashSet<String>(Arrays.asList("assocType", "isPrimary"));

    @Override
    @WebApiDescription(title="Return a list of parent nodes based on child assocs")
    public CollectionWithPagingInfo<Node> readAll(String childNodeId, Parameters parameters) {
        NodeRef childNodeRef = this.nodes.validateOrLookupNode(childNodeId);
        QNamePattern assocTypeQNameParam = RegexQNamePattern.MATCH_ALL;
        Boolean isPrimary = null;
        Query q = parameters.getQuery();
        if (q != null) {
            MapBasedQueryWalker propertyWalker = new MapBasedQueryWalker(WHERE_PARAMS_PARENTS, null);
            QueryHelper.walk(q, propertyWalker);
            isPrimary = propertyWalker.getProperty("isPrimary", 8, Boolean.class);
            String assocTypeQNameStr = propertyWalker.getProperty("assocType", 8, String.class);
            if (assocTypeQNameStr != null) {
                assocTypeQNameParam = this.nodes.getAssocType(assocTypeQNameStr);
            }
        }
        List childAssocRefs = null;
        childAssocRefs = assocTypeQNameParam.equals((Object)RegexQNamePattern.MATCH_ALL) ? this.nodeService.getParentAssocs(childNodeRef) : this.nodeService.getParentAssocs(childNodeRef, assocTypeQNameParam, RegexQNamePattern.MATCH_ALL);
        return this.listNodeChildAssocs(childAssocRefs, parameters, isPrimary, false);
    }
}

