/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.activities;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.api.impl.activities.ActivitySummaryProcessor;
import org.alfresco.rest.api.impl.activities.ActivitySummaryProcessorRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public abstract class AbstractActivitySummaryProcessor
extends AbstractLifecycleBean
implements ActivitySummaryProcessor {
    protected static Log logger = LogFactory.getLog(ActivitySummaryProcessor.class);
    protected ActivitySummaryProcessorRegistry registry;
    private List<String> eventTypes;

    public void setEventTypes(List<String> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public void setRegistry(ActivitySummaryProcessorRegistry registry) {
        this.registry = registry;
    }

    public void setCustomRenditions(List<String> eventTypes) {
        this.eventTypes = eventTypes;
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.register();
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    @Override
    public Map<String, Object> process(Map<String, Object> entries) {
        LinkedList<ActivitySummaryProcessor.Change> changes = new LinkedList<ActivitySummaryProcessor.Change>();
        HashMap<String, Object> ret = new HashMap<String, Object>(entries.size());
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            Object value;
            String key = entry.getKey();
            ActivitySummaryProcessor.Change change = this.processEntry(key, value = entry.getValue());
            if (change == null) continue;
            changes.add(change);
        }
        for (ActivitySummaryProcessor.Change change : changes) {
            if (change == null) continue;
            change.process(entries);
        }
        return ret;
    }

    protected abstract ActivitySummaryProcessor.Change processEntry(String var1, Object var2);

    protected void register() {
        for (String eventType : this.eventTypes) {
            this.registry.register(eventType, this);
        }
    }

    public static class RemoveKey
    implements ActivitySummaryProcessor.Change {
        private String key;

        public RemoveKey(String key) {
            this.key = key;
        }

        @Override
        public void process(Map<String, Object> entries) {
            entries.remove(this.key);
        }
    }

    public static class ChangeKey
    implements ActivitySummaryProcessor.Change {
        private String oldKey;
        private String newKey;

        public ChangeKey(String oldKey, String newKey) {
            this.oldKey = oldKey;
            this.newKey = newKey;
        }

        @Override
        public void process(Map<String, Object> entries) {
            Object value = entries.remove(this.oldKey);
            entries.put(this.newKey, value);
        }
    }
}

