/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.alfresco.rest.api.people.PeopleEntityResource;
import org.alfresco.rest.framework.resource.EmbeddedEntityResource;
import org.alfresco.rest.framework.resource.UniqueId;

public class SiteMember {
    private String personId;
    private String role;
    private boolean isMemberOfGroup;

    public SiteMember() {
    }

    public SiteMember(String personId, String role) {
        if (personId == null) {
            throw new IllegalArgumentException();
        }
        if (role == null) {
            throw new IllegalArgumentException();
        }
        this.personId = personId;
        this.role = role;
    }

    public SiteMember(String personId, String role, boolean isMemberOfGroup) {
        if (personId == null) {
            throw new IllegalArgumentException();
        }
        if (role == null) {
            throw new IllegalArgumentException();
        }
        this.personId = personId;
        this.role = role;
        this.isMemberOfGroup = isMemberOfGroup;
    }

    @JsonProperty(value="id")
    @UniqueId
    @EmbeddedEntityResource(propertyName="person", entityResource=PeopleEntityResource.class)
    public String getPersonId() {
        return this.personId;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        if (role == null) {
            throw new IllegalArgumentException();
        }
        this.role = role;
    }

    public void setPersonId(String personId) {
        if (personId == null) {
            throw new IllegalArgumentException();
        }
        this.personId = personId;
    }

    public void setIsMemberOfGroup(boolean isMemberOfGroup) {
        this.isMemberOfGroup = isMemberOfGroup;
    }

    public boolean getIsMemberOfGroup() {
        return this.isMemberOfGroup;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.personId == null ? 0 : this.personId.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiteMember other = (SiteMember)obj;
        if (!this.personId.equals(other.personId)) {
            return false;
        }
        if (this.isMemberOfGroup != other.isMemberOfGroup) {
            return false;
        }
        return this.role == other.role;
    }

    public String toString() {
        return "SiteMember [personId=" + this.personId + ", isMemberOfGroup=" + this.isMemberOfGroup + ", role=" + this.role + "]";
    }
}

