/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.List;
import org.alfresco.repo.content.directurl.DirectAccessUrlDisabledException;
import org.alfresco.rest.api.DirectAccessUrlHelper;
import org.alfresco.rest.api.Renditions;
import org.alfresco.rest.api.model.DirectAccessUrlRequest;
import org.alfresco.rest.api.model.Rendition;
import org.alfresco.rest.api.nodes.NodeVersionsRelation;
import org.alfresco.rest.framework.BinaryProperties;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceBinaryAction;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="renditions", entityResource=NodeVersionsRelation.class, title="Node version renditions")
public class NodeVersionRenditionsRelation
implements RelationshipResourceAction.Read<Rendition>,
RelationshipResourceAction.ReadById<Rendition>,
RelationshipResourceAction.Create<Rendition>,
RelationshipResourceAction.Delete,
RelationshipResourceBinaryAction.Read,
InitializingBean {
    private Renditions renditions;
    private DirectAccessUrlHelper directAccessUrlHelper;

    public void setRenditions(Renditions renditions) {
        this.renditions = renditions;
    }

    public void setDirectAccessUrlHelper(DirectAccessUrlHelper directAccessUrlHelper) {
        this.directAccessUrlHelper = directAccessUrlHelper;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"renditions", (Object)this.renditions);
    }

    @Override
    public CollectionWithPagingInfo<Rendition> readAll(String nodeId, Parameters parameters) {
        String versionId = parameters.getRelationshipId();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        return this.renditions.getRenditions(nodeRef, versionId, parameters);
    }

    @Override
    public Rendition readById(String nodeId, String versionId, Parameters parameters) {
        String renditionId = parameters.getRelationship2Id();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        return this.renditions.getRendition(nodeRef, versionId, renditionId, parameters);
    }

    @Override
    @WebApiDescription(title="Create rendition", successStatus=202)
    public List<Rendition> create(String nodeId, List<Rendition> entity, Parameters parameters) {
        String versionId = parameters.getRelationshipId();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        this.renditions.createRenditions(nodeRef, versionId, entity, parameters);
        return null;
    }

    @Override
    @WebApiDescription(title="Download rendition", description="Download rendition")
    @BinaryProperties(value={"content"})
    public BinaryResource readProperty(String nodeId, String versionId, Parameters parameters) {
        String renditionId = parameters.getRelationship2Id();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        return this.renditions.getContent(nodeRef, versionId, renditionId, parameters);
    }

    @Operation(value="request-direct-access-url")
    @WebApiParam(name="directAccessUrlRequest", title="Request direct access url", description="Options for direct access url request", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Request content url", description="Generates a direct access URL.", successStatus=200)
    public DirectAccessUrl requestContentDirectUrl(String nodeId, String versionId, DirectAccessUrlRequest directAccessUrlRequest, Parameters parameters, WithResponse withResponse) {
        DirectAccessUrl directAccessUrl;
        boolean attachment = this.directAccessUrlHelper.getAttachment(directAccessUrlRequest);
        Long validFor = this.directAccessUrlHelper.getDefaultExpiryTimeInSec();
        String fileName = this.directAccessUrlHelper.getFileName(directAccessUrlRequest);
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        String renditionId = parameters.getRelationship2Id();
        try {
            directAccessUrl = this.renditions.requestContentDirectUrl(nodeRef, versionId, renditionId, attachment, validFor, fileName);
        }
        catch (DirectAccessUrlDisabledException ex) {
            throw new DisabledServiceException(ex.getMessage());
        }
        return directAccessUrl;
    }

    @Override
    @WebApiDescription(title="Delete rendition")
    public void delete(String nodeId, String versionId, Parameters parameters) {
        String renditionId = parameters.getRelationship2Id();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        this.renditions.deleteRendition(nodeRef, versionId, renditionId, parameters);
    }
}

