/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client;

import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class HttpResponse {
    protected HttpMethod method;
    private String user;
    private byte[] responseBytes;
    private Map<String, String> headers;
    private long time;

    public HttpResponse(HttpMethod method, String user, byte[] responseBytes, Map<String, String> headers, long time) {
        this.method = method;
        this.user = user;
        this.time = time;
        this.headers = headers;
        this.responseBytes = responseBytes;
    }

    public int getStatusCode() {
        return this.method.getStatusCode();
    }

    public String getResponse() {
        if (this.responseBytes != null) {
            if (this.method instanceof HttpMethodBase) {
                return EncodingUtil.getString((byte[])this.responseBytes, (String)((HttpMethodBase)this.method).getResponseCharSet());
            }
            return new String(this.responseBytes);
        }
        return null;
    }

    public byte[] getResponseAsBytes() {
        return this.responseBytes;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String requestType = null;
        RequestEntity requestEntity = null;
        if (this.method instanceof GetMethod) {
            requestType = "GET";
        } else if (this.method instanceof PutMethod) {
            requestType = "PUT";
            requestEntity = ((PutMethod)this.method).getRequestEntity();
        } else if (this.method instanceof PostMethod) {
            requestType = "POST";
            requestEntity = ((PostMethod)this.method).getRequestEntity();
        } else if (this.method instanceof DeleteMethod) {
            requestType = "DELETE";
        }
        try {
            sb.append(requestType).append(" request ").append(this.method.getURI()).append("\n");
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        if (requestEntity != null) {
            sb.append("\nRequest body: ");
            if (requestEntity instanceof StringRequestEntity) {
                sb.append(((StringRequestEntity)requestEntity).getContent());
            } else if (requestEntity instanceof ByteArrayRequestEntity) {
                sb.append(" << ").append(((ByteArrayRequestEntity)requestEntity).getContent().length).append(" bytes >>");
            }
            sb.append("\n");
        }
        sb.append("user ").append(this.user).append("\n");
        sb.append("returned ").append(this.method.getStatusCode()).append(" and took ").append(this.time).append("ms").append("\n");
        String contentType = null;
        Header hdr = this.method.getResponseHeader("Content-Type");
        if (hdr != null) {
            contentType = hdr.getValue();
        }
        sb.append("Response content type: ").append(contentType).append("\n");
        if (contentType != null) {
            sb.append("\nResponse body: ");
            if (contentType.startsWith("text/plain") || contentType.startsWith("application/json")) {
                sb.append(this.getResponse());
                sb.append("\n");
            } else if (this.getResponseAsBytes() != null) {
                sb.append(" << ").append(this.getResponseAsBytes().length).append(" bytes >>");
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public JSONObject getJsonResponse() {
        JSONObject result = null;
        try {
            Object object;
            String response = this.getResponse();
            if (response != null && (object = new JSONParser().parse(response)) instanceof JSONObject) {
                return (JSONObject)object;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }
}

