/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.Collections;
import java.util.Comparator;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.alfresco.ibatis.RetryingCallbackHelper;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.api.model.ActionDefinition;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.Pair;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterizedItemDefinition;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestActions
extends AbstractBaseApiTest {
    private NodeService nodeService;
    private OwnableService ownableService;
    private ActionService actionService;
    private PublicApiClient.Actions actions;
    private RepoService.TestNetwork account1;
    private Iterator<RepoService.TestNetwork> accountsIt;
    private Iterator<String> account1PersonIt;
    private static final Map<String, String> emptyParams = Collections.EMPTY_MAP;
    private static final Log logger = LogFactory.getLog(TestActions.class);

    @Before
    public void setUp() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService", NodeService.class);
        this.ownableService = (OwnableService)this.applicationContext.getBean("OwnableService", OwnableService.class);
        this.actionService = (ActionService)this.applicationContext.getBean("ActionService", ActionService.class);
        this.actions = this.publicApiClient.actions();
        this.accountsIt = this.getTestFixture().getNetworksIt();
        this.account1 = this.accountsIt.next();
        this.account1PersonIt = this.account1.getPersonIds().iterator();
        AuthenticationUtil.pushAuthentication();
    }

    @Override
    @After
    public void tearDown() {
        try {
            AuthenticationUtil.popAuthentication();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    @Override
    public String getScope() {
        return "public";
    }

    @Test
    public void canGetActionDefinitions() throws PublicApiException {
        String person1 = this.account1PersonIt.next();
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1));
        PublicApiClient.ListResponse<ActionDefinition> actionDefs = this.actions.getActionDefinitions(emptyParams, 200);
        Assert.assertNotNull((String)"Action definition list should not be null", actionDefs);
        Assert.assertFalse((String)"Action definition list should not be empty", (boolean)actionDefs.getList().isEmpty());
        Assert.assertEquals((long)100L, (long)actionDefs.getPaging().getMaxItems().intValue());
        Assert.assertEquals((long)0L, (long)actionDefs.getPaging().getSkipCount().intValue());
        List actionDefinitions = actionDefs.getList().stream().filter(ad -> ad.getName().equals("add-features")).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)actionDefinitions.size());
        ActionDefinition action = (ActionDefinition)actionDefinitions.get(0);
        Assert.assertEquals((Object)"add-features", (Object)action.getId());
        Assert.assertEquals((Object)"add-features", (Object)action.getName());
        Assert.assertEquals((Object)"Add aspect", (Object)action.getTitle());
        Assert.assertEquals((Object)"This will add an aspect to the matched item.", (Object)action.getDescription());
        Assert.assertEquals((long)0L, (long)action.getApplicableTypes().size());
        Assert.assertEquals((Object)false, (Object)action.isTrackStatus());
        Assert.assertEquals((long)1L, (long)action.getParameterDefinitions().size());
        ActionDefinition.ParameterDefinition paramDefs = (ActionDefinition.ParameterDefinition)action.getParameterDefinitions().get(0);
        Assert.assertEquals((Object)"aspect-name", (Object)paramDefs.getName());
        Assert.assertEquals((Object)"d:qname", (Object)paramDefs.getType());
        Assert.assertEquals((Object)true, (Object)paramDefs.isMandatory());
        Assert.assertEquals((Object)"Aspect", (Object)paramDefs.getDisplayLabel());
        Assert.assertEquals((Object)false, (Object)paramDefs.isMultiValued());
        Assert.assertEquals((Object)"ac-aspects", (Object)paramDefs.getParameterConstraintName());
        this.checkBasicPagingAndSorting(() -> this.actionService.getActionDefinitions().stream().sorted(Comparator.comparing(ParameterizedItemDefinition::getName)).map(ParameterizedItemDefinition::getName).collect(Collectors.toList()), paging -> this.actions.getActionDefinitions(this.createParams((PublicApiClient.Paging)paging, null), 200));
        this.checkSorting(() -> this.actionService.getActionDefinitions().stream().sorted(Comparator.comparing(ParameterizedItemDefinition::getTitle, Comparator.nullsFirst(Comparator.naturalOrder()))).map(act -> new Pair<String, String>(act.getName(), act.getTitle())).collect(Collectors.toList()), (paging, orderBy) -> this.actions.getActionDefinitions(this.createParams((PublicApiClient.Paging)paging, (Map<String, String>)orderBy), 200), "title");
        this.checkSorting(() -> this.actionService.getActionDefinitions().stream().sorted(Comparator.comparing(ParameterizedItemDefinition::getName, Comparator.nullsFirst(Comparator.naturalOrder()))).map(act -> new Pair<String, String>(act.getName(), act.getTitle())).collect(Collectors.toList()), (paging, orderBy) -> this.actions.getActionDefinitions(this.createParams((PublicApiClient.Paging)paging, (Map<String, String>)orderBy), 200), "name");
        PublicApiClient.Paging paging2 = this.getPaging(0, -1);
        this.actions.getActionDefinitions(this.createParams(paging2, null), 400);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1, "invalid-password"));
        this.actions.getActionDefinitions(emptyParams, 401);
    }

    @Test
    public void canGetActionDefinition() throws PublicApiException {
        String person1 = this.account1PersonIt.next();
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1));
        ActionDefinition actionDef = this.actions.getActionDefinition("add-features", 200);
        Assert.assertNotNull((String)"Action definition should not be null", (Object)actionDef);
        Assert.assertEquals((Object)"add-features", (Object)actionDef.getId());
        Assert.assertEquals((Object)"add-features", (Object)actionDef.getName());
        Assert.assertEquals((Object)"Add aspect", (Object)actionDef.getTitle());
        Assert.assertEquals((Object)"This will add an aspect to the matched item.", (Object)actionDef.getDescription());
        Assert.assertEquals((long)0L, (long)actionDef.getApplicableTypes().size());
        Assert.assertEquals((Object)false, (Object)actionDef.isTrackStatus());
        Assert.assertEquals((long)1L, (long)actionDef.getParameterDefinitions().size());
        ActionDefinition.ParameterDefinition paramDefs = (ActionDefinition.ParameterDefinition)actionDef.getParameterDefinitions().get(0);
        Assert.assertEquals((Object)"aspect-name", (Object)paramDefs.getName());
        Assert.assertEquals((Object)"d:qname", (Object)paramDefs.getType());
        Assert.assertEquals((Object)true, (Object)paramDefs.isMandatory());
        Assert.assertEquals((Object)"Aspect", (Object)paramDefs.getDisplayLabel());
        Assert.assertEquals((Object)false, (Object)paramDefs.isMultiValued());
        Assert.assertEquals((Object)"ac-aspects", (Object)paramDefs.getParameterConstraintName());
        this.actions.getActionDefinition("some-text", 404);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1, "invalid-password"));
        this.actions.getActionDefinition(null, 401);
    }

    @Test
    public void canGetActionDefinitionsForNode() throws Exception {
        String person1 = this.account1PersonIt.next();
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1));
        PublicApiClient.ListResponse<ActionDefinition> actionDefs = this.actions.getActionDefinitionsForNode("-my-", emptyParams, 200);
        Assert.assertNotNull((String)"Action definition list should not be null", actionDefs);
        Assert.assertFalse((String)"Action definition list should not be empty", (boolean)actionDefs.getList().isEmpty());
        Assert.assertEquals((long)100L, (long)actionDefs.getPaging().getMaxItems().intValue());
        Assert.assertEquals((long)0L, (long)actionDefs.getPaging().getSkipCount().intValue());
        List actionDefinitions = actionDefs.getList().stream().filter(ad -> ad.getName().equals("add-features")).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)actionDefinitions.size());
        ActionDefinition action = (ActionDefinition)actionDefinitions.get(0);
        Assert.assertEquals((Object)"add-features", (Object)action.getId());
        Assert.assertEquals((Object)"add-features", (Object)action.getName());
        Assert.assertEquals((Object)"Add aspect", (Object)action.getTitle());
        Assert.assertEquals((Object)"This will add an aspect to the matched item.", (Object)action.getDescription());
        Assert.assertEquals((long)0L, (long)action.getApplicableTypes().size());
        Assert.assertEquals((Object)false, (Object)action.isTrackStatus());
        Assert.assertEquals((long)1L, (long)action.getParameterDefinitions().size());
        ActionDefinition.ParameterDefinition paramDefs = (ActionDefinition.ParameterDefinition)action.getParameterDefinitions().get(0);
        Assert.assertEquals((Object)"aspect-name", (Object)paramDefs.getName());
        Assert.assertEquals((Object)"d:qname", (Object)paramDefs.getType());
        Assert.assertEquals((Object)true, (Object)paramDefs.isMandatory());
        Assert.assertEquals((Object)"Aspect", (Object)paramDefs.getDisplayLabel());
        Assert.assertEquals((Object)false, (Object)paramDefs.isMultiValued());
        Assert.assertEquals((Object)"ac-aspects", (Object)paramDefs.getParameterConstraintName());
        AuthenticationUtil.setFullyAuthenticatedUser((String)person1);
        NodeRef nodeForCheckout = this.nodeService.createNode(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, this.getMyNodeId()), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"test", (String)"test-node-checkedout"), ContentModel.TYPE_CONTENT).getChildRef();
        CheckOutCheckInService coci = (CheckOutCheckInService)this.applicationContext.getBean("CheckOutCheckInService", CheckOutCheckInService.class);
        coci.checkout(nodeForCheckout);
        PublicApiClient.ListResponse<ActionDefinition> actionDefs2 = this.actions.getActionDefinitionsForNode(nodeForCheckout.getId(), emptyParams, 200);
        List actionDefinitions2 = actionDefs2.getList().stream().filter(ad -> ad.getName().equals("check-in")).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)actionDefinitions2.size());
        ActionDefinition action2 = (ActionDefinition)actionDefinitions2.get(0);
        Assert.assertEquals((Object)"check-in", (Object)action2.getId());
        Assert.assertEquals((Object)"check-in", (Object)action2.getName());
        Assert.assertEquals((Object)"Check in", (Object)action2.getTitle());
        Assert.assertEquals((Object)"This will check in the matched content.", (Object)action2.getDescription());
        Assert.assertEquals((long)1L, (long)action2.getApplicableTypes().size());
        Assert.assertEquals((Object)"cm:content", action2.getApplicableTypes().get(0));
        Assert.assertEquals((Object)false, (Object)action2.isTrackStatus());
        Assert.assertEquals((long)2L, (long)action2.getParameterDefinitions().size());
        ActionDefinition.ParameterDefinition paramDefs2 = (ActionDefinition.ParameterDefinition)action2.getParameterDefinitions().get(0);
        Assert.assertEquals((Object)"description", (Object)paramDefs2.getName());
        Assert.assertEquals((Object)"d:text", (Object)paramDefs2.getType());
        Assert.assertEquals((Object)false, (Object)paramDefs2.isMandatory());
        Assert.assertEquals((Object)"Description", (Object)paramDefs2.getDisplayLabel());
        Assert.assertEquals((Object)false, (Object)paramDefs2.isMultiValued());
        Assert.assertEquals(null, (Object)paramDefs2.getParameterConstraintName());
        paramDefs2 = (ActionDefinition.ParameterDefinition)action2.getParameterDefinitions().get(1);
        Assert.assertEquals((Object)"minorChange", (Object)paramDefs2.getName());
        Assert.assertEquals((Object)"d:boolean", (Object)paramDefs2.getType());
        Assert.assertEquals((Object)false, (Object)paramDefs2.isMandatory());
        Assert.assertEquals((Object)"Minor change", (Object)paramDefs2.getDisplayLabel());
        Assert.assertEquals((Object)false, (Object)paramDefs2.isMultiValued());
        Assert.assertEquals(null, (Object)paramDefs2.getParameterConstraintName());
        String myNode = this.getMyNodeId();
        NodeRef validNode = this.nodeService.createNode(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, myNode), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"test", (String)"test-node"), ContentModel.TYPE_CONTENT).getChildRef();
        actionDefs2 = this.actions.getActionDefinitionsForNode(validNode.getId(), emptyParams, 200);
        Assert.assertNotNull((String)"Action definition list should not be null", actionDefs2);
        Assert.assertFalse((String)"Action definition list should not be empty", (boolean)actionDefs2.getList().isEmpty());
        this.checkBasicPagingAndSorting(() -> this.actionService.getActionDefinitions(validNode).stream().sorted(Comparator.comparing(ParameterizedItemDefinition::getName)).map(ParameterizedItemDefinition::getName).collect(Collectors.toList()), paging -> this.actions.getActionDefinitionsForNode(validNode.getId(), this.createParams((PublicApiClient.Paging)paging, null), 200));
        this.checkSorting(() -> this.actionService.getActionDefinitions(validNode).stream().sorted(Comparator.comparing(ParameterizedItemDefinition::getTitle, Comparator.nullsFirst(Comparator.naturalOrder()))).map(act -> new Pair<String, String>(act.getName(), act.getTitle())).collect(Collectors.toList()), (paging, orderBy) -> this.actions.getActionDefinitionsForNode(validNode.getId(), this.createParams((PublicApiClient.Paging)paging, (Map<String, String>)orderBy), 200), "title");
        this.checkSorting(() -> this.actionService.getActionDefinitions(validNode).stream().sorted(Comparator.comparing(ParameterizedItemDefinition::getName, Comparator.nullsFirst(Comparator.naturalOrder()))).map(act -> new Pair<String, String>(act.getName(), act.getTitle())).collect(Collectors.toList()), (paging, orderBy) -> this.actions.getActionDefinitionsForNode(validNode.getId(), this.createParams((PublicApiClient.Paging)paging, (Map<String, String>)orderBy), 200), "name");
        PublicApiClient.Paging paging2 = this.getPaging(0, -1);
        this.actions.getActionDefinitionsForNode(validNode.getId(), this.createParams(paging2, null), 400);
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "750a2867-ecfa-478c-8343-fa0e39d27be3");
        Assert.assertFalse((String)"Test pre-requisite: node must not exist", (boolean)this.nodeService.exists(nodeRef));
        this.actions.getActionDefinitionsForNode(nodeRef.getId(), emptyParams, 404);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1, "invalid-password"));
        this.actions.getActionDefinitionsForNode(validNode.getId(), emptyParams, 401);
    }

    private void checkBasicPagingAndSorting(Supplier<List<String>> expectedNamesFun, CheckedFunction<PublicApiClient.Paging, PublicApiClient.ListResponse<ActionDefinition>, PublicApiException> actionsFun) throws PublicApiException {
        List<String> expectedNames = expectedNamesFun.get();
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        PublicApiClient.ListResponse<ActionDefinition> actionDefs = actionsFun.apply(paging);
        List actionNames = actionDefs.getList().stream().map(ActionDefinition::getName).collect(Collectors.toList());
        Assert.assertEquals(expectedNames, actionNames);
        int pageSize = 2;
        if (expectedNames.size() < 5) {
            Assert.fail((String)"Cannot perform useful paging tests - too few action definitions.");
        } else {
            paging = this.getPaging(0, 2);
            actionDefs = actionsFun.apply(paging);
            Assert.assertEquals((long)2L, (long)actionDefs.getList().size());
            Assert.assertEquals((long)2L, (long)actionDefs.getPaging().getCount().intValue());
            Assert.assertEquals((long)expectedNames.size(), (long)actionDefs.getPaging().getTotalItems().intValue());
            Assert.assertTrue((boolean)actionDefs.getPaging().getHasMoreItems());
            paging = this.getPaging(2, 2, expectedNames.size(), expectedNames.size());
            actionDefs = actionsFun.apply(paging);
            Assert.assertEquals((long)2L, (long)actionDefs.getList().size());
            Assert.assertEquals((long)2L, (long)actionDefs.getPaging().getCount().intValue());
            Assert.assertEquals((long)expectedNames.size(), (long)actionDefs.getPaging().getTotalItems().intValue());
            Assert.assertTrue((boolean)actionDefs.getPaging().getHasMoreItems());
            paging = this.getPaging(expectedNames.size() - 1, 2);
            actionDefs = actionsFun.apply(paging);
            Assert.assertEquals((long)1L, (long)actionDefs.getList().size());
            Assert.assertEquals((long)1L, (long)actionDefs.getPaging().getCount().intValue());
            Assert.assertEquals((long)expectedNames.size(), (long)actionDefs.getPaging().getTotalItems().intValue());
            Assert.assertFalse((boolean)actionDefs.getPaging().getHasMoreItems());
        }
    }

    private void checkSorting(Supplier<List<Pair<String, String>>> expectedFun, CheckedBiFunction<PublicApiClient.Paging, Map<String, String>, PublicApiClient.ListResponse<ActionDefinition>, PublicApiException> actionsFun, String sortField) throws PublicApiException {
        List<Pair<String, String>> expectedActions = expectedFun.get();
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        Map<String, Object> orderBy = Collections.singletonMap("orderBy", sortField);
        PublicApiClient.ListResponse<ActionDefinition> actionDefs = actionsFun.apply(paging, orderBy);
        List retrievedActions = actionDefs.getList().stream().map(act -> new Pair<String, String>(act.getName(), act.getTitle())).collect(Collectors.toList());
        Assert.assertEquals(expectedActions, retrievedActions);
        orderBy = Collections.singletonMap("orderBy", sortField + " asc");
        actionDefs = actionsFun.apply(paging, orderBy);
        retrievedActions = actionDefs.getList().stream().map(act -> new Pair<String, String>(act.getName(), act.getTitle())).collect(Collectors.toList());
        Assert.assertEquals(expectedActions, retrievedActions);
        orderBy = Collections.singletonMap("orderBy", sortField + " desc");
        actionDefs = actionsFun.apply(paging, orderBy);
        retrievedActions = actionDefs.getList().stream().map(act -> new Pair<String, String>(act.getName(), act.getTitle())).collect(Collectors.toList());
        Collections.reverse(expectedActions);
        Assert.assertEquals(expectedActions, retrievedActions);
        int pageSize = 2;
        paging = this.getPaging(2, 2);
        actionDefs = actionsFun.apply(paging, orderBy);
        retrievedActions = actionDefs.getList().stream().map(act -> new Pair<String, String>(act.getName(), act.getTitle())).collect(Collectors.toList());
        Assert.assertEquals(expectedActions.subList(2, 4), retrievedActions);
    }

    @Test
    public void testExecuteAction() throws Throwable {
        String person1 = this.account1PersonIt.next();
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1));
        AuthenticationUtil.setFullyAuthenticatedUser((String)person1);
        String myNode = this.getMyNodeId();
        final NodeRef validNode = this.nodeService.createNode(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, myNode), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"test", (String)"test-ea-node"), ContentModel.TYPE_CONTENT).getChildRef();
        this.actions.executeAction(new Action(), emptyParams, 400);
        Action action = new Action();
        action.setActionDefinitionId("nonExistentActionDefId");
        this.actions.executeAction(action, emptyParams, 404);
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "750a2867-ecfa-478c-8343-fa0e39d27be3");
        Assert.assertFalse((String)"Test pre-requisite: node must not exist", (boolean)this.nodeService.exists(nodeRef));
        Action action2 = new Action();
        action2.setActionDefinitionId("add-features");
        action2.setTargetId(nodeRef.getId());
        this.actions.executeAction(action2, emptyParams, 404);
        action = new Action();
        action.setActionDefinitionId("add-features");
        action.setTargetId(validNode.getId());
        this.actions.executeAction(action, emptyParams, 202);
        Thread.sleep(1000L);
        Assert.assertFalse((String)"Aspect versionable wasn't expected !", (boolean)this.nodeService.hasAspect(validNode, ContentModel.ASPECT_VERSIONABLE));
        Assert.assertFalse((boolean)this.nodeService.hasAspect(validNode, ContentModel.ASPECT_VERSIONABLE));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("aspect-name", "cm:versionable");
        action2 = new Action();
        action2.setActionDefinitionId("add-features");
        action2.setTargetId(validNode.getId());
        action2.setParams(params);
        Action executedAction = this.actions.executeAction(action2, emptyParams, 202);
        Assert.assertNotNull((Object)executedAction);
        Assert.assertNotNull((Object)executedAction.getId());
        RetryingCallbackHelper retryingCallbackHelper = new RetryingCallbackHelper();
        retryingCallbackHelper.setRetryWaitMs(500);
        RetryingCallbackHelper.RetryingCallback retryingCallback = new RetryingCallbackHelper.RetryingCallback(){

            public Void execute() throws Throwable {
                Assert.assertTrue((String)"Expected aspect versionable!", (boolean)TestActions.this.nodeService.hasAspect(validNode, ContentModel.ASPECT_VERSIONABLE));
                return null;
            }
        };
        retryingCallbackHelper.doWithRetry(retryingCallback);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1, "invalid-password"));
        this.actions.executeAction(new Action(), emptyParams, 401);
    }

    @FunctionalInterface
    private static interface CheckedFunction<T, U, V extends Exception> {
        public U apply(T var1) throws V;
    }

    @FunctionalInterface
    private static interface CheckedBiFunction<T, U, V, W extends Exception> {
        public V apply(T var1, U var2) throws W;
    }
}

