/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.rules;

import java.util.List;
import org.alfresco.rest.api.Rules;
import org.alfresco.rest.api.model.rules.Rule;
import org.alfresco.rest.api.rules.NodeRuleSetsRelation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.Experimental;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="rules", entityResource=NodeRuleSetsRelation.class, title="Folder node rules")
@Experimental
public class NodeRulesRelation
implements RelationshipResourceAction.Read<Rule>,
RelationshipResourceAction.ReadById<Rule>,
RelationshipResourceAction.Create<Rule>,
RelationshipResourceAction.Update<Rule>,
RelationshipResourceAction.Delete,
InitializingBean {
    private Rules rules;

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"rules", (Object)this.rules);
    }

    @Override
    @WebApiDescription(title="Get folder node rules", description="Returns a paged list of folder rules for given node's and rule set's IDs", successStatus=200)
    public CollectionWithPagingInfo<Rule> readAll(String folderNodeId, Parameters parameters) {
        String ruleSetId = parameters.getRelationshipId();
        return this.rules.getRules(folderNodeId, ruleSetId, parameters.getInclude(), parameters.getPaging());
    }

    @Override
    @WebApiDescription(title="Get folder node rule", description="Returns a folder single rule definition for given node's, rule set's and rule's IDs", successStatus=200)
    public Rule readById(String folderNodeId, String ruleSetId, Parameters parameters) throws RelationshipResourceNotFoundException {
        String ruleId = parameters.getRelationship2Id();
        return this.rules.getRuleById(folderNodeId, ruleSetId, ruleId, parameters.getInclude());
    }

    @Override
    @WebApiDescription(title="Create folder rule", description="Creates one or more folder rules for the given folder and rule set", successStatus=201)
    public List<Rule> create(String folderNodeId, List<Rule> ruleList, Parameters parameters) {
        String ruleSetId = parameters.getRelationshipId();
        return this.rules.createRules(folderNodeId, ruleSetId, ruleList, parameters.getInclude());
    }

    @Override
    @WebApiDescription(title="Update folder node rule", description="Update a single rule definition for given node's, rule set's and rule's IDs", successStatus=200)
    public Rule update(String folderNodeId, Rule rule, Parameters parameters) {
        String ruleSetId = parameters.getRelationshipId();
        String ruleId = parameters.getRelationship2Id();
        return this.rules.updateRuleById(folderNodeId, ruleSetId, ruleId, rule, parameters.getInclude());
    }

    @Override
    @WebApiDescription(title="Delete folder node rule", description="Deletes a single rule definition for given node's, rule set's and rule's IDs", successStatus=204)
    public void delete(String folderNodeId, String ruleSetId, Parameters parameters) {
        String ruleId = parameters.getRelationship2Id();
        this.rules.deleteRuleById(folderNodeId, ruleSetId, ruleId);
    }

    public void setRules(Rules rules) {
        this.rules = rules;
    }
}

