/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.alfresco.repo.web.scripts.BufferedResponse;
import org.alfresco.repo.web.scripts.TempOutputStream;
import org.alfresco.util.TempFileProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BufferedResponseTest {
    private static final String TEMP_FOLDER_PATH = TempFileProvider.getTempDir().getAbsolutePath();
    private static final String TEMP_DIRECTORY_NAME = "testLargeFile";
    private static final String LARGE_FILE_NAME = "largeFile.tmp";
    private static final String FILE_PREFIX = "tempStreamFile-";
    private static final Integer LARGE_FILE_SIZE_BYTES = 0x500000;
    private static final Integer MEMORY_THRESHOLD = 0x400000;
    private static final Integer MAX_CONTENT_SIZE = 0x40000000;

    @Before
    public void createSourceFile() throws IOException {
        this.createRandomFileInDirectory(TEMP_FOLDER_PATH, LARGE_FILE_NAME, LARGE_FILE_SIZE_BYTES);
    }

    @After
    public void tearDown() throws Exception {
        File largeFileSource = new File(TEMP_FOLDER_PATH, LARGE_FILE_NAME);
        largeFileSource.delete();
    }

    @Test
    public void testOutputStream() throws IOException {
        File bufferTempDirectory = TempFileProvider.getTempDir((String)TEMP_DIRECTORY_NAME);
        Supplier streamFactory = TempOutputStream.factory((File)bufferTempDirectory, (int)MEMORY_THRESHOLD, (long)MAX_CONTENT_SIZE.intValue(), (boolean)false);
        long countBefore = this.countFilesInDirectoryWithPrefix(bufferTempDirectory, FILE_PREFIX);
        try (BufferedResponse response = new BufferedResponse(null, 0, streamFactory);){
            this.copyFileToOutputStream(response);
            long countBeforeClose = this.countFilesInDirectoryWithPrefix(bufferTempDirectory, FILE_PREFIX);
            response.getOutputStream().close();
            long countAfterClose = this.countFilesInDirectoryWithPrefix(bufferTempDirectory, FILE_PREFIX);
            Assert.assertEquals((long)(countBefore + 1L), (long)countBeforeClose);
            Assert.assertEquals((long)(countBefore + 1L), (long)countAfterClose);
        }
        long countAfterDestroy = this.countFilesInDirectoryWithPrefix(bufferTempDirectory, FILE_PREFIX);
        Assert.assertEquals((long)countBefore, (long)countAfterDestroy);
    }

    private void copyFileToOutputStream(BufferedResponse response) throws IOException {
        File largeFileSource = new File(TEMP_FOLDER_PATH, LARGE_FILE_NAME);
        OutputStream testOutputStream = response.getOutputStream();
        Files.copy(largeFileSource.toPath(), testOutputStream);
    }

    private void createRandomFileInDirectory(String path, String fileName, int size2) throws IOException {
        String fullPath = new File(path, fileName).getPath();
        RandomAccessFile file = new RandomAccessFile(fullPath, "rw");
        file.setLength(size2);
        file.close();
    }

    private long countFilesInDirectoryWithPrefix(File directory, String filePrefix) throws IOException {
        Stream<File> fileStream = Arrays.stream(directory.listFiles());
        return fileStream.filter(f -> f.getName().startsWith(filePrefix)).count();
    }
}

