/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;

public class OptionsMethod
extends WebDAVMethod {
    private static final String DAV_HEADER = "DAV";
    private static final String DAV_HEADER_CONTENT = "1,2";
    private static final String ALLOW_HEADER = "Allow";
    private static final String MS_HEADER = "MS-Author-Via";
    private static final String FILE_METHODS = "OPTIONS, GET, HEAD, POST, DELETE, PROPFIND, PROPPATCH, COPY, MOVE, LOCK, UNLOCK";
    private static final String COLLECTION_METHODS = "OPTIONS, GET, HEAD, POST, DELETE, PROPFIND, PROPPATCH, COPY, MOVE, LOCK, UNLOCK, PUT";

    @Override
    protected void parseRequestHeaders() throws WebDAVServerException {
    }

    @Override
    protected void parseRequestBody() throws WebDAVServerException {
    }

    @Override
    protected boolean isReadOnly() {
        return true;
    }

    @Override
    protected void executeImpl() throws WebDAVServerException {
        Boolean isFolder = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws FileNotFoundException {
                try {
                    FileInfo fileInfo = OptionsMethod.this.getDAVHelper().getNodeForPath(OptionsMethod.this.getRootNodeRef(), OptionsMethod.this.getPath());
                    return fileInfo.isFolder();
                }
                catch (FileNotFoundException e) {
                    return true;
                }
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        this.m_response.addHeader(DAV_HEADER, DAV_HEADER_CONTENT);
        this.m_response.addHeader(MS_HEADER, DAV_HEADER);
        this.m_response.addHeader(ALLOW_HEADER, isFolder != false ? COLLECTION_METHODS : FILE_METHODS);
    }
}

