/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.links;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.links.AbstractLinksWebScript;
import org.alfresco.service.cmr.links.LinkInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class LinksListGet
extends AbstractLinksWebScript {
    protected static final int RECENT_SEARCH_PERIOD_DAYS = 7;
    protected static final long ONE_DAY_MS = 86400000L;

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String linkName, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        NodeRef container;
        String filter = req.getParameter("filter");
        boolean tagFiltering = true;
        String tag = req.getParameter("tag");
        if (tag == null || tag.length() == 0) {
            tagFiltering = false;
        }
        boolean userFiltering = false;
        String user = null;
        if ("user".equals(filter)) {
            userFiltering = true;
            user = AuthenticationUtil.getFullyAuthenticatedUser();
        }
        boolean dateFiltering = false;
        Date from = null;
        Date to = null;
        if ("recent".equals(filter)) {
            dateFiltering = true;
            Date now = new Date();
            from = new Date(now.getTime() - 604800000L);
            to = new Date(now.getTime() + 86400000L);
        }
        PagingRequest paging = this.buildPagingRequest(req);
        paging.setRequestTotalCountMax(paging.getSkipCount() + paging.getRequestTotalCountMax());
        PagingResults links = tagFiltering ? this.linksService.findLinks(site.getShortName(), user, from, to, tag, paging) : (userFiltering ? this.linksService.listLinks(site.getShortName(), user, paging) : (dateFiltering ? this.linksService.listLinks(site.getShortName(), from, to, paging) : this.linksService.listLinks(site.getShortName(), paging)));
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        for (LinkInfo link : links.getPage()) {
            Map<String, Object> result = this.renderLink(link);
            items.add(result);
        }
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        data.put("items", items);
        data.put("pageSize", Integer.valueOf(paging.getMaxItems()));
        data.put("startIndex", Integer.valueOf(paging.getSkipCount()));
        data.put("itemCount", Integer.valueOf(items.size()));
        int total = items.size();
        if (links.getTotalResultCount() != null && links.getTotalResultCount().getFirst() != null) {
            total = (Integer)links.getTotalResultCount().getFirst();
        }
        data.put("total", Integer.valueOf(total));
        if (total == paging.getRequestTotalCountMax()) {
            data.put("totalRecordsUpper", Boolean.valueOf(true));
        } else {
            data.put("totalRecordsUpper", Boolean.valueOf(false));
        }
        if (links.getPage().size() > 0) {
            container = ((LinkInfo)links.getPage().get(0)).getContainerNodeRef();
        } else {
            container = this.siteService.getContainer(site.getShortName(), "links");
            if (container == null) {
                container = site.getNodeRef();
            }
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("data", data);
        model.put("links", container);
        model.put("siteId", site.getShortName());
        model.put("site", site);
        return model;
    }
}

