/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Properties;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.web.app.servlet.AlfrescoX509ServletFilter;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AlfrescoX509ServletFilterTest {
    private static final String BEAN_GLOBAL_PROPERTIES = "global-properties";
    private static final String PROP_SECURE_COMMS = "solr.secureComms";
    private static final String PROP_SHARED_SECRET = "solr.sharedSecret";
    private static final String PROP_SHARED_SECRET_HEADER = "solr.sharedSecret.header";
    private static final String SHARED_SECRET_HEADER = "X-Alfresco-Search-Secret";
    private static final String SECRET = "secret";
    private static final String ALLOW_UNAUTHORIZED_SOLR_ENDPOINT = "allow-unauthenticated-solr-endpoint";
    private static final String MISSING_SHARED_SECRET_EXCEPTION_MSG = "Missing value for solr.sharedSecret configuration property";
    private static final String MISSING_SHARED_SECRET_HEADER_EXCEPTION_MSG = "Missing value for sharedSecretHeader";
    private static final String SECURE_COMMS_NONE_IS_NOT_SUPPORTED_EXCEPTION_MSG = "solr.secureComms=none is no longer supported. Please use https or secret";
    private FilterConfig filterConfig;
    private Properties globalProperties;
    private AlfrescoX509ServletFilter filter;

    @Before
    public void before() {
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        WebApplicationContext webApplicationContext = (WebApplicationContext)Mockito.mock(WebApplicationContext.class);
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Properties globalProperties = (Properties)Mockito.mock(Properties.class);
        Mockito.when((Object)servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE)).thenReturn((Object)webApplicationContext);
        Mockito.when((Object)filterConfig.getServletContext()).thenReturn((Object)servletContext);
        Mockito.when((Object)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext())).thenReturn((Object)webApplicationContext);
        Mockito.when((Object)webApplicationContext.getBean(BEAN_GLOBAL_PROPERTIES)).thenReturn((Object)globalProperties);
        this.filterConfig = filterConfig;
        this.globalProperties = globalProperties;
        this.filter = new AlfrescoX509ServletFilter();
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testSharedSecretIsEmpty() throws ServletException {
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SECURE_COMMS)).thenReturn((Object)HttpClientFactory.SecureCommsType.SECRET.name());
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SHARED_SECRET)).thenReturn((Object)"");
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SHARED_SECRET_HEADER)).thenReturn((Object)SHARED_SECRET_HEADER);
        try {
            this.filter.init(this.filterConfig);
        }
        catch (AlfrescoRuntimeException ex) {
            TestCase.assertEquals((String)MISSING_SHARED_SECRET_EXCEPTION_MSG, (String)ex.getMsgId());
            throw ex;
        }
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testSharedSecretIsNull() throws ServletException {
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SECURE_COMMS)).thenReturn((Object)HttpClientFactory.SecureCommsType.SECRET.name());
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SHARED_SECRET)).thenReturn(null);
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SHARED_SECRET_HEADER)).thenReturn((Object)SHARED_SECRET_HEADER);
        try {
            this.filter.init(this.filterConfig);
        }
        catch (AlfrescoRuntimeException ex) {
            TestCase.assertEquals((String)MISSING_SHARED_SECRET_EXCEPTION_MSG, (String)ex.getMsgId());
            throw ex;
        }
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testSharedSecretHeaderIsEmpty() throws ServletException {
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SECURE_COMMS)).thenReturn((Object)HttpClientFactory.SecureCommsType.SECRET.name());
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SHARED_SECRET)).thenReturn((Object)SECRET);
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SHARED_SECRET_HEADER)).thenReturn((Object)"");
        try {
            this.filter.init(this.filterConfig);
        }
        catch (AlfrescoRuntimeException ex) {
            TestCase.assertEquals((String)MISSING_SHARED_SECRET_HEADER_EXCEPTION_MSG, (String)ex.getMsgId());
            throw ex;
        }
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testSharedSecretHeaderIsNull() throws ServletException {
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SECURE_COMMS)).thenReturn((Object)HttpClientFactory.SecureCommsType.SECRET.name());
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SHARED_SECRET)).thenReturn((Object)SECRET);
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SHARED_SECRET_HEADER)).thenReturn((Object)"");
        try {
            this.filter.init(this.filterConfig);
        }
        catch (AlfrescoRuntimeException ex) {
            TestCase.assertEquals((String)MISSING_SHARED_SECRET_HEADER_EXCEPTION_MSG, (String)ex.getMsgId());
            throw ex;
        }
    }

    @Test
    public void testSharedSecretProperlyConfigured() throws ServletException {
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SECURE_COMMS)).thenReturn((Object)HttpClientFactory.SecureCommsType.SECRET.name());
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SHARED_SECRET)).thenReturn((Object)SECRET);
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SHARED_SECRET_HEADER)).thenReturn((Object)SHARED_SECRET_HEADER);
        this.filter.init(this.filterConfig);
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testSecureCommsNoneAndNotAllowUnauthenticatedSolrEndpoint() throws ServletException {
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SECURE_COMMS)).thenReturn((Object)HttpClientFactory.SecureCommsType.NONE.name());
        Mockito.when((Object)this.filterConfig.getInitParameter(ALLOW_UNAUTHORIZED_SOLR_ENDPOINT)).thenReturn((Object)"false");
        try {
            this.filter.init(this.filterConfig);
        }
        catch (AlfrescoRuntimeException ex) {
            TestCase.assertEquals((String)SECURE_COMMS_NONE_IS_NOT_SUPPORTED_EXCEPTION_MSG, (String)ex.getMsgId());
            throw ex;
        }
    }

    @Test
    public void testSecureCommsNoneAndAllowUnauthenticatedSolrEndpoint() throws ServletException {
        Mockito.when((Object)this.globalProperties.getProperty(PROP_SECURE_COMMS)).thenReturn((Object)HttpClientFactory.SecureCommsType.NONE.name());
        Mockito.when((Object)this.filterConfig.getInitParameter(ALLOW_UNAUTHORIZED_SOLR_ENDPOINT)).thenReturn((Object)"true");
        this.filter.init(this.filterConfig);
    }
}

