/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceDictionary;
import org.alfresco.rest.framework.core.ResourceDictionaryBuilder;
import org.alfresco.rest.framework.core.ResourceLookupDictionary;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:test-rest-context.xml"})
public class SecondLevelRelationshipTests {
    @Autowired
    ResourceLookupDictionary locator;
    @Autowired
    private ApplicationContext applicationContext;
    private static Api api = Api.valueOf((String)"alfrescomockabc", (String)"private", (String)"1");

    @Before
    public void setUp() throws Exception {
        Map entityResourceBeans = this.applicationContext.getBeansWithAnnotation(EntityResource.class);
        Map relationResourceBeans = this.applicationContext.getBeansWithAnnotation(RelationshipResource.class);
        this.locator.setDictionary(ResourceDictionaryBuilder.build(entityResourceBeans.values(), relationResourceBeans.values()));
    }

    @Test
    public void testLocateRelationResource() {
        HashMap<String, String> templateVars = new HashMap<String, String>();
        templateVars.put("collectionResource", "type-a1");
        ResourceWithMetadata collResource = this.locator.locateResource(api, templateVars, HttpMethod.GET);
        Assert.assertNotNull((Object)collResource);
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.GET));
        templateVars = new HashMap();
        templateVars.put("collectionResource", "type-b1");
        collResource = this.locator.locateResource(api, templateVars, HttpMethod.GET);
        Assert.assertNotNull((Object)collResource);
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.GET));
        templateVars = new HashMap();
        templateVars.put("collectionResource", "type-b2");
        collResource = this.locator.locateResource(api, templateVars, HttpMethod.GET);
        Assert.assertNotNull((Object)collResource);
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.GET));
        templateVars = new HashMap();
        templateVars.put("collectionResource", "type-c1");
        collResource = this.locator.locateResource(api, templateVars, HttpMethod.GET);
        Assert.assertNotNull((Object)collResource);
        Assert.assertNotNull((Object)collResource.getMetaData().getOperation(HttpMethod.GET));
        List<String> relKeys = Arrays.asList("relation-a1-b1", "relation-a1-b2");
        Map embeds = this.locator.locateRelationResource(api, "type-a1", relKeys, HttpMethod.GET);
        Assert.assertNotNull((Object)embeds);
    }

    @Test
    public void testLocateRelationResource2() {
        String relKey = ResourceDictionary.resourceKey((String)"relation-a1-b1", (String)"relation-b1-c1");
        List<String> relKeys = Arrays.asList(relKey);
        Map embeds = this.locator.locateRelationResource(api, "type-a1", relKeys, HttpMethod.GET);
        Assert.assertNotNull((Object)embeds);
    }
}

