/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.model.filefolder;

import java.io.IOException;
import java.io.OutputStream;
import org.alfresco.repo.model.filefolder.FileFolderLoader;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class FileFolderLoaderPost
extends AbstractWebScript
implements ApplicationContextAware {
    public static final String KEY_FOLDER_PATH = "folderPath";
    public static final String KEY_FILE_COUNT = "fileCount";
    public static final String KEY_FILES_PER_TXN = "filesPerTxn";
    public static final String KEY_MIN_FILE_SIZE = "minFileSize";
    public static final String KEY_MAX_FILE_SIZE = "maxFileSize";
    public static final String KEY_MAX_UNIQUE_DOCUMENTS = "maxUniqueDocuments";
    public static final String KEY_FORCE_BINARY_STORAGE = "forceBinaryStorage";
    public static final String KEY_DESCRIPTION_COUNT = "descriptionCount";
    public static final String KEY_DESCRIPTION_SIZE = "descriptionSize";
    public static final String KEY_COUNT = "count";
    public static final int DEFAULT_FILE_COUNT = 100;
    public static final int DEFAULT_FILES_PER_TXN = 100;
    public static final long DEFAULT_MIN_FILE_SIZE = 81920L;
    public static final long DEFAULT_MAX_FILE_SIZE = 122880L;
    public static final long DEFAULT_MAX_UNIQUE_DOCUMENTS = Long.MAX_VALUE;
    public static final int DEFAULT_DESCRIPTION_COUNT = 1;
    public static final long DEFAULT_DESCRIPTION_SIZE = 128L;
    public static final boolean DEFAULT_FORCE_BINARY_STORAGE = false;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        FileFolderLoader loader = (FileFolderLoader)this.applicationContext.getBean("fileFolderLoader");
        int count = 0;
        String folderPath = "";
        try {
            JSONObject json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            folderPath = json.getString(KEY_FOLDER_PATH);
            if (folderPath == null) {
                throw new WebScriptException(400, "folderPath not supplied.");
            }
            int fileCount = 100;
            if (json.has(KEY_FILE_COUNT)) {
                fileCount = json.getInt(KEY_FILE_COUNT);
            }
            int filesPerTxn = 100;
            if (json.has(KEY_FILES_PER_TXN)) {
                filesPerTxn = json.getInt(KEY_FILES_PER_TXN);
            }
            long minFileSize = 81920L;
            if (json.has(KEY_MIN_FILE_SIZE)) {
                minFileSize = json.getInt(KEY_MIN_FILE_SIZE);
            }
            long maxFileSize = 122880L;
            if (json.has(KEY_MAX_FILE_SIZE)) {
                maxFileSize = json.getInt(KEY_MAX_FILE_SIZE);
            }
            long maxUniqueDocuments = Long.MAX_VALUE;
            if (json.has(KEY_MAX_UNIQUE_DOCUMENTS)) {
                maxUniqueDocuments = json.getInt(KEY_MAX_UNIQUE_DOCUMENTS);
            }
            boolean forceBinaryStorage = false;
            if (json.has(KEY_FORCE_BINARY_STORAGE)) {
                forceBinaryStorage = json.getBoolean(KEY_FORCE_BINARY_STORAGE);
            }
            int descriptionCount = 1;
            if (json.has(KEY_DESCRIPTION_COUNT)) {
                descriptionCount = json.getInt(KEY_DESCRIPTION_COUNT);
            }
            long descriptionSize = 128L;
            if (json.has(KEY_DESCRIPTION_SIZE)) {
                descriptionSize = json.getLong(KEY_DESCRIPTION_SIZE);
            }
            count = loader.createFiles(folderPath, fileCount, filesPerTxn, minFileSize, maxFileSize, maxUniqueDocuments, forceBinaryStorage, descriptionCount, descriptionSize);
        }
        catch (FileNotFoundException e) {
            throw new WebScriptException(404, "Folder not found: ", new Object[]{folderPath});
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        try (OutputStream os = res.getOutputStream();){
            JSONObject json = new JSONObject();
            json.put(KEY_COUNT, count);
            os.write(json.toString().getBytes("UTF-8"));
        }
        catch (JSONException e) {
            throw new WebScriptException(500, "Failed to write JSON", (Throwable)e);
        }
    }
}

