/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.springframework.context.ApplicationContext;

public class OpenCMISClientContext {
    private Map<String, String> cmisParameters = new HashMap<String, String>();

    public OpenCMISClientContext(BindingType bindingType, String url, String username, String password, Map<String, String> parameters, ApplicationContext ctx) throws IOException {
        this.cmisParameters.putAll(parameters);
        this.cmisParameters.put("org.apache.chemistry.opencmis.binding.spi.type", bindingType.value());
        if (bindingType.equals((Object)BindingType.ATOMPUB)) {
            this.cmisParameters.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
        } else if (bindingType.equals((Object)BindingType.BROWSER)) {
            this.cmisParameters.put("org.apache.chemistry.opencmis.binding.browser.url", url);
        }
        this.cmisParameters.put("org.apache.chemistry.opencmis.user", username);
        this.cmisParameters.put("org.apache.chemistry.opencmis.password", password);
        if (ctx != null) {
            Properties properties = (Properties)ctx.getBean("global-properties");
            this.cmisParameters.put("org.apache.chemistry.opencmis.binding.connecttimeout", properties.getProperty("opencmis.tck.connecttimeout"));
            this.cmisParameters.put("org.apache.chemistry.opencmis.binding.readtimeout", properties.getProperty("opencmis.tck.readtimeout"));
        }
        this.createCMISParametersFile();
    }

    public OpenCMISClientContext(BindingType bindingType, String url, String username, String password, Map<String, String> parameters) throws IOException {
        this(bindingType, url, username, password, parameters, null);
    }

    protected void createCMISParametersFile() throws IOException {
        File f = File.createTempFile("OpenCMISTCKContext", "" + System.currentTimeMillis(), new File(System.getProperty("java.io.tmpdir")));
        f.deleteOnExit();
        FileWriter fw = new FileWriter(f);
        for (String key : this.cmisParameters.keySet()) {
            fw.append(key);
            fw.append("=");
            fw.append(this.cmisParameters.get(key));
            fw.append("\n");
        }
        fw.close();
        System.setProperty("org.apache.chemistry.opencmis.tck.junit.parameters", f.getAbsolutePath());
        System.out.println("CMIS client parameters file: " + f.getAbsolutePath());
    }

    public Map<String, String> getCMISParameters() {
        return this.cmisParameters;
    }
}

