/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.quicksharelinks;

import org.alfresco.rest.api.QuickShareLinks;
import org.alfresco.rest.api.model.Rendition;
import org.alfresco.rest.api.quicksharelinks.QuickShareLinkEntityResource;
import org.alfresco.rest.framework.BinaryProperties;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiNoAuth;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceBinaryAction;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="renditions", entityResource=QuickShareLinkEntityResource.class, title="Node renditions via shared link")
public class QuickShareLinkRenditionsRelation
implements RelationshipResourceAction.Read<Rendition>,
RelationshipResourceAction.ReadById<Rendition>,
RelationshipResourceBinaryAction.Read,
InitializingBean {
    private QuickShareLinks quickShareLinks;

    public void setQuickShareLinks(QuickShareLinks quickShareLinks) {
        this.quickShareLinks = quickShareLinks;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"quickShareLinks", (Object)this.quickShareLinks);
    }

    @Override
    @WebApiDescription(title="Download shared link rendition", description="Download rendition for shared link")
    @WebApiNoAuth
    @BinaryProperties(value={"content"})
    public BinaryResource readProperty(String sharedId, String renditionId, Parameters parameters) {
        return this.quickShareLinks.readProperty(sharedId, renditionId, parameters);
    }

    @Override
    @WebApiDescription(title="List renditions", description="List available (created) renditions")
    @WebApiNoAuth
    public CollectionWithPagingInfo<Rendition> readAll(String sharedId, Parameters parameters) {
        return this.quickShareLinks.getRenditions(sharedId);
    }

    @Override
    @WebApiDescription(title="Retrieve rendition information", description="Retrieve (created) rendition information")
    @WebApiNoAuth
    public Rendition readById(String entityResourceId, String id, Parameters parameters) {
        return this.quickShareLinks.getRendition(entityResourceId, id);
    }
}

