/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Folder;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.client.data.Tag;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class QueriesNodesApiTest
extends AbstractSingleNetworkSiteTest {
    private static final String URL_QUERIES_LSN = "queries/nodes";
    private static final String DEAFULT_QUERY = "\"%s\" AND (+TYPE:\"cm:content\" OR +TYPE:\"cm:folder\") AND -TYPE:\"cm:thumbnail\" AND -TYPE:\"cm:failedThumbnail\" AND -TYPE:\"cm:rating\" AND -TYPE:\"fm:post\" AND -TYPE:\"st:site\" AND -ASPECT:\"st:siteContainer\" AND -ASPECT:\"sys:hidden\" AND -cm:creator:system AND -QNAME:comment\\-* ";
    private static final String NODE_TYPE_QUERY = "\"%s\" AND (+TYPE:\"%s\") AND -ASPECT:\"sys:hidden\" AND -cm:creator:system AND -QNAME:comment\\-* ";
    private static final String ROOT_NODE_QUERY_PREFIX = "PATH:\"";
    private static final String ROOT_NODE_QUERY_SUFFIX = "//*\" AND (\"%s\") AND (+TYPE:\"cm:content\" OR +TYPE:\"cm:folder\") AND -TYPE:\"cm:thumbnail\" AND -TYPE:\"cm:failedThumbnail\" AND -TYPE:\"cm:rating\" AND -TYPE:\"fm:post\" AND -TYPE:\"st:site\" AND -ASPECT:\"st:siteContainer\" AND -ASPECT:\"sys:hidden\" AND -cm:creator:system AND -QNAME:comment\\-* ";

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }

    private List<Node> checkApiCall(String pathRegex, String queryForm, String term, String nodeType, String rootNodeId, String include, String orderBy, PublicApiClient.Paging paging, int expectedStatus, Boolean checkNodeOrderAsc, Boolean propertyNullCheck, List<String> ids) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("term", term);
        if (include != null) {
            params.put("include", include);
        }
        if (nodeType != null) {
            params.put("nodeType", nodeType);
        }
        if (rootNodeId != null) {
            params.put("rootNodeId", rootNodeId);
        }
        if (orderBy != null) {
            params.put("orderBy", orderBy);
        }
        this.dummySearchServiceQueryNodeRefs.clear();
        for (String id : ids) {
            NodeRef nodeRef = this.getNodeRef(id);
            this.dummySearchServiceQueryNodeRefs.add(nodeRef);
        }
        if (orderBy != null) {
            Collections.shuffle(this.dummySearchServiceQueryNodeRefs);
        }
        HttpResponse response = this.getAll(URL_QUERIES_LSN, paging, params, 200);
        List<Node> nodes = null;
        if (expectedStatus == 200) {
            String termWithEscapedAsterisks = term.replaceAll("\\*", "\\\\*").replaceAll("\"", "\\\\\"");
            String expectedQuery = DEAFULT_QUERY.equals(queryForm) ? String.format(DEAFULT_QUERY, termWithEscapedAsterisks) : (NODE_TYPE_QUERY.equals(queryForm) ? String.format(NODE_TYPE_QUERY, termWithEscapedAsterisks, nodeType) : (ROOT_NODE_QUERY_SUFFIX.equals(queryForm) ? String.format(ROOT_NODE_QUERY_SUFFIX, termWithEscapedAsterisks) : "TODO"));
            ArgumentCaptor searchParametersCaptor = ArgumentCaptor.forClass(SearchParameters.class);
            ((SearchService)Mockito.verify((Object)this.mockSearchService, (VerificationMode)Mockito.times((int)(++this.callCountToMockSearchService)))).query((SearchParameters)searchParametersCaptor.capture());
            SearchParameters parameters = (SearchParameters)searchParametersCaptor.getValue();
            String query = parameters.getQuery();
            if (ROOT_NODE_QUERY_SUFFIX.equals(queryForm)) {
                Assert.assertNotNull((Object)query);
                Assert.assertTrue((String)("Query should have started with PATH:\" but was " + query), (boolean)query.startsWith(ROOT_NODE_QUERY_PREFIX));
                Assert.assertTrue((String)("Query should have ended with " + expectedQuery + " but was " + query), (boolean)query.endsWith(expectedQuery));
                String path = query.substring(ROOT_NODE_QUERY_PREFIX.length(), query.length() - expectedQuery.length());
                Assert.assertTrue((String)("Query path should match " + pathRegex + " but was " + path), (boolean)Pattern.matches(pathRegex, path));
            } else {
                Assert.assertEquals((String)"Query", (Object)expectedQuery, (Object)query);
            }
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            this.checkNodeIds(nodes, ids, checkNodeOrderAsc);
            if (propertyNullCheck != null) {
                for (Node node : nodes) {
                    if (propertyNullCheck.booleanValue()) {
                        Assert.assertNull(node.getAspectNames());
                        Assert.assertNull(node.getProperties());
                        Assert.assertNull((Object)node.getPath());
                        Assert.assertNull((Object)node.getIsLink());
                        continue;
                    }
                    Assert.assertNotNull(node.getAspectNames());
                    Assert.assertNotNull(node.getProperties());
                    Assert.assertNotNull((Object)node.getPath());
                    Assert.assertNotNull((Object)node.getIsLink());
                }
            }
        }
        return nodes;
    }

    private NodeRef getNodeRef(String id) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)user1);
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, id);
        nodeRef = this.tenantService.getName(nodeRef);
        return nodeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiveSearchNodes_FTS_and_Metadata() throws Exception {
        this.setRequestContext(user1);
        int f1Count = 5;
        ArrayList<String> f1NodeIds = new ArrayList<String>(f1Count);
        int f2Count = 3;
        ArrayList<String> f2NodeIds = new ArrayList<String>(f2Count);
        int f3Count = 4;
        ArrayList<String> f3NodeIds = new ArrayList<String>(f3Count);
        int totalCount = f1Count + f2Count + f3Count;
        ArrayList<String> allIds = new ArrayList<String>(totalCount);
        String testTerm = "abc123basic";
        try {
            Document doc;
            String docName;
            String num;
            String contentText;
            int i;
            PublicApiClient.Paging paging = this.getPaging(0, 100);
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("term", testTerm);
            String myFolderNodeId = this.getMyNodeId();
            String f1Id = this.createFolder(myFolderNodeId, "folder 1").getId();
            String f2Id = this.createFolder(myFolderNodeId, "folder 2").getId();
            String name = "name";
            String title = "title";
            String descrip = "descrip";
            String folderNameSuffix = " " + testTerm + " folder";
            String txtSuffix = ".txt";
            HashMap<String, CallSite> idNameMap = new HashMap<String, CallSite>();
            HashMap<String, List<String>> textIdMap = new HashMap<String, List<String>>();
            int nameIdx = f1Count;
            for (i = 1; i <= f1Count; ++i) {
                contentText = "f1 " + testTerm + " test document " + user1 + " document " + i;
                num = String.format("%05d", nameIdx);
                docName = name + num + name + txtSuffix;
                HashMap<String, String> docProps = new HashMap<String, String>(2);
                docProps.put("cm:title", title + num + title);
                docProps.put("cm:description", descrip + num + descrip);
                doc = this.createTextFile(f1Id, docName, contentText, "UTF-8", docProps);
                f1NodeIds.add(doc.getId());
                idNameMap.put(doc.getId(), (CallSite)((Object)docName));
                this.addTo(textIdMap, name + num + name, doc.getId());
                this.addTo(textIdMap, docName, doc.getId());
                this.addTo(textIdMap, (String)docProps.get("cm:title"), doc.getId());
                this.addTo(textIdMap, (String)docProps.get("cm:description"), doc.getId());
                --nameIdx;
            }
            nameIdx = f2Count;
            for (i = 1; i <= f2Count; ++i) {
                contentText = "f2 " + testTerm + " test document";
                num = String.format("%05d", nameIdx);
                docName = name + num + name + txtSuffix;
                HashMap<String, String> props = new HashMap<String, String>(2);
                props.put("cm:title", title + num + title);
                props.put("cm:description", descrip + num + descrip);
                doc = this.createTextFile(f2Id, docName, contentText, "UTF-8", props);
                f2NodeIds.add(doc.getId());
                idNameMap.put(doc.getId(), (CallSite)((Object)docName));
                this.addTo(textIdMap, name + num + name, doc.getId());
                this.addTo(textIdMap, docName, doc.getId());
                this.addTo(textIdMap, (String)props.get("cm:title"), doc.getId());
                this.addTo(textIdMap, (String)props.get("cm:description"), doc.getId());
                --nameIdx;
            }
            nameIdx = f3Count;
            for (i = 1; i <= f3Count; ++i) {
                String num2 = String.format("%05d", nameIdx);
                String folderName = name + num2 + name + folderNameSuffix;
                HashMap<String, Object> props = new HashMap<String, Object>(2);
                props.put("cm:title", title + num2 + title);
                props.put("cm:description", descrip + num2 + descrip);
                Node node = this.createFolder(myFolderNodeId, folderName, props);
                f3NodeIds.add(node.getId());
                idNameMap.put(node.getId(), (CallSite)((Object)folderName));
                this.addTo(textIdMap, name + num2 + name, node.getId());
                this.addTo(textIdMap, folderName, node.getId());
                this.addTo(textIdMap, (String)props.get("cm:title"), node.getId());
                this.addTo(textIdMap, (String)props.get("cm:description"), node.getId());
                --nameIdx;
            }
            allIds.addAll(idNameMap.keySet());
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, null, paging, 200, null, true, allIds);
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, "aspectNames,properties,path,isLink", null, paging, 200, null, false, allIds);
            this.checkApiCall(null, NODE_TYPE_QUERY, testTerm, "cm:folder", null, null, null, paging, 200, null, null, f3NodeIds);
            this.checkApiCall("/app:company_home", ROOT_NODE_QUERY_SUFFIX, testTerm, null, "-root-", null, null, paging, 200, null, null, allIds);
            this.checkApiCall("/app:company_home/app:shared", ROOT_NODE_QUERY_SUFFIX, testTerm, null, "-shared-", null, null, paging, 200, null, null, Collections.EMPTY_LIST);
            this.checkApiCall("/app:company_home/app:user_homes/cm:user1-[0-9]*_x...._org.alfresco.rest.api.tests.queriesnodesapitest/cm:folder_x...._1", ROOT_NODE_QUERY_SUFFIX, testTerm, null, f1Id, null, null, paging, 200, null, null, f1NodeIds);
            this.checkApiCall("/app:company_home/app:user_homes/cm:user1-[0-9]*_x...._org.alfresco.rest.api.tests.queriesnodesapitest/cm:folder_x...._2", ROOT_NODE_QUERY_SUFFIX, testTerm, null, f2Id, null, null, paging, 200, null, null, f2NodeIds);
            this.checkApiCall("/app:company_home/app:user_homes/cm:user1-[0-9]*_x...._org.alfresco.rest.api.tests.queriesnodesapitest", ROOT_NODE_QUERY_SUFFIX, name + "*", null, "-my-", null, null, paging, 200, null, null, allIds);
            String term = name + String.format("%05d", 1) + name;
            List ids = (List)textIdMap.get(term);
            Assert.assertEquals((String)term, (long)3L, (long)ids.size());
            List<Node> nodes = this.checkApiCall(null, DEAFULT_QUERY, "\"" + term + "\"", null, null, null, null, paging, 200, null, null, ids);
            for (Node node : nodes) {
                if (node.getIsFolder().booleanValue()) {
                    Assert.assertEquals((Object)(term + folderNameSuffix), (Object)node.getName());
                    continue;
                }
                Assert.assertEquals((Object)(term + txtSuffix), (Object)node.getName());
            }
            term = name + String.format("%05d", 1) + name + txtSuffix;
            ids = (List)textIdMap.get(term);
            Assert.assertEquals((String)term, (long)2L, (long)ids.size());
            this.checkApiCall(null, DEAFULT_QUERY, term, null, null, null, null, paging, 200, null, null, ids);
            term = name + String.format("%05d", 1) + name + txtSuffix;
            ids = (List)textIdMap.get(term);
            Assert.assertEquals((String)term, (long)2L, (long)ids.size());
            this.checkApiCall(null, DEAFULT_QUERY, "\"" + term + "\"", null, null, null, null, paging, 200, null, null, ids);
            term = title + String.format("%05d", 2) + title;
            ids = (List)textIdMap.get(term);
            Assert.assertEquals((String)term, (long)3L, (long)ids.size());
            nodes = this.checkApiCall(null, DEAFULT_QUERY, "\"" + term + "\"", null, null, "properties", null, paging, 200, null, null, ids);
            Assert.assertEquals((Object)term, (Object)nodes.get(0).getProperties().get("cm:title"));
            Assert.assertEquals((Object)term, (Object)nodes.get(1).getProperties().get("cm:title"));
            Assert.assertEquals((Object)term, (Object)nodes.get(2).getProperties().get("cm:title"));
            term = descrip + String.format("%05d", 3) + descrip;
            ids = (List)textIdMap.get(term);
            Assert.assertEquals((String)term, (long)3L, (long)ids.size());
            nodes = this.checkApiCall(null, DEAFULT_QUERY, "\"" + term + "\"", null, null, "properties", null, paging, 200, null, null, ids);
            Assert.assertEquals((Object)term, (Object)nodes.get(0).getProperties().get("cm:description"));
            Assert.assertEquals((Object)term, (Object)nodes.get(1).getProperties().get("cm:description"));
            Assert.assertEquals((Object)term, (Object)nodes.get(2).getProperties().get("cm:description"));
            this.getAll(URL_QUERIES_LSN, paging, null, 400);
            params = new HashMap(1);
            params.put("rootNodeId", f1Id);
            this.getAll(URL_QUERIES_LSN, paging, params, 400);
            params = new HashMap(2);
            params.put("term", "abc");
            params.put("rootNodeId", "dummy");
            this.getAll(URL_QUERIES_LSN, paging, params, 404);
            params = new HashMap(2);
            params.put("term", "abc");
            params.put("nodeType", "cm:dummy");
            this.getAll(URL_QUERIES_LSN, paging, params, 400);
            params = new HashMap(1);
            params.put("term", "ab");
            this.getAll(URL_QUERIES_LSN, paging, params, 400);
            params = new HashMap(1);
            params.put("term", "  \"a b *\"  ");
            this.getAll(URL_QUERIES_LSN, paging, params, 400);
            this.setRequestContext(null);
            this.getAll(URL_QUERIES_LSN, paging, params, 401);
        }
        finally {
            this.setRequestContext(user1);
            for (String docId : allIds) {
                this.deleteNode(docId, true, 204);
            }
        }
    }

    private void addTo(Map<String, List<String>> textIdMap, String text, String id) {
        List<String> ids = textIdMap.get(text);
        if (ids == null) {
            ids = new ArrayList<String>();
            textIdMap.put(text, ids);
        }
        ids.add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiveSearchNodes_SortPage() throws Exception {
        this.setRequestContext(user1);
        int f1Count = 5;
        ArrayList<String> f1NodeIds = new ArrayList<String>(f1Count);
        int f2Count = 3;
        ArrayList<String> f2NodeIds = new ArrayList<String>(f2Count);
        int totalCount = f1Count + f2Count;
        ArrayList<String> allIds = new ArrayList<String>(totalCount);
        String testTerm = "def456sortpage";
        try {
            Document doc;
            String docName;
            String num;
            String contentText;
            int i;
            PublicApiClient.Paging paging = this.getPaging(0, 100);
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("term", testTerm);
            String myFolderNodeId = this.getMyNodeId();
            String f1Id = this.createFolder(myFolderNodeId, "folder sort 1").getId();
            String f2Id = this.createFolder(myFolderNodeId, "folder sort 2").getId();
            String name = "name";
            HashMap<String, CallSite> idNameMap = new HashMap<String, CallSite>();
            int nameIdx = f1Count;
            for (i = 1; i <= f1Count; ++i) {
                contentText = "f1 " + testTerm + " test document " + user1 + " document " + i;
                num = String.format("%05d", nameIdx);
                docName = name + num + name + ".txt";
                doc = this.createTextFile(f1Id, docName, contentText, "UTF-8", null);
                f1NodeIds.add(doc.getId());
                idNameMap.put(doc.getId(), (CallSite)((Object)docName));
                --nameIdx;
            }
            nameIdx = f2Count;
            for (i = 1; i <= f2Count; ++i) {
                contentText = "f2 " + testTerm + " test document";
                num = String.format("%05d", nameIdx);
                docName = name + num + name + ".txt";
                doc = this.createTextFile(f2Id, docName, contentText, "UTF-8", null);
                f2NodeIds.add(doc.getId());
                idNameMap.put(doc.getId(), (CallSite)((Object)docName));
                --nameIdx;
            }
            ArrayList<String> idsSortedByNameAsc = new ArrayList<String>(QueriesNodesApiTest.sortByValue(idNameMap).keySet());
            ArrayList<String> idsSortedByNameDescCreatedAtAsc = new ArrayList<String>(totalCount);
            for (int i2 = 0; i2 < totalCount; ++i2) {
                if (i2 < f1Count) {
                    idsSortedByNameDescCreatedAtAsc.add((String)f1NodeIds.get(i2));
                }
                if (i2 >= f2Count) continue;
                idsSortedByNameDescCreatedAtAsc.add((String)f2NodeIds.get(i2));
            }
            allIds.addAll(idNameMap.keySet());
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, null, paging, 200, false, true, allIds);
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, "modifiedAt asc", paging, 200, false, true, allIds);
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, "modifiedAt desc", paging, 200, true, true, allIds);
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, "createdAt asc", paging, 200, true, true, allIds);
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, "createdAt desc", paging, 200, false, true, allIds);
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, "name asc", paging, 200, true, true, idsSortedByNameAsc);
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, "name desc", paging, 200, false, true, idsSortedByNameAsc);
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, "name desc, createdAt asc", paging, 200, false, true, idsSortedByNameDescCreatedAtAsc);
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, "name asc, createdAt desc", paging, 200, true, true, idsSortedByNameDescCreatedAtAsc);
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, null, this.getPaging(0, 100), 200, false, true, allIds);
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, null, this.getPaging(0, f1Count), 200, false, true, f1NodeIds);
            this.checkApiCall(null, DEAFULT_QUERY, testTerm, null, null, null, null, this.getPaging(f1Count, f2Count), 200, false, true, f2NodeIds);
            params = new HashMap(2);
            params.put("term", testTerm);
            params.put("orderBy", "invalid asc");
            this.getAll(URL_QUERIES_LSN, paging, params, 400);
            this.setRequestContext(null);
            this.getAll(URL_QUERIES_LSN, paging, params, 401);
        }
        finally {
            this.setRequestContext(user1);
            for (String docId : allIds) {
                this.deleteNode(docId, true, 204);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Category(value={RedundantTests.class})
    public void testLiveSearchNodes_Tags() throws Exception {
        this.setRequestContext(user1);
        PublicApiClient.Nodes nodesProxy = this.publicApiClient.nodes();
        int f1Count = 5;
        ArrayList<String> f1NodeIds = new ArrayList<String>(f1Count);
        int f2Count = 3;
        ArrayList<String> f2NodeIds = new ArrayList<String>(f2Count);
        int totalCount = f1Count + f2Count;
        ArrayList<String> allIds = new ArrayList<String>(totalCount);
        String testTag = "ghi789tag";
        String testFileTag = "ghi789file";
        String testFolderTag = "ghi789folder";
        try {
            int i;
            PublicApiClient.Paging paging = this.getPaging(0, 100);
            String f1Id = this.createFolder("-my-", "folder tag 1").getId();
            String f2Id = this.createFolder("-my-", "folder tag 2").getId();
            String name = "name";
            for (i = 1; i <= f1Count; ++i) {
                String contentText = "f1 test document " + user1 + " document " + i;
                String docName = name + i;
                Document doc = this.createTextFile(f1Id, docName, contentText, "UTF-8", null);
                this.publicApiClient.setRequestContext(new RequestContext("", user1));
                nodesProxy.createNodeTag(doc.getId(), new Tag(testTag));
                nodesProxy.createNodeTag(doc.getId(), new Tag(testFileTag));
                f1NodeIds.add(doc.getId());
            }
            for (i = 1; i <= f2Count; ++i) {
                String folderName = name + i;
                Folder folder = this.createFolder(f2Id, folderName, null);
                this.publicApiClient.setRequestContext(new RequestContext("", user1));
                nodesProxy.createNodeTag(folder.getId(), new Tag(testTag));
                nodesProxy.createNodeTag(folder.getId(), new Tag(testFolderTag));
                f2NodeIds.add(folder.getId());
            }
            allIds.addAll(f1NodeIds);
            allIds.addAll(f2NodeIds);
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("term", testTag);
            HttpResponse response = this.getAll(URL_QUERIES_LSN, paging, params, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            this.checkNodeIds(nodes, allIds, null);
            params = new HashMap(1);
            params.put("term", testFileTag);
            response = this.getAll(URL_QUERIES_LSN, paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            this.checkNodeIds(nodes, f1NodeIds, null);
            params = new HashMap(1);
            params.put("term", testFolderTag);
            response = this.getAll(URL_QUERIES_LSN, paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            this.checkNodeIds(nodes, f2NodeIds, null);
        }
        finally {
            this.setRequestContext(user1);
            for (String nodeId : allIds) {
                this.deleteNode(nodeId, true, 204);
            }
        }
    }

    private void checkNodeIds(List<Node> nodes, List<String> nodeIds, Boolean asc) {
        Assert.assertEquals((long)nodeIds.size(), (long)nodes.size());
        if (asc == null) {
            for (Node node : nodes) {
                Assert.assertTrue((boolean)nodeIds.contains(node.getId()));
            }
        } else if (asc.booleanValue()) {
            int i = 0;
            for (Node node : nodes) {
                nodeIds.get(i).equals(node.getId());
                ++i;
            }
        } else {
            int i = nodeIds.size() - 1;
            for (Node node : nodes) {
                nodeIds.get(i).equals(node.getId());
                --i;
            }
        }
    }

    @Override
    public String getScope() {
        return "public";
    }
}

