/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.model.SiteUpdate;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.JSONAble;
import org.alfresco.rest.api.tests.client.data.Site;
import org.alfresco.rest.api.tests.client.data.SiteImpl;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSites
extends EnterpriseTestApi {
    private static final String RUNID = "" + System.currentTimeMillis();
    private RepoService.TestNetwork network1;
    private String person1Id;
    private String person2Id;
    private Site site1;
    private Site site2;
    private Site site3;
    private RepoService.TestNetwork network2;
    private String person3Id;
    private Site site4;
    private Site site5;
    private Site site6;
    private RepoService.TestNetwork network3;
    private String person4Id;
    private Site site7;
    private Site site8;
    private Site site9;
    private Site site10;
    private String site4_id = "a-" + GUID.generate();
    private String site4_title = "c_" + GUID.generate();
    private String site4_description = "b_" + GUID.generate();
    private String site5_id = "b-" + GUID.generate();
    private String site5_title = "a_" + GUID.generate();
    private String site5_description = "c_" + GUID.generate();
    private String site6_id = "c-" + GUID.generate();
    private String site6_title = "b_" + GUID.generate();
    private String site6_description = "a_" + GUID.generate();
    private String preset = "sitePreset";
    private static final String AND_PREDICATE = " AND ";
    private static final String OR_PREDICATE = " OR ";

    @Override
    @Before
    public void setup() throws Exception {
        this.initializeNetwork1();
    }

    private void initializeNetwork1() throws Exception {
        if (this.network1 == null) {
            this.network1 = this.getRepoService().createNetwork(this.getClass().getName().toLowerCase() + "-1-" + RUNID, true);
            this.network1.create();
            TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TestSites.this.person1Id = TestSites.this.network1.createUser().getId();
                    TestSites.this.person2Id = TestSites.this.network1.createUser().getId();
                    return null;
                }
            }, (String)this.network1.getId());
        }
    }

    private void initializeNetwork2WithSites() throws Exception {
        if (this.network2 == null) {
            this.network2 = this.getRepoService().createNetwork(this.getClass().getName().toLowerCase() + "-2-" + RUNID, true);
            this.network2.create();
            TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TestSites.this.person3Id = TestSites.this.network2.createUser().getId();
                    return null;
                }
            }, (String)this.network2.getId());
            this.publicApiClient.setRequestContext(new RequestContext(this.network2.getId(), this.person3Id));
            PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
            SiteImpl site = new SiteImpl(this.site4_id, this.site4_title, this.site4_description, SiteVisibility.PRIVATE.toString());
            this.site4 = sitesProxy.createSite(site);
            site = new SiteImpl(this.site5_id, this.site5_title, this.site5_description, SiteVisibility.PRIVATE.toString());
            this.site5 = sitesProxy.createSite(site);
            site = new SiteImpl(this.site6_id, this.site6_title, this.site6_description, SiteVisibility.PRIVATE.toString());
            this.site6 = sitesProxy.createSite(site);
        }
    }

    private void initializeNetwork3WithSites() throws Exception {
        final String siteDescription = "description";
        if (this.network3 == null) {
            this.network3 = this.getRepoService().createNetwork(this.getClass().getName().toLowerCase() + "-3-" + RUNID, true);
            this.network3.create();
            TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TestSites.this.person4Id = TestSites.this.network3.createUser().getId();
                    return null;
                }
            }, (String)this.network3.getId());
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TestSites.this.site7 = TestSites.this.network3.createSite("a-" + GUID.generate(), "site A" + GUID.generate(), siteDescription, TestSites.this.preset, SiteVisibility.PRIVATE);
                    TestSites.this.site8 = TestSites.this.network3.createSite("b-" + GUID.generate(), "site B" + GUID.generate(), siteDescription, TestSites.this.preset, SiteVisibility.PUBLIC);
                    TestSites.this.site9 = TestSites.this.network3.createSite("c-" + GUID.generate(), "site C" + GUID.generate(), siteDescription, TestSites.this.preset, SiteVisibility.PUBLIC);
                    TestSites.this.site10 = TestSites.this.network3.createSite("d-" + GUID.generate(), "site D" + GUID.generate(), siteDescription, "site-dashboard", SiteVisibility.MODERATED);
                    return null;
                }
            }, (String)this.person4Id, (String)this.network3.getId());
        }
    }

    @Test
    public void testGetSiteAndListSites() throws Exception {
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person2Id));
        String siteTitle = "site 1 " + System.currentTimeMillis();
        SiteImpl site = new SiteImpl(siteTitle, SiteVisibility.PRIVATE.toString());
        this.site1 = sitesProxy.createSite(site);
        Site ret = sitesProxy.getSite(this.site1.getSiteId());
        this.site1.expected(ret);
        siteTitle = "site 2 " + System.currentTimeMillis();
        site = new SiteImpl(siteTitle, SiteVisibility.PUBLIC.toString());
        this.site2 = sitesProxy.createSite(site);
        ret = sitesProxy.getSite(this.site2.getSiteId());
        this.site2.expected(ret);
        siteTitle = "site 3 " + System.currentTimeMillis();
        site = new SiteImpl(siteTitle, SiteVisibility.MODERATED.toString());
        this.site3 = sitesProxy.createSite(site);
        ret = sitesProxy.getSite(this.site3.getSiteId());
        this.site3.expected(ret);
        List expectedSites = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<RepoService.TestSite>>(){

            public List<RepoService.TestSite> doWork() throws Exception {
                List<RepoService.TestSite> sites = TestSites.this.network1.getSites(TestSites.this.person1Id);
                return sites;
            }
        }, (String)this.person1Id, (String)this.network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1Id));
        int skipCount = 0;
        int maxItems = 2;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, expectedSites.size(), expectedSites.size());
        PublicApiClient.ListResponse<Site> resp = sitesProxy.getSites(this.createParams(paging, null));
        this.checkList(expectedSites.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1Id));
        skipCount = 2;
        maxItems = Integer.MAX_VALUE;
        paging = this.getPaging(skipCount, maxItems, expectedSites.size(), expectedSites.size());
        resp = sitesProxy.getSites(this.createParams(paging, null));
        this.checkList(expectedSites.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
    }

    @Test
    public void testCreateAndDeleteSite() throws Exception {
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1Id));
        String siteTitle = "my site !*#$ 123";
        String siteDescription = "my site description";
        SiteImpl site = new SiteImpl(siteTitle, SiteVisibility.PRIVATE.toString());
        site.setDescription(siteDescription);
        Site ret = sitesProxy.createSite(site);
        String siteId = ret.getSiteId();
        String expectedSiteId = "my-site-123";
        SiteImpl siteExp = new SiteImpl(null, expectedSiteId, ret.getGuid(), siteTitle, siteDescription, SiteVisibility.PRIVATE.toString(), null, SiteRole.SiteManager);
        siteExp.expected(ret);
        ret = sitesProxy.getSite(siteId);
        siteExp.expected(ret);
        sitesProxy.removeSite(siteId);
        sitesProxy.getSite(siteId, 404);
        String siteId2 = "bbb";
        String siteTitle2 = "BBB site";
        site = new SiteImpl(null, siteId2, null, siteTitle2, null, SiteVisibility.PUBLIC.toString(), null, null);
        sitesProxy.createSite(site);
        sitesProxy.removeSite(siteId2, true, 204);
        sitesProxy.createSite(site);
        sitesProxy.removeSite(siteId2);
        siteId2 = "true";
        siteTitle2 = "string";
        String siteDescription2 = "string";
        SiteImpl site2 = new SiteImpl(null, siteId2, null, siteTitle2, siteDescription2, SiteVisibility.PUBLIC.toString(), null, null);
        sitesProxy.createSite(site2);
        sitesProxy.removeSite(siteId2);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person2Id));
        SiteImpl site3 = new SiteImpl("a private site", SiteVisibility.PRIVATE.toString());
        String siteIdOfPrivateSite = sitesProxy.createSite(site3, 201).getSiteId();
        site3 = new SiteImpl("a public site", SiteVisibility.PUBLIC.toString());
        String siteIdOfPublicSite = sitesProxy.createSite(site3, 201).getSiteId();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), GUID.generate(), "password"));
        sitesProxy.getSite(siteIdOfPrivateSite, 401);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1Id));
        sitesProxy.getSite(siteIdOfPrivateSite, 404);
        sitesProxy.removeSite(siteIdOfPrivateSite, false, 404);
        sitesProxy.getSite(siteIdOfPublicSite, 200);
        sitesProxy.removeSite(siteIdOfPublicSite, false, 403);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person2Id));
        sitesProxy.removeSite(siteIdOfPrivateSite, false, 204);
        sitesProxy.removeSite(siteIdOfPublicSite, false, 204);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1Id));
        sitesProxy.getSite(GUID.generate(), 404);
        site3 = new SiteImpl("my site 123", "invalidsitevisibility");
        sitesProxy.createSite(site3, 400);
        site3 = new SiteImpl(null, "invalid site id", null, "my site 123", null, SiteVisibility.PRIVATE.toString(), null, null);
        sitesProxy.createSite(site3, 400);
        site3 = new SiteImpl(null, "invalidsiteid*", null, "my site 123", null, SiteVisibility.PRIVATE.toString(), null, null);
        sitesProxy.createSite(site3, 400);
        site3 = new SiteImpl();
        site3.setSiteId(new String(new char[72]).replace('\u0000', 'a'));
        site3.setTitle(new String(new char[256]).replace('\u0000', 'a'));
        site3.setDescription(new String(new char[512]).replace('\u0000', 'a'));
        site3.setVisibility(SiteVisibility.PUBLIC.toString());
        sitesProxy.createSite(site3, 201);
        site3 = new SiteImpl();
        site3.setSiteId(new String(new char[73]).replace('\u0000', 'a'));
        site3.setTitle("ok");
        site3.setDescription("ok");
        site3.setVisibility(SiteVisibility.PUBLIC.toString());
        sitesProxy.createSite(site3, 400);
        site3 = new SiteImpl();
        site3.setSiteId("ok");
        site3.setTitle(new String(new char[257]).replace('\u0000', 'a'));
        site3.setDescription("ok");
        site3.setVisibility(SiteVisibility.PUBLIC.toString());
        sitesProxy.createSite(site3, 400);
        site3 = new SiteImpl();
        site3.setSiteId("ok");
        site3.setTitle("ok");
        site3.setDescription(new String(new char[513]).replace('\u0000', 'a'));
        site3.setVisibility(SiteVisibility.PUBLIC.toString());
        sitesProxy.createSite(site3, 400);
        String siteTitle3 = "my site 456";
        site3 = new SiteImpl(siteTitle3, SiteVisibility.PRIVATE.toString());
        siteId = sitesProxy.createSite(site3, 201).getSiteId();
        sitesProxy.createSite(site3, 409);
        sitesProxy.removeSite(siteId);
        sitesProxy.removeSite(GUID.generate(), false, 404);
        siteId2 = "aaa";
        siteTitle2 = "AAA site";
        site = new SiteImpl(null, siteId2, null, siteTitle2, null, SiteVisibility.PUBLIC.toString(), null, null);
        String siteNodeId = sitesProxy.createSite(site).getGuid();
        sitesProxy.createSite(site, 409);
        sitesProxy.removeSite(siteId2);
        sitesProxy.createSite(site, 409);
        sitesProxy.remove("deleted-nodes", siteNodeId, null, null, "Cannot purge site");
        sitesProxy.createSite(site);
        siteId2 = "zzz";
        siteTitle2 = "ZZZ site";
        site = new SiteImpl(null, siteId2, null, siteTitle2, null, SiteVisibility.PRIVATE.toString(), null, null);
        siteNodeId = sitesProxy.createSite(site).getGuid();
        JSONObject prop = new JSONObject();
        prop.put((Object)"st:siteVisibility", (Object)"INVALID");
        JSONObject properties = new JSONObject();
        properties.put((Object)"properties", (Object)new JSONObject((Map)prop));
        try {
            sitesProxy.update("nodes", siteNodeId, null, null, properties.toJSONString(), null);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        sitesProxy.removeSite(siteId2);
        ArrayList<SiteImpl> sites = new ArrayList<SiteImpl>(2);
        sites.add(new SiteImpl(null, "siteA1", null, "siteA1", null, SiteVisibility.PRIVATE.toString(), null, null));
        sites.add(new SiteImpl(null, "siteB1", null, "siteB1", null, SiteVisibility.PRIVATE.toString(), null, null));
        sitesProxy.create("sites", null, null, null, JSONArray.toJSONString(sites), null, 405);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1Id));
        try {
            sitesProxy.create("sites", "site", null, null, null, "Unable to POST to a site");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            sitesProxy.remove("sites", null, null, null, "Unable to DELETE sites");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1Id));
        site3 = new SiteImpl().withPreset("testSitePreset");
        sitesProxy.createSite(site3, 400);
    }

    @Test
    public void testUpdateSite() throws PublicApiException {
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1Id));
        SiteImpl siteToCreate = new SiteImpl("Initial Title", SiteVisibility.PRIVATE.toString());
        siteToCreate.setRole(SiteRole.SiteManager);
        siteToCreate.setDescription("This is the initial description for the site");
        Site site = sitesProxy.createSite(siteToCreate, 201);
        String updateJSON = "{\n  \"title\": \"Updated Title\",\n  \"description\": \"This is an updated description for the site\",\n  \"visibility\": \"PUBLIC\"\n}";
        HttpResponse response = sitesProxy.update("sites", site.getSiteId(), null, null, updateJSON, "Failed to update site " + site.getSiteId());
        Site updatedSite = SiteImpl.parseSite((JSONObject)response.getJsonResponse().get((Object)"entry"));
        SiteImpl expectedUpdate = new SiteImpl(null, "initial-title", site.getGuid(), "Updated Title", "This is an updated description for the site", SiteVisibility.PUBLIC.toString(), null, SiteRole.SiteManager);
        expectedUpdate.expected(updatedSite);
        Site fresh = sitesProxy.getSite(site.getSiteId(), 200);
        expectedUpdate.expected(fresh);
        this.removeSiteQuietly(site.getSiteId());
        Site site2 = sitesProxy.createSite(new SiteImpl(null, "NoDescriptionTest", "Initial description", SiteVisibility.PUBLIC.toString()), 201);
        Site updatedSite2 = sitesProxy.updateSite(site2.getSiteId(), new SiteUpdate("title", "", SiteVisibility.PUBLIC), 200);
        SiteImpl expectedUpdate2 = new SiteImpl(null, "nodescriptiontest", site2.getGuid(), "title", null, SiteVisibility.PUBLIC.toString(), null, SiteRole.SiteManager);
        expectedUpdate2.expected(updatedSite2);
        Assert.assertNull((Object)updatedSite2.getDescription());
        Site fresh2 = sitesProxy.getSite(site2.getSiteId(), 200);
        expectedUpdate2.expected(fresh2);
        Assert.assertNull((Object)fresh2.getDescription());
        this.removeSiteQuietly(site2.getSiteId());
        site2 = sitesProxy.createSite(new SiteImpl("partial-updates-test", "title-v1", "description-v1", SiteVisibility.PUBLIC.toString()), 201);
        updatedSite2 = sitesProxy.updateSite(site2.getSiteId(), new SiteUpdate("title-v2", null, null), 200);
        expectedUpdate2 = new SiteImpl(null, "partial-updates-test", site2.getGuid(), "title-v2", "description-v1", SiteVisibility.PUBLIC.toString(), null, SiteRole.SiteManager);
        expectedUpdate2.expected(updatedSite2);
        updatedSite2 = sitesProxy.updateSite(site2.getSiteId(), new SiteUpdate(null, "description-v2", null), 200);
        expectedUpdate2 = new SiteImpl(null, "partial-updates-test", site2.getGuid(), "title-v2", "description-v2", SiteVisibility.PUBLIC.toString(), null, SiteRole.SiteManager);
        expectedUpdate2.expected(updatedSite2);
        updatedSite2 = sitesProxy.updateSite(site2.getSiteId(), new SiteUpdate(null, null, SiteVisibility.PRIVATE), 200);
        expectedUpdate2 = new SiteImpl(null, "partial-updates-test", site2.getGuid(), "title-v2", "description-v2", SiteVisibility.PRIVATE.toString(), null, SiteRole.SiteManager);
        expectedUpdate2.expected(updatedSite2);
        this.removeSiteQuietly(site2.getSiteId());
        site2 = sitesProxy.createSite(new SiteImpl("Site Update Bad Request Tests", SiteVisibility.PRIVATE.toString()), 201);
        sitesProxy.updateSite(site2.getSiteId(), new SiteUpdate(new String(new char[257]).replace('\u0000', 'a'), "description", SiteVisibility.PUBLIC), 400);
        sitesProxy.updateSite(site2.getSiteId(), new SiteUpdate("title", new String(new char[513]).replace('\u0000', 'a'), SiteVisibility.PUBLIC), 400);
        sitesProxy.update("sites", site2.getSiteId(), null, null, "{\n  \"title\": \"Updated Title\",\n  \"description\": \"This is an updated description for the site\",\n  \"visibility\": \"INVALID_VISIBILITY\"\n}", null, "Expected 400 response when updating " + site2.getSiteId(), 400);
        sitesProxy.update("sites", site2.getSiteId(), null, null, "{\n  \"id\": \"a-new-id\",  \"title\": \"Updated Title\"\n}", null, "Expected 400 response when updating " + site2.getSiteId(), 400);
        sitesProxy.update("sites", site2.getSiteId(), null, null, "{\n  \"guid\": \"76ba60c1-f05b-406a-86a4-4eeb1bb49aaa\"}", null, "Expected 400 response when updating " + site2.getSiteId(), 400);
        sitesProxy.update("sites", site2.getSiteId(), null, null, "{\n  \"role\": \"SiteConsumer\"}", null, "Expected 400 response when updating " + site2.getSiteId(), 400);
        sitesProxy.update("sites", site2.getSiteId(), null, null, "{\n  \"preset\": \"sitePreset\"}", null, "Expected 400 response when updating " + site2.getSiteId(), 400);
        Site fresh3 = sitesProxy.getSite(site2.getSiteId(), 200);
        site2.expected(fresh3);
        this.removeSiteQuietly(site2.getSiteId());
        sitesProxy.updateSite(UUID.randomUUID().toString(), new SiteUpdate("Updated title", "Updated description", SiteVisibility.PUBLIC), 404);
        site2 = sitesProxy.createSite(new SiteImpl("SiteUpdate401", SiteVisibility.PRIVATE.toString()), 201);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), GUID.generate(), "password"));
        sitesProxy.updateSite(site2.getSiteId(), new SiteUpdate("Updated Title", "Updated description", SiteVisibility.PUBLIC), 401);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1Id));
        fresh3 = sitesProxy.getSite(site2.getSiteId(), 200);
        site2.expected(fresh3);
        this.removeSiteQuietly(site2.getSiteId());
        site2 = sitesProxy.createSite(new SiteImpl("SiteUpdate403", SiteVisibility.PUBLIC.toString()), 201);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person2Id));
        sitesProxy.updateSite(site2.getSiteId(), new SiteUpdate("Updated Title", "Updated description", SiteVisibility.PUBLIC), 403);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1Id));
        fresh3 = sitesProxy.getSite(site2.getSiteId(), 200);
        site2.expected(fresh3);
        this.removeSiteQuietly(site2.getSiteId());
    }

    private void removeSiteQuietly(String siteId) throws PublicApiException {
        block2: {
            PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
            try {
                sitesProxy.removeSite(siteId, true, 204);
            }
            catch (PublicApiException e) {
                if (e.getHttpResponse().getStatusCode() == 404) break block2;
                throw e;
            }
        }
    }

    public void testSortingAndPagingByTitleAsc() throws Exception {
        int skipCount = 1;
        int maxItems = 2;
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<Site> resp = this.listSites(paging, "title", true);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site6);
        expectedList.add((SiteImpl)this.site4);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testSortingAndPagingByTitleDesc() throws Exception {
        int skipCount = 1;
        int maxItems = 2;
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<Site> resp = this.listSites(paging, "title", false);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site6);
        expectedList.add((SiteImpl)this.site5);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testSortingAndPagingByDescriptionAsc() throws Exception {
        int skipCount = 1;
        int maxItems = 2;
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<Site> resp = this.listSites(paging, "description", true);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site4);
        expectedList.add((SiteImpl)this.site5);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testSortingAndPagingByDescriptionDesc() throws Exception {
        int skipCount = 1;
        int maxItems = 2;
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<Site> resp = this.listSites(paging, "description", false);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site4);
        expectedList.add((SiteImpl)this.site6);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testSortingAndPagingBySiteIdAsc() throws Exception {
        int skipCount = 1;
        int maxItems = 2;
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<Site> resp = this.listSites(paging, "id", true);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site5);
        expectedList.add((SiteImpl)this.site6);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testSortingAndPagingBySiteIdDesc() throws Exception {
        int skipCount = 1;
        int maxItems = 2;
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<Site> resp = this.listSites(paging, "id", false);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site5);
        expectedList.add((SiteImpl)this.site4);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testSortingAndPagingDefault() throws Exception {
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(null, null, totalResults, totalResults);
        PublicApiClient.ListResponse<Site> resp = this.listSites(null, null, false);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site5);
        expectedList.add((SiteImpl)this.site6);
        expectedList.add((SiteImpl)this.site4);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    @Test
    public void testSortingAndPaging() throws Exception {
        this.initializeNetwork2WithSites();
        this.publicApiClient.setRequestContext(new RequestContext(this.network2.getId(), this.person3Id));
        this.testSortingAndPagingByTitleAsc();
        this.testSortingAndPagingByTitleDesc();
        this.testSortingAndPagingByDescriptionAsc();
        this.testSortingAndPagingByDescriptionDesc();
        this.testSortingAndPagingBySiteIdAsc();
        this.testSortingAndPagingBySiteIdDesc();
        this.testSortingAndPagingDefault();
    }

    private PublicApiClient.ListResponse<Site> listSites(PublicApiClient.Paging paging, String sortColumn, boolean asc) throws Exception {
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        HashMap<String, String> params = new HashMap<String, String>();
        if (sortColumn != null) {
            params.put("orderBy", sortColumn + " " + (asc ? "ASC" : "DESC"));
        }
        return sitesProxy.getSites(this.createParams(paging, params));
    }

    private PublicApiClient.ListResponse<Site> listSitesWithWhere(PublicApiClient.Paging paging, Map<String, String> filters, String predicate) throws Exception {
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        String visibility = filters.get("visibility");
        String preset = filters.get("preset");
        String pred = predicate;
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        if (visibility != null || preset != null) {
            sb.append("(");
            sb.append((String)(visibility != null ? "visibility=" + visibility : ""));
            sb.append(pred != null ? pred : "");
            sb.append((String)(preset != null ? "preset='" + preset + "'" : ""));
            sb.append(")");
        }
        params.put("where", sb.toString());
        return sitesProxy.getSites(this.createParams(paging, params));
    }

    public void testListSitesWhereSiteVisibilityPrivate() throws Exception {
        int totalResults = 1;
        PublicApiClient.Paging paging = this.getPaging(null, null, totalResults, totalResults);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("visibility", SiteVisibility.PRIVATE.name());
        PublicApiClient.ListResponse<Site> resp = this.listSitesWithWhere(null, filters, null);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site7);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testListSitesWhereSiteVisibilityPublic() throws Exception {
        int totalResults = 2;
        PublicApiClient.Paging paging = this.getPaging(null, null, totalResults, totalResults);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("visibility", SiteVisibility.PUBLIC.name());
        PublicApiClient.ListResponse<Site> resp = this.listSitesWithWhere(null, filters, null);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site8);
        expectedList.add((SiteImpl)this.site9);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testListSitesWhereSiteVisibilityPublicAndSkipCount() throws Exception {
        Integer skipCount = 1;
        int maxItems = 2;
        int totalResults = 2;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("visibility", SiteVisibility.PUBLIC.name());
        PublicApiClient.ListResponse<Site> resp = this.listSitesWithWhere(paging, filters, null);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site9);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testListSitesWhereSiteVisibilityModerated() throws Exception {
        int totalResults = 1;
        PublicApiClient.Paging paging = this.getPaging(null, null, totalResults, totalResults);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("visibility", SiteVisibility.MODERATED.name());
        PublicApiClient.ListResponse<Site> resp = this.listSitesWithWhere(null, filters, null);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site10);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testListSitesWhereSiteVisibilityInvalid() throws Exception {
        try {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("visibility", "invalidVisibility");
            this.listSitesWithWhere(null, filters, null);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    public void testListSitesWhereByVisibilityORPreset() throws Exception {
        int totalResults = 2;
        PublicApiClient.Paging paging = this.getPaging(null, null, totalResults, totalResults);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("visibility", SiteVisibility.PRIVATE.name());
        filters.put("preset", "site-dashboard");
        PublicApiClient.ListResponse<Site> resp = this.listSitesWithWhere(null, filters, OR_PREDICATE);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site7);
        expectedList.add((SiteImpl)this.site10);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testListSitesWherePreset() throws Exception {
        int totalResults = 1;
        PublicApiClient.Paging paging = this.getPaging(null, null, totalResults, totalResults);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("preset", "site-dashboard");
        PublicApiClient.ListResponse<Site> resp = this.listSitesWithWhere(null, filters, null);
        LinkedList<SiteImpl> expectedList = new LinkedList<SiteImpl>();
        expectedList.add((SiteImpl)this.site10);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testListSitesWherePresetNonexistent() throws Exception {
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("preset", "nonexistentPreset");
        this.listSitesWithWhere(null, filters, null);
    }

    public void testListSitesWhereVisibilityANDPreset() throws Exception {
        try {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("visibility", SiteVisibility.PUBLIC.name());
            filters.put("preset", "sitePreset");
            this.listSitesWithWhere(null, filters, AND_PREDICATE);
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    @Test
    public void testListSitesWhereExpected() throws Exception {
        this.initializeNetwork3WithSites();
        this.publicApiClient.setRequestContext(new RequestContext(this.network3.getId(), this.person4Id));
        this.testListSitesWhereSiteVisibilityPrivate();
        this.testListSitesWhereSiteVisibilityPublic();
        this.testListSitesWhereSiteVisibilityPublicAndSkipCount();
        this.testListSitesWhereSiteVisibilityModerated();
        this.testListSitesWhereSiteVisibilityInvalid();
        this.testListSitesWherePreset();
        this.testListSitesWherePresetNonexistent();
        this.testListSitesWhereVisibilityANDPreset();
        this.testListSitesWhereByVisibilityORPreset();
    }

    public static class SiteUpdateAssertions {
        public static void assertEquals(SiteUpdate expected, SiteUpdate actual) {
            SiteUpdateAssertions.assertEquals(expected, actual);
        }
    }

    public static class SiteUpdateJSONSerializer
    implements JSONAble {
        private SiteUpdate siteUpdate;

        public SiteUpdateJSONSerializer(SiteUpdate siteUpdate) {
            this.siteUpdate = siteUpdate;
        }

        @Override
        public JSONObject toJSON() {
            JSONObject json = new JSONObject();
            if (this.siteUpdate.getTitle() != null) {
                json.put((Object)"title", (Object)this.siteUpdate.getTitle());
            }
            if (this.siteUpdate.getDescription() != null) {
                json.put((Object)"description", (Object)this.siteUpdate.getDescription());
            }
            if (this.siteUpdate.getVisibility() != null) {
                json.put((Object)"visibility", (Object)this.siteUpdate.getVisibility().toString());
            }
            return json;
        }

        public static SiteUpdate parseSiteUpdate(JSONObject jsonObject) {
            String title = (String)jsonObject.get((Object)"title");
            String description = (String)jsonObject.get((Object)"description");
            SiteVisibility visibility = SiteVisibility.valueOf((String)((String)jsonObject.get((Object)"visibility")));
            return new SiteUpdate(title, description, visibility);
        }
    }
}

