/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search;

import java.util.List;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LuceneTests.class, RedundantTests.class})
public class BasicSearchApiIntegrationTest
extends AbstractSingleNetworkSiteTest {
    private static final String URL_SEARCH = "search";
    private static final String SEARCH_API_NAME = "search";
    private static final String json = "{ \"query\": {\"query\": \"cm:name:king\",\"userQuery\": \"great\",\"language\": \"afts\"}, \"fields\" : [\"id\",\"name\", \"search\"]}";
    private static final String bad_json = "{ \"query\": {\"qu\": \"cm:some nonsense \",\"userQuery\": \"great\",\"language\": \"afts\"}}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testQuery() throws Exception {
        this.setRequestContext(user1);
        String f1Id = null;
        try {
            HttpResponse response = this.post("search", json, null, null, "search", 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            String myFolderNodeId = this.getMyNodeId();
            f1Id = this.createFolder(myFolderNodeId, "king").getId();
            response = this.post("search", json, null, null, "search", 200);
            PublicApiClient.ExpectedPaging paging = RestApiUtil.parsePaging(response.getJsonResponse());
            Assert.assertEquals((long)1L, (long)paging.getTotalItems().intValue());
            Assert.assertFalse((boolean)paging.getHasMoreItems());
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            HttpResponse httpResponse = this.post("search", "{ \"query\": {\"query\": \"g*\",\"userQuery\": \"great\",\"language\": \"afts\"}, \"paging\": {\"maxItems\": \"99\",\"skipCount\": \"4\"},\"includeRequest\": true,\"sort\": {\"type\": \"FIELD\",\"field\": \"cm:title\",\"ascending\": \"true\"},\"templates\": [{\"name\": \"mytemp\",\"template\": \"ATEMP\"}, {\"name\": \"yourtemp\",\"template\": \"%cm:content\"}],\"defaults\": {\"namespace\": \"namesp\",\"defaultFieldName\": \"myfield\",\"defaultFTSOperator\": \"AND\", \"textAttributes\": [\"roy\", \"king\"]},\"filterQueries\": [{\"query\": \"myquery\",\"tags\": [\"tag1\", \"tag2\"]},{\"query\": \"myquery2\"}],\"facetFields\": {\"facets\": [{\"field\": \"cm:creator\",\"prefix\": \"myquery2\",\"sort\": \"COUNT\",\"missing\": \"false\"}, {\"field\": \"modifier\",\"label\": \"mylabel\",\"method\": \"FC\",\"mincount\": \"5\"}, {\"field\": \"owner\",\"label\": \"ownerLabel\"}]},\"facetQueries\": [{\"query\": \"cm:created:bob\",\"label\": \"small\"}],\"pivots\": [{\"key\": \"mylabel\"}],\"ranges\": [{\"field\": \"content.size\",\"start\": \"0\",\"end\": \"300\",\"gap\": \"100\",\"include\":[\"lower\"]}],\"facetIntervals\": {\"sets\": [{ \"label\": \"king\", \"start\": \"1\", \"end\": \"2\",\"startInclusive\": true,\"endInclusive\": false}],\"intervals\": [{\"field\": \"cm:creator\",\"label\": \"creator\",\"sets\": [{\"label\": \"last\",\"start\": \"a\",\"end\": \"b\",\"startInclusive\": false}]},{\"label\":\"TheCreated\",\"field\":\"cm:created\",\"sets\":[{\"label\":\"lastYear\",\"start\":\"2016\",\"end\":\"2017\",\"endInclusive\":false},{\"label\":\"currentYear\",\"start\":\"NOW/YEAR\",\"end\":\"NOW/YEAR+1YEAR\"},{\"label\":\"earlier\",\"start\":\"*\",\"end\":\"2016\",\"endInclusive\":false}]}]},\"stats\": [{\"field\": \"cm:creator\", \"label\": \"mylabel\"}],\"spellcheck\": {\"query\": \"alfrezco\"},\"limits\": {\"permissionEvaluationCount\": \"2000\",\"permissionEvaluationTime\": \"5000\"},\"scope\": { \"locations\": [\"nodes\"]},\"fields\": [\"id\", \"name\"],\"highlight\": {\"prefix\": \"[\",\"postfix\": \"]\",\"snippetCount\": \"20\",\"fragmentSize\": \"10\",\"mergeContiguous\": \"true\",\"maxAnalyzedChars\": \"40\", \"usePhraseHighlighter\": \"true\",\"fields\": [  {\"field\": \"my\", \"snippetCount\": \"23\", \"fragmentSize\": \"5\", \"mergeContiguous\": \"true\", \"prefix\": \"?\", \"postfix\": \"\u00a1\"  },  {\"field\": \"your\", \"snippetCount\": \"3\", \"fragmentSize\": \"15\", \"mergeContiguous\": \"false\", \"prefix\": \"(\", \"postfix\": \")\"  }  ] },\"include\": [\"aspectNames\", \"properties\"]}", null, null, "search", 200);
            if (f1Id == null) return;
        }
        catch (Throwable throwable) {
            if (f1Id == null) throw throwable;
            this.deleteNode(f1Id, true, 204);
            throw throwable;
        }
        this.deleteNode(f1Id, true, 204);
    }

    @Test
    public void testBadQuery() throws Exception {
        this.setRequestContext(user1);
        HttpResponse response = this.post("search", bad_json, null, null, "search", 400);
    }
}

