/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.jacksonextensions.BeanPropertiesFilter;
import org.alfresco.rest.framework.resource.parameters.InvalidSelectException;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.rest.framework.resource.parameters.where.InvalidQueryException;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryImpl;
import org.alfresco.rest.framework.resource.parameters.where.WhereCompiler;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.RewriteCardinalityException;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;

public interface RecognizedParamsExtractor {
    public static final String PARAM_RELATIONS = "relations";
    public static final String PARAM_FILTER_FIELDS = "fields";
    @Deprecated
    public static final String PARAM_FILTER_PROPERTIES = "properties";
    public static final String PARAM_PAGING_SKIP = "skipCount";
    public static final String PARAM_PAGING_MAX = "maxItems";
    public static final String PARAM_ORDERBY = "orderBy";
    public static final String PARAM_WHERE = "where";
    public static final String PARAM_SELECT = "select";
    public static final String PARAM_INCLUDE = "include";
    public static final String PARAM_INCLUDE_SOURCE_ENTITY = "includeSource";
    public static final List<String> KNOWN_PARAMS = Arrays.asList("relations", "properties", "fields", "skipCount", "maxItems", "orderBy", "where", "select", "includeSource");

    default public Log rpeLogger() {
        return LogFactory.getLog(this.getClass());
    }

    default public Params.RecognizedParams getRecognizedParams(WebScriptRequest req) {
        Paging paging = this.findPaging(req);
        List<SortColumn> sorting = this.getSort(req.getParameter(PARAM_ORDERBY));
        Map<String, BeanPropertiesFilter> relationFilter = this.getRelationFilter(req.getParameter(PARAM_RELATIONS));
        Query whereQuery = this.getWhereClause(req.getParameter(PARAM_WHERE));
        Map<String, String[]> requestParams = this.getRequestParameters(req);
        boolean includeSource = Boolean.valueOf(req.getParameter(PARAM_INCLUDE_SOURCE_ENTITY));
        List<String> includedFields = this.getIncludeClause(req.getParameter(PARAM_INCLUDE));
        List<String> selectFields = this.getSelectClause(req.getParameter(PARAM_SELECT));
        String fields = req.getParameter(PARAM_FILTER_FIELDS);
        String properties = req.getParameter(PARAM_FILTER_PROPERTIES);
        if (fields != null && properties != null && this.rpeLogger().isWarnEnabled()) {
            this.rpeLogger().warn((Object)("Taking 'fields' param [" + fields + "] and ignoring deprecated 'properties' param [" + properties + "]"));
        }
        BeanPropertiesFilter filter = this.getFilter(fields != null ? fields : properties, includedFields);
        return new Params.RecognizedParams(requestParams, paging, filter, relationFilter, includedFields, selectFields, whereQuery, sorting, includeSource);
    }

    default public BeanPropertiesFilter getFilter(String filterParams, List<String> selectList) {
        if (filterParams != null) {
            StringTokenizer st = new StringTokenizer(filterParams, ",");
            HashSet<String> filteredProperties = new HashSet<String>(st.countTokens());
            while (st.hasMoreTokens()) {
                filteredProperties.add(st.nextToken().trim());
            }
            if (selectList != null) {
                for (String select : selectList) {
                    String[] split = select.split("/");
                    filteredProperties.add(split[0]);
                }
            }
            this.rpeLogger().debug((Object)("Filtering using the following properties: " + String.valueOf(filteredProperties)));
            BeanPropertiesFilter filter = new BeanPropertiesFilter(filteredProperties);
            return filter;
        }
        return BeanPropertiesFilter.ALLOW_ALL;
    }

    @Deprecated
    default public List<String> getSelectClause(String selectParam) throws InvalidArgumentException {
        return this.getClause(selectParam, "SELECT");
    }

    default public List<String> getIncludeClause(String includeParam) throws InvalidArgumentException {
        return this.getClause(includeParam, "INCLUDE");
    }

    default public List<String> getClause(String param, String paramName) {
        if (param == null) {
            return Collections.emptyList();
        }
        try {
            CommonTree selectedPropsTree = WhereCompiler.compileSelectClause(param);
            if (selectedPropsTree instanceof CommonErrorNode) {
                this.rpeLogger().debug((Object)("Error parsing the " + paramName + " clause " + String.valueOf(selectedPropsTree)));
                throw new InvalidSelectException(paramName, selectedPropsTree);
            }
            if (selectedPropsTree.getChildCount() == 0 && !selectedPropsTree.getText().isEmpty()) {
                return Arrays.asList(selectedPropsTree.getText());
            }
            List children = selectedPropsTree.getChildren();
            if (children != null && !children.isEmpty()) {
                ArrayList<String> properties = new ArrayList<String>(children.size());
                for (Tree child : children) {
                    properties.add(child.getText());
                }
                return properties;
            }
        }
        catch (RewriteCardinalityException re) {
            this.rpeLogger().debug((Object)("Unhandled Error parsing the " + paramName + " clause: " + String.valueOf((Object)re)));
        }
        catch (RecognitionException e) {
            this.rpeLogger().debug((Object)("Error parsing the \"+paramName+\" clause: " + param));
        }
        catch (InvalidQueryException iqe) {
            throw new InvalidSelectException(paramName, iqe.getQueryParam());
        }
        throw new InvalidSelectException(paramName, (Object)param);
    }

    default public Query getWhereClause(String whereParam) throws InvalidQueryException {
        if (whereParam == null) {
            return QueryImpl.EMPTY;
        }
        try {
            CommonTree whereTree = WhereCompiler.compileWhereClause((String)whereParam);
            if (whereTree instanceof CommonErrorNode) {
                this.rpeLogger().debug((Object)("Error parsing the WHERE clause " + String.valueOf(whereTree)));
                throw new InvalidQueryException(whereTree);
            }
            return new QueryImpl(whereTree);
        }
        catch (RewriteCardinalityException re) {
            this.rpeLogger().info((Object)("Unhandled Error parsing the WHERE clause: " + String.valueOf((Object)re)));
        }
        catch (RecognitionException e) {
            whereParam = (String)whereParam + ", " + WhereCompiler.resolveMessage(e);
            this.rpeLogger().info((Object)("Error parsing the WHERE clause: " + (String)whereParam));
        }
        throw new InvalidQueryException(whereParam);
    }

    default public List<SortColumn> getSort(String sortParams) {
        if (sortParams != null) {
            StringTokenizer st = new StringTokenizer(sortParams, ",");
            ArrayList<SortColumn> sortedColumns = new ArrayList<SortColumn>(st.countTokens());
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                StringTokenizer columnDesc = new StringTokenizer(token, " ");
                if (columnDesc.countTokens() <= 2) {
                    String columnName = columnDesc.nextToken();
                    String sortOrder = "ASC";
                    if (columnDesc.hasMoreTokens()) {
                        String sortDef = columnDesc.nextToken().toUpperCase();
                        if ("ASC".equals(sortDef) || "DESC".equals(sortDef)) {
                            sortOrder = sortDef;
                        } else {
                            this.rpeLogger().debug((Object)("Invalid sort order direction (" + sortDef + ").  Valid values are ASC or DESC."));
                            throw new InvalidArgumentException("Unknown sort order direction '" + sortDef + "', expected asc or desc");
                        }
                    }
                    sortedColumns.add(new SortColumn(columnName, "ASC".equals(sortOrder)));
                    continue;
                }
                this.rpeLogger().debug((Object)("Invalid sort order definition (" + token + ")"));
                throw new InvalidArgumentException("Unknown sort order definition '" + token + "', expected 'field1,field2' or 'field1 asc,field2 desc' or similar");
            }
            return sortedColumns;
        }
        return Collections.emptyList();
    }

    default public Paging findPaging(WebScriptRequest req) {
        String skip = req.getParameter(PARAM_PAGING_SKIP);
        String maxItems = req.getParameter(PARAM_PAGING_MAX);
        return this.getPaging(skip, maxItems);
    }

    default public Paging getPaging(String skip, String maxItems) {
        int skipped = 0;
        int max = 100;
        try {
            if (skip != null) {
                skipped = Integer.parseInt(skip);
            }
            if (maxItems != null) {
                max = Integer.parseInt(maxItems);
            }
            if (skipped < 0) {
                throw new InvalidArgumentException("Negative values not supported for skipCount.");
            }
            if (max < 1) {
                throw new InvalidArgumentException("Only positive values supported for maxItems.");
            }
        }
        catch (NumberFormatException error) {
            String errorMsg = "Invalid paging parameters skipCount: " + skip + ", maxItems:" + maxItems;
            if (this.rpeLogger().isDebugEnabled()) {
                this.rpeLogger().debug((Object)errorMsg);
            }
            if (skip == null) {
                errorMsg = "Invalid paging parameter maxItems:" + maxItems;
            }
            if (maxItems == null) {
                errorMsg = "Invalid paging parameter skipCount:" + skip;
            }
            throw new InvalidArgumentException(errorMsg);
        }
        return Paging.valueOf(skipped, max);
    }

    default public BeanPropertiesFilter getFilter(String filterParams) {
        return this.getFilter(filterParams, null);
    }

    default public Map<String, BeanPropertiesFilter> getRelationFilter(String filterParams) {
        if (filterParams != null) {
            String[] relations = filterParams.split(",(?![^()]*+\\))");
            HashMap<String, BeanPropertiesFilter> filterMap = new HashMap<String, BeanPropertiesFilter>(relations.length);
            for (String relation : relations) {
                int bracketLocation = relation.indexOf("(");
                if (bracketLocation != -1) {
                    String relationKey = relation.substring(0, bracketLocation);
                    String props = relation.substring(bracketLocation + 1, relation.length() - 1);
                    filterMap.put(relationKey, this.getFilter(props));
                    continue;
                }
                filterMap.put(relation, this.getFilter(null));
            }
            return filterMap;
        }
        return Collections.emptyMap();
    }

    default public Map<String, String[]> getRequestParameters(WebScriptRequest req) {
        String[] paramNames;
        if (req != null && (paramNames = req.getParameterNames()) != null) {
            HashMap<String, String[]> requestParameteters = new HashMap<String, String[]>(paramNames.length);
            for (int i = 0; i < paramNames.length; ++i) {
                String paramName = paramNames[i];
                if (KNOWN_PARAMS.contains(paramName)) continue;
                String[] vals = req.getParameterValues(paramName);
                requestParameteters.put(paramName, vals);
            }
            return requestParameteters;
        }
        return Collections.emptyMap();
    }
}

