/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.PersonInfo;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.MemberOfSite;
import org.alfresco.rest.api.tests.client.data.SiteMembershipApproval;
import org.alfresco.rest.api.tests.client.data.SiteMembershipRejection;
import org.alfresco.rest.api.tests.client.data.SiteMembershipRequest;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.ModeratedInvitation;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSiteMembershipRequests
extends EnterpriseTestApi {
    private static final String URL_SITES = "sites";
    private RepoService.TestNetwork network1;
    private RepoService.TestNetwork network2;
    private String person11Id;
    private String person12Id;
    private String person13Id;
    private String person14Id;
    private String person15Id;
    private String person24Id;
    private List<RepoService.TestSite> personModeratedSites = new ArrayList<RepoService.TestSite>();
    private List<RepoService.TestSite> personPublicSites = new ArrayList<RepoService.TestSite>();
    private List<RepoService.TestSite> person1PrivateSites = new ArrayList<RepoService.TestSite>();
    private List<RepoService.TestSite> person1ModeratedSites = new ArrayList<RepoService.TestSite>();
    private List<RepoService.TestSite> person1MixedCaseModeratedSites = new ArrayList<RepoService.TestSite>();
    private List<RepoService.TestSite> person1PublicSites = new ArrayList<RepoService.TestSite>();
    private List<RepoService.TestSite> person4ModeratedSites = new ArrayList<RepoService.TestSite>();
    private List<NodeRef> personDocs = new ArrayList<NodeRef>();
    private List<NodeRef> personFolders = new ArrayList<NodeRef>();
    private List<NodeRef> person1Docs = new ArrayList<NodeRef>();
    private List<NodeRef> person1Folders = new ArrayList<NodeRef>();
    private PublicApiClient.SiteMembershipRequests siteMembershipRequestsProxy;
    private Random random = new Random(System.currentTimeMillis());

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        Iterator<RepoService.TestNetwork> networksIt = this.getTestFixture().networksIterator();
        this.network1 = networksIt.next();
        Iterator<String> personIt = this.network1.getPersonIds().iterator();
        this.person11Id = personIt.next();
        Assert.assertNotNull((Object)this.person11Id);
        this.person12Id = personIt.next();
        Assert.assertNotNull((Object)this.person12Id);
        this.person13Id = personIt.next();
        Assert.assertNotNull((Object)this.person13Id);
        this.person14Id = personIt.next();
        Assert.assertNotNull((Object)this.person14Id);
        this.person15Id = personIt.next();
        Assert.assertNotNull((Object)this.person15Id);
        this.network2 = networksIt.next();
        Iterator<String> person1It = this.network2.getPersonIds().iterator();
        this.person24Id = person1It.next();
        Assert.assertNotNull((Object)this.person24Id);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                int i;
                String guid = GUID.generate();
                String[] siteNames = new String[]{"sitex" + guid, "sitea" + guid, "sitef" + guid, "site234" + guid, "sitey" + guid, "siteb" + guid, "site643" + guid, "site24" + guid, "site8d6sc" + guid};
                Object siteName = siteNames[0];
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation((String)siteName, (String)siteName, (String)siteName, SiteVisibility.MODERATED);
                RepoService.TestSite site = TestSiteMembershipRequests.this.network1.createSite(siteInfo);
                TestSiteMembershipRequests.this.person1ModeratedSites.add(site);
                for (int i2 = 1; i2 < siteNames.length; ++i2) {
                    siteName = siteNames[i2];
                    siteInfo = new RepoService.SiteInformation((String)siteName, (String)siteName, (String)siteName, SiteVisibility.MODERATED);
                    site = TestSiteMembershipRequests.this.network1.createSite(siteInfo);
                    TestSiteMembershipRequests.this.person1ModeratedSites.add(site);
                }
                String[] mixedCaseSiteNames = new String[]{"MixedCase" + guid, "mixedCaseA" + guid};
                for (i = 0; i < mixedCaseSiteNames.length; ++i) {
                    siteName = mixedCaseSiteNames[i];
                    siteInfo = new RepoService.SiteInformation((String)siteName, (String)siteName, (String)siteName, SiteVisibility.MODERATED);
                    site = TestSiteMembershipRequests.this.network1.createSite(siteInfo);
                    TestSiteMembershipRequests.this.person1MixedCaseModeratedSites.add(site);
                }
                for (i = 0; i < 1; ++i) {
                    siteName = "privatesite" + GUID.generate();
                    siteInfo = new RepoService.SiteInformation((String)siteName, (String)siteName, (String)siteName, SiteVisibility.PRIVATE);
                    site = TestSiteMembershipRequests.this.network1.createSite(siteInfo);
                    TestSiteMembershipRequests.this.person1PrivateSites.add(site);
                }
                NodeRef nodeRef = TestSiteMembershipRequests.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc1", "Test Content");
                TestSiteMembershipRequests.this.person1Docs.add(nodeRef);
                nodeRef = TestSiteMembershipRequests.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder1");
                TestSiteMembershipRequests.this.person1Folders.add(nodeRef);
                nodeRef = TestSiteMembershipRequests.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc2", "Test Content");
                TestSiteMembershipRequests.this.person1Docs.add(nodeRef);
                nodeRef = TestSiteMembershipRequests.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder2");
                TestSiteMembershipRequests.this.person1Folders.add(nodeRef);
                nodeRef = TestSiteMembershipRequests.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc3", "Test Content");
                TestSiteMembershipRequests.this.person1Docs.add(nodeRef);
                nodeRef = TestSiteMembershipRequests.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder3");
                TestSiteMembershipRequests.this.person1Folders.add(nodeRef);
                siteName = "site" + GUID.generate();
                siteInfo = new RepoService.SiteInformation((String)siteName, (String)siteName, (String)siteName, SiteVisibility.PUBLIC);
                site = TestSiteMembershipRequests.this.network1.createSite(siteInfo);
                TestSiteMembershipRequests.this.person1PublicSites.add(site);
                return null;
            }
        }, (String)this.person12Id, (String)this.network1.getId());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                String siteName = "site" + System.currentTimeMillis();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                RepoService.TestSite site = TestSiteMembershipRequests.this.network1.createSite(siteInfo);
                NodeRef nodeRef = TestSiteMembershipRequests.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc1", "Test Content");
                TestSiteMembershipRequests.this.personDocs.add(nodeRef);
                nodeRef = TestSiteMembershipRequests.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder1");
                TestSiteMembershipRequests.this.personFolders.add(nodeRef);
                nodeRef = TestSiteMembershipRequests.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc2", "Test Content");
                TestSiteMembershipRequests.this.personDocs.add(nodeRef);
                nodeRef = TestSiteMembershipRequests.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder2");
                TestSiteMembershipRequests.this.personFolders.add(nodeRef);
                nodeRef = TestSiteMembershipRequests.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc3", "Test Content");
                TestSiteMembershipRequests.this.personDocs.add(nodeRef);
                nodeRef = TestSiteMembershipRequests.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder3");
                TestSiteMembershipRequests.this.personFolders.add(nodeRef);
                return null;
            }
        }, (String)this.person11Id, (String)this.network1.getId());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                String siteName = "site" + GUID.generate();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                RepoService.TestSite site = TestSiteMembershipRequests.this.network1.createSite(siteInfo);
                TestSiteMembershipRequests.this.personPublicSites.add(site);
                site.inviteToSite(TestSiteMembershipRequests.this.person12Id, SiteRole.SiteCollaborator);
                siteName = "site" + GUID.generate();
                siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                site = TestSiteMembershipRequests.this.network1.createSite(siteInfo);
                TestSiteMembershipRequests.this.personPublicSites.add(site);
                return null;
            }
        }, (String)this.person11Id, (String)this.network1.getId());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                String siteName = "site" + GUID.generate();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.MODERATED);
                RepoService.TestSite site = TestSiteMembershipRequests.this.network1.createSite(siteInfo);
                TestSiteMembershipRequests.this.person4ModeratedSites.add(site);
                return null;
            }
        }, (String)this.person24Id, (String)this.network2.getId());
        this.siteMembershipRequestsProxy = this.publicApiClient.siteMembershipRequests();
    }

    private SiteMembershipRequest getSiteMembershipRequest(String networkId, String runAsUserId, String personId) throws PublicApiException, ParseException {
        this.publicApiClient.setRequestContext(new RequestContext(networkId, runAsUserId));
        int skipCount = 0;
        int maxItems = Integer.MAX_VALUE;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        PublicApiClient.ListResponse<SiteMembershipRequest> resp = this.siteMembershipRequestsProxy.getSiteMembershipRequests(personId, this.createParams(paging, null));
        List<SiteMembershipRequest> list = resp.getList();
        int size2 = list.size();
        Assert.assertTrue((size2 > 0 ? 1 : 0) != 0);
        int idx = this.random.nextInt(size2);
        SiteMembershipRequest request = list.get(idx);
        return request;
    }

    @Test
    public void testInvalidRequests() throws Exception {
        SiteMembershipRequest request;
        PublicApiClient.Paging paging;
        int maxItems;
        SiteMembershipRequest siteMembershipRequest;
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person12Id));
            siteMembershipRequest = new SiteMembershipRequest();
            siteMembershipRequest.setId(this.person1ModeratedSites.get(0).getSiteId());
            siteMembershipRequest.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(GUID.generate(), siteMembershipRequest);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person12Id));
            siteMembershipRequest = new SiteMembershipRequest();
            siteMembershipRequest.setId(GUID.generate());
            siteMembershipRequest.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person11Id, siteMembershipRequest);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person12Id));
            siteMembershipRequest = new SiteMembershipRequest();
            siteMembershipRequest.setId(this.person1ModeratedSites.get(0).getSiteId());
            siteMembershipRequest.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person11Id, siteMembershipRequest);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.log("cloud-2506");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            int skipCount = 0;
            maxItems = 4;
            paging = this.getPaging(skipCount, maxItems);
            this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person12Id, this.createParams(paging, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            int skipCount = 0;
            maxItems = 4;
            paging = this.getPaging(skipCount, maxItems);
            this.siteMembershipRequestsProxy.getSiteMembershipRequests(GUID.generate(), this.createParams(paging, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            this.siteMembershipRequestsProxy.getSiteMembershipRequest(this.person11Id, GUID.generate());
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2524");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14Id));
        SiteMembershipRequest siteMembershipRequest2 = new SiteMembershipRequest();
        siteMembershipRequest2.setId(this.person1ModeratedSites.get(0).getSiteId());
        siteMembershipRequest2.setMessage("Please can I join your site?");
        this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person14Id, siteMembershipRequest2);
        SiteMembershipRequest request2 = this.getSiteMembershipRequest(this.network1.getId(), this.person14Id, this.person14Id);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person24Id));
            this.siteMembershipRequestsProxy.cancelSiteMembershipRequest(this.person14Id, request2.getId());
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.log("cloud-2525");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14Id));
            this.siteMembershipRequestsProxy.cancelSiteMembershipRequest(GUID.generate(), request2.getId());
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.log("cloud-2526");
            this.log("cloud-2527");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14Id));
            request = new SiteMembershipRequest();
            request.setId(GUID.generate());
            this.siteMembershipRequestsProxy.cancelSiteMembershipRequest(this.person14Id, request.getId());
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14Id));
            this.siteMembershipRequestsProxy.cancelSiteMembershipRequest(this.person14Id, GUID.generate());
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.log("cloud-2519");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            request = new SiteMembershipRequest();
            request.setId(GUID.generate());
            request.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.update("people", this.person11Id, "favorites", null, request.toJSON().toString(), "Unable to PUT site membership requests");
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.log("cloud-2516");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            request = new SiteMembershipRequest();
            request.setId(GUID.generate());
            request.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.updateSiteMembershipRequest(this.person11Id, request);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    @Test
    public void testValidRequests() throws Exception {
        PublicApiClient.Paging paging;
        SiteMembershipRequest siteMembershipRequest;
        final ArrayList<SiteMembershipRequest> expectedSiteMembershipRequests = new ArrayList<SiteMembershipRequest>();
        this.log("cloud-2531");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
        int skipCount = 0;
        int maxItems = 2;
        PublicApiClient.Paging paging2 = this.getPaging(skipCount, maxItems, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        PublicApiClient.ListResponse<SiteMembershipRequest> resp = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person11Id, this.createParams(paging2, null));
        this.checkList(expectedSiteMembershipRequests.subList(skipCount, skipCount + paging2.getExpectedPaging().getCount()), paging2.getExpectedPaging(), resp);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
        skipCount = 0;
        PublicApiClient.Paging paging3 = this.getPaging(skipCount, null, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        PublicApiClient.ListResponse<SiteMembershipRequest> resp2 = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person11Id, this.createParams(paging3, null));
        this.checkList(expectedSiteMembershipRequests.subList(skipCount, skipCount + paging3.getExpectedPaging().getCount()), paging3.getExpectedPaging(), resp2);
        this.log("cloud-2502");
        this.log("cloud-2510");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
        SiteMembershipRequest siteMembershipRequest2 = new SiteMembershipRequest();
        siteMembershipRequest2.setId(this.person1ModeratedSites.get(0).getSiteId());
        siteMembershipRequest2.setMessage("Please can I join your site?");
        final SiteMembershipRequest moderatedSiteResponse = this.siteMembershipRequestsProxy.createSiteMembershipRequest("-me-", siteMembershipRequest2);
        expectedSiteMembershipRequests.add(moderatedSiteResponse);
        siteMembershipRequest2.expected(moderatedSiteResponse);
        siteMembershipRequest2 = new SiteMembershipRequest();
        siteMembershipRequest2.setId(this.person1PublicSites.get(0).getSiteId());
        siteMembershipRequest2.setMessage("Please can I join your site?");
        SiteMembershipRequest ret = this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person11Id, siteMembershipRequest2);
        siteMembershipRequest2.expected(ret);
        this.log("cloud-2532");
        int skipCount2 = 0;
        int maxItems2 = 4;
        PublicApiClient.Paging paging4 = this.getPaging(skipCount2, maxItems2, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        PublicApiClient.ListResponse<SiteMembershipRequest> resp3 = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person11Id, this.createParams(paging4, null));
        this.checkList(expectedSiteMembershipRequests, paging4.getExpectedPaging(), resp3);
        List<Invitation> invitations = this.repoService.getModeratedSiteInvitations(this.network1.getId(), this.person11Id, this.person11Id, null);
        Assert.assertEquals((long)1L, (long)invitations.size());
        Invitation invitation = invitations.get(0);
        Assert.assertTrue((boolean)(invitation instanceof ModeratedInvitation));
        ModeratedInvitation moderatedInvitation = (ModeratedInvitation)invitation;
        String siteId = moderatedInvitation.getResourceName();
        Invitation.InvitationType invitationType = moderatedInvitation.getInvitationType();
        Invitation.ResourceType resourceType = moderatedInvitation.getResourceType();
        String inviteeId = moderatedInvitation.getInviteeUserName();
        Assert.assertEquals((Object)this.person11Id, (Object)inviteeId);
        Assert.assertEquals((Object)Invitation.ResourceType.WEB_SITE, (Object)resourceType);
        Assert.assertEquals((Object)Invitation.InvitationType.MODERATED, (Object)invitationType);
        Assert.assertEquals((Object)this.person1ModeratedSites.get(0).getSiteId(), (Object)siteId);
        Assert.assertTrue((boolean)this.person1PublicSites.get(0).isMember(this.person11Id));
        this.log("cloud-2534");
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestSiteMembershipRequests.this.repoService.approveSiteInvitation(TestSiteMembershipRequests.this.person11Id, moderatedSiteResponse.getId());
                expectedSiteMembershipRequests.remove(0);
                return null;
            }
        }, (String)this.person12Id, (String)this.network1.getId());
        int skipCount3 = 0;
        int maxItems3 = 4;
        PublicApiClient.Paging paging5 = this.getPaging(skipCount3, maxItems3, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        PublicApiClient.ListResponse<SiteMembershipRequest> resp4 = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person11Id, this.createParams(paging5, null));
        this.checkList(expectedSiteMembershipRequests, paging5.getExpectedPaging(), resp4);
        try {
            this.log("cloud-2511");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person24Id));
            siteMembershipRequest2 = new SiteMembershipRequest();
            siteMembershipRequest2.setId(this.person1ModeratedSites.get(0).getSiteId());
            siteMembershipRequest2.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person24Id, siteMembershipRequest2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2512");
        this.log("cloud-2535");
        this.log("cloud-2536");
        ArrayList person4ExpectedSiteMembershipRequests = new ArrayList();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person24Id));
        try {
            siteMembershipRequest = new SiteMembershipRequest();
            siteMembershipRequest.setId(this.person1PublicSites.get(0).getSiteId());
            siteMembershipRequest.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person24Id, siteMembershipRequest);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            siteMembershipRequest = new SiteMembershipRequest();
            siteMembershipRequest.setId(this.person1ModeratedSites.get(0).getSiteId());
            siteMembershipRequest.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person24Id, siteMembershipRequest);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            int skipCount4 = 0;
            int maxItems4 = 2;
            paging = this.getPaging(skipCount4, maxItems4, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
            this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person24Id, this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            SiteMembershipRequest siteMembershipRequest3 = new SiteMembershipRequest();
            siteMembershipRequest3.setId(this.person1PrivateSites.get(0).getSiteId());
            siteMembershipRequest3.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person24Id, siteMembershipRequest3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            int skipCount5 = 0;
            int maxItems5 = 2;
            paging = this.getPaging(skipCount5, maxItems5, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
            this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person24Id, this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.log("cloud-2513");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            siteMembershipRequest2 = new SiteMembershipRequest();
            siteMembershipRequest2.setId(GUID.generate());
            siteMembershipRequest2.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person11Id, siteMembershipRequest2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            siteMembershipRequest2 = new SiteMembershipRequest();
            siteMembershipRequest2.setId(this.person1PrivateSites.get(0).getSiteId());
            siteMembershipRequest2.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person11Id, siteMembershipRequest2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            siteMembershipRequest2 = new SiteMembershipRequest();
            siteMembershipRequest2.setId(this.person4ModeratedSites.get(0).getSiteId());
            siteMembershipRequest2.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person11Id, siteMembershipRequest2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.log("cloud-2514");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            siteMembershipRequest2 = new SiteMembershipRequest();
            siteMembershipRequest2.setId(this.person1ModeratedSites.get(0).getSiteId());
            siteMembershipRequest2.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person11Id, siteMembershipRequest2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            siteMembershipRequest2 = new SiteMembershipRequest();
            siteMembershipRequest2.setId(this.person1ModeratedSites.get(0).getSiteId());
            siteMembershipRequest2.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person11Id, siteMembershipRequest2);
            siteMembershipRequest2 = new SiteMembershipRequest();
            siteMembershipRequest2.setId(this.person1ModeratedSites.get(0).getSiteId());
            siteMembershipRequest2.setMessage("Please can I join your site?");
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person11Id, siteMembershipRequest2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2538");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
        siteMembershipRequest2 = new SiteMembershipRequest();
        siteMembershipRequest2.setId(this.person1ModeratedSites.get(1).getSiteId());
        siteMembershipRequest2.setMessage("");
        SiteMembershipRequest ret2 = this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person11Id, siteMembershipRequest2);
        expectedSiteMembershipRequests.add(ret2);
        this.log("cloud-2501");
        this.log("cloud-2509");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
        for (int i = 1; i < this.person1ModeratedSites.size(); ++i) {
            SiteMembershipRequest siteMembershipRequest4 = new SiteMembershipRequest();
            siteMembershipRequest4.setId(this.person1ModeratedSites.get(i).getSiteId());
            siteMembershipRequest4.setMessage("Please can I join your site?");
            try {
                ret3 = this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person11Id, siteMembershipRequest4);
                expectedSiteMembershipRequests.add(ret3);
                siteMembershipRequest4.expected(ret3);
                continue;
            }
            catch (PublicApiException ret3) {
                // empty catch block
            }
        }
        Collections.sort(expectedSiteMembershipRequests);
        skipCount = 0;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        resp = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person11Id, this.createParams(paging, null));
        this.checkList(expectedSiteMembershipRequests.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount = 2;
        maxItems = 5;
        paging = this.getPaging(skipCount, maxItems, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        resp = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person11Id, this.createParams(paging, null));
        this.checkList(expectedSiteMembershipRequests.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount = 5;
        maxItems = 10;
        paging = this.getPaging(skipCount, maxItems, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        resp = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person11Id, this.createParams(paging, null));
        this.checkList(expectedSiteMembershipRequests.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount = 0;
        maxItems = expectedSiteMembershipRequests.size();
        paging = this.getPaging(skipCount, maxItems, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        resp = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person11Id, this.createParams(paging, null));
        this.checkList(expectedSiteMembershipRequests.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount = 1000;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        resp = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person11Id, this.createParams(paging, null));
        this.checkList(this.sublist(expectedSiteMembershipRequests, skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        this.log("cloud-2537");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
        skipCount = 0;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        resp = this.siteMembershipRequestsProxy.getSiteMembershipRequests("-me-", this.createParams(paging, null));
        this.checkList(expectedSiteMembershipRequests.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        this.log("cloud-2504");
        SiteMembershipRequest request = this.getSiteMembershipRequest(this.network1.getId(), this.person11Id, this.person11Id);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
        this.siteMembershipRequestsProxy.cancelSiteMembershipRequest(this.person11Id, request.getId());
        expectedSiteMembershipRequests.remove(request);
        Collections.sort(expectedSiteMembershipRequests);
        this.log("cloud-2533");
        int skipCount6 = 0;
        int maxItems6 = Integer.MAX_VALUE;
        paging = this.getPaging(skipCount6, maxItems6, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        PublicApiClient.ListResponse<SiteMembershipRequest> resp5 = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person11Id, this.createParams(paging, null));
        this.checkList(expectedSiteMembershipRequests, paging.getExpectedPaging(), resp5);
        try {
            this.log("cloud-2528");
            this.siteMembershipRequestsProxy.cancelSiteMembershipRequest(this.person11Id, request.getId());
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2529");
        final String siteId2 = this.person1ModeratedSites.get(1).getSiteId();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14Id));
        SiteMembershipRequest siteMembershipRequest5 = new SiteMembershipRequest();
        siteMembershipRequest5.setId(siteId2);
        siteMembershipRequest5.setMessage("Please can I join your site?");
        SiteMembershipRequest moderatedSiteResponse2 = this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person14Id, siteMembershipRequest5);
        expectedSiteMembershipRequests.add(moderatedSiteResponse2);
        Collections.sort(expectedSiteMembershipRequests);
        siteMembershipRequest5.expected(moderatedSiteResponse2);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                Invitation invitation = TestSiteMembershipRequests.this.repoService.rejectSiteInvitation(TestSiteMembershipRequests.this.person14Id, siteId2);
                Assert.assertNotNull((Object)invitation);
                return null;
            }
        }, (String)this.person12Id, (String)this.network1.getId());
        try {
            this.siteMembershipRequestsProxy.cancelSiteMembershipRequest(this.person14Id, siteId2);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2530");
        siteId2 = this.person1ModeratedSites.get(2).getSiteId();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14Id));
        siteMembershipRequest5 = new SiteMembershipRequest();
        siteMembershipRequest5.setId(siteId2);
        siteMembershipRequest5.setMessage("Please can I join your site?");
        moderatedSiteResponse2 = this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person14Id, siteMembershipRequest5);
        expectedSiteMembershipRequests.add(moderatedSiteResponse2);
        Collections.sort(expectedSiteMembershipRequests);
        siteMembershipRequest5.expected(moderatedSiteResponse2);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                Invitation invitation = TestSiteMembershipRequests.this.repoService.approveSiteInvitation(TestSiteMembershipRequests.this.person14Id, siteId2);
                Assert.assertNotNull((Object)invitation);
                return null;
            }
        }, (String)this.person12Id, (String)this.network1.getId());
        try {
            this.siteMembershipRequestsProxy.cancelSiteMembershipRequest(this.person14Id, siteId2);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14Id));
        this.log("cloud-2503");
        this.log("cloud-2517");
        siteId2 = this.person1ModeratedSites.get(7).getSiteId();
        siteMembershipRequest5 = new SiteMembershipRequest();
        siteMembershipRequest5.setId(siteId2);
        SiteMembershipRequest request2 = this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person14Id, siteMembershipRequest5);
        Assert.assertNotNull((Object)request2);
        request2.setMessage("Please can I join your site?");
        SiteMembershipRequest updated = this.siteMembershipRequestsProxy.updateSiteMembershipRequest(this.person14Id, request2);
        request2.expected(updated);
        int skipCount7 = 0;
        int maxItems7 = 2;
        PublicApiClient.Paging paging6 = this.getPaging(skipCount7, maxItems7, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        PublicApiClient.ListResponse<SiteMembershipRequest> resp6 = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person14Id, this.createParams(paging6, null));
        List<SiteMembershipRequest> requests = resp6.getList();
        Assert.assertTrue((requests.size() > 0 ? 1 : 0) != 0);
        int idx = requests.indexOf(request2);
        SiteMembershipRequest toCheck = requests.get(idx);
        updated.expected(toCheck);
        this.log("cloud-2518");
        request2.setMessage("Please can I join your site, pretty please?");
        updated = this.siteMembershipRequestsProxy.updateSiteMembershipRequest(this.person14Id, request2);
        request2.expected(updated);
        skipCount7 = 0;
        maxItems7 = 2;
        paging6 = this.getPaging(skipCount7, maxItems7, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        resp6 = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person14Id, this.createParams(paging6, null));
        requests = resp6.getList();
        Assert.assertTrue((requests.size() > 0 ? 1 : 0) != 0);
        idx = requests.indexOf(request2);
        toCheck = requests.get(idx);
        updated.expected(toCheck);
        this.log("cloud-2515");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14Id));
        siteId2 = this.person1ModeratedSites.get(8).getSiteId();
        siteMembershipRequest5 = new SiteMembershipRequest();
        siteMembershipRequest5.setId(siteId2);
        siteMembershipRequest5.setMessage("Please can I join your site?");
        request2 = this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person14Id, siteMembershipRequest5);
        Assert.assertNotNull((Object)request2);
        updated = this.siteMembershipRequestsProxy.updateSiteMembershipRequest(this.person14Id, request2);
        request2.expected(updated);
        try {
            this.log("cloud-2516");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            skipCount = 0;
            maxItems = 2;
            paging = this.getPaging(skipCount, maxItems, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
            resp = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person11Id, this.createParams(paging, null));
            List<SiteMembershipRequest> requests2 = resp.getList();
            Assert.assertTrue((requests2.size() > 0 ? 1 : 0) != 0);
            SiteMembershipRequest request3 = requests2.get(0);
            this.siteMembershipRequestsProxy.updateSiteMembershipRequest(GUID.generate(), request3);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.log("cloud-2521");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            request = new SiteMembershipRequest();
            request.setId(GUID.generate());
            this.siteMembershipRequestsProxy.updateSiteMembershipRequest(this.person11Id, request);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2522");
        siteId = this.person1ModeratedSites.get(5).getSiteId();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14Id));
        siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(siteId);
        siteMembershipRequest.setMessage("Please can I join your site?");
        moderatedSiteResponse2 = this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person14Id, siteMembershipRequest);
        expectedSiteMembershipRequests.add(moderatedSiteResponse2);
        Collections.sort(expectedSiteMembershipRequests);
        siteMembershipRequest.expected(moderatedSiteResponse2);
        this.repoService.rejectSiteInvitation(this.person14Id, siteId);
        try {
            this.siteMembershipRequestsProxy.updateSiteMembershipRequest(siteId, moderatedSiteResponse2);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2523");
        siteId = this.person1ModeratedSites.get(6).getSiteId();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14Id));
        siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(siteId);
        siteMembershipRequest.setMessage("Please can I join your site?");
        moderatedSiteResponse2 = this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person14Id, siteMembershipRequest);
        expectedSiteMembershipRequests.add(moderatedSiteResponse2);
        Collections.sort(expectedSiteMembershipRequests);
        siteMembershipRequest.expected(moderatedSiteResponse2);
        this.repoService.approveSiteInvitation(this.person14Id, siteId);
        try {
            this.siteMembershipRequestsProxy.updateSiteMembershipRequest(siteId, moderatedSiteResponse2);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2539");
        ArrayList person2ExpectedSiteMembershipRequests = new ArrayList();
        final RepoService.TestSite site = this.person1ModeratedSites.get(0);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person13Id));
        SiteMembershipRequest siteMembershipRequest6 = new SiteMembershipRequest();
        siteMembershipRequest6.setId(site.getSiteId());
        siteMembershipRequest6.setMessage("Please can I join your site?");
        this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person13Id, siteMembershipRequest6);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                site.setSiteVisibility(SiteVisibility.PRIVATE);
                return null;
            }
        }, (String)this.person12Id, (String)this.network1.getId());
        try {
            this.siteMembershipRequestsProxy.getSiteMembershipRequest(this.person13Id, siteMembershipRequest6.getId());
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        skipCount = 0;
        maxItems = 10;
        Assert.assertEquals((long)0L, (long)person2ExpectedSiteMembershipRequests.size());
        paging = this.getPaging(skipCount, maxItems, person2ExpectedSiteMembershipRequests.size(), person2ExpectedSiteMembershipRequests.size());
        resp3 = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person13Id, this.createParams(paging, null));
        this.checkList(this.sublist(person2ExpectedSiteMembershipRequests, skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp3);
        try {
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person13Id, siteMembershipRequest6);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        final RepoService.TestSite site2 = this.person1PublicSites.get(0);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person13Id));
        siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(site2.getSiteId());
        siteMembershipRequest.setMessage("Please can I join your site?");
        this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person13Id, siteMembershipRequest);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                site2.setSiteVisibility(SiteVisibility.PRIVATE);
                return null;
            }
        }, (String)this.person12Id, (String)this.network1.getId());
        try {
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person13Id, siteMembershipRequest);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.siteMembershipRequestsProxy.updateSiteMembershipRequest(this.person13Id, siteMembershipRequest);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.siteMembershipRequestsProxy.cancelSiteMembershipRequest(this.person13Id, siteMembershipRequest.getId());
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        site2 = this.person1ModeratedSites.get(1);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person13Id));
        siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(site2.getSiteId());
        siteMembershipRequest.setMessage("Please can I join your site?");
        this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person13Id, siteMembershipRequest);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestSiteMembershipRequests.this.repoService.approveSiteInvitation(TestSiteMembershipRequests.this.person13Id, site2.getSiteId());
                site2.setSiteVisibility(SiteVisibility.PRIVATE);
                return null;
            }
        }, (String)this.person12Id, (String)this.network1.getId());
        try {
            this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person13Id, siteMembershipRequest);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        site2 = this.person1ModeratedSites.get(2);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person13Id));
        siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(site2.getSiteId());
        siteMembershipRequest.setMessage("");
        SiteMembershipRequest created = this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person13Id, siteMembershipRequest);
        updated = this.siteMembershipRequestsProxy.updateSiteMembershipRequest(this.person13Id, siteMembershipRequest);
        Assert.assertTrue((boolean)updated.getModifiedAt().after(created.getCreatedAt()));
    }

    @Test
    public void testMixedCase() throws Exception {
        ArrayList<SiteMembershipRequest> expectedSiteMembershipRequests = new ArrayList<SiteMembershipRequest>();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person15Id));
        String siteId = this.person1MixedCaseModeratedSites.get(0).getSiteId().toLowerCase();
        SiteMembershipRequest siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(siteId);
        siteMembershipRequest.setMessage("Please can I join your site?");
        SiteMembershipRequest moderatedSiteResponse = this.siteMembershipRequestsProxy.createSiteMembershipRequest("-me-", siteMembershipRequest);
        expectedSiteMembershipRequests.add(moderatedSiteResponse);
        Collections.sort(expectedSiteMembershipRequests);
        siteMembershipRequest.expected(moderatedSiteResponse);
        int skipCount = 0;
        int maxItems = 2;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, expectedSiteMembershipRequests.size(), expectedSiteMembershipRequests.size());
        PublicApiClient.ListResponse<SiteMembershipRequest> resp = this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.person15Id, this.createParams(paging, null));
        this.checkList(expectedSiteMembershipRequests.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        SiteMembershipRequest ret = this.siteMembershipRequestsProxy.getSiteMembershipRequest(this.person15Id, siteId);
        siteMembershipRequest.expected(ret);
        this.siteMembershipRequestsProxy.cancelSiteMembershipRequest(this.person15Id, ret.getId());
        try {
            this.siteMembershipRequestsProxy.getSiteMembershipRequest(this.person15Id, siteId);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    @Test
    public void testALF19332() throws Exception {
        String networkId = this.network1.getId();
        final RepoService.TestNetwork systemNetwork = this.getRepoService().getSystemNetwork();
        long time = System.currentTimeMillis();
        PersonInfo personInfo = new PersonInfo("test", "test", "test" + time, "password", null, "test", "test", "test", "test", "test", "test");
        RepoService.TestPerson person = this.network1.createUser(personInfo);
        personInfo = new PersonInfo("test", "test", "test1" + time, "password", null, "test", "test", "test", "test", "test", "test");
        RepoService.TestPerson person1 = this.network1.createUser(personInfo);
        RepoService.TestSite site = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite site = systemNetwork.createSite(SiteVisibility.PUBLIC);
                return site;
            }
        }, (String)person.getId(), (String)networkId);
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person1.getId()));
        SiteMembershipRequest siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(site.getSiteId());
        siteMembershipRequest.setMessage("Please can I join your site?");
        SiteMembershipRequest ret = this.siteMembershipRequestsProxy.createSiteMembershipRequest(person1.getId(), siteMembershipRequest);
    }

    @Test
    public void testGetSiteMembershipRequests() throws Exception {
        String networkId = this.network1.getId();
        final RepoService.TestNetwork systemNetwork = this.getRepoService().getSystemNetwork();
        RepoService.TestPerson siteManager = this.network1.createUser();
        RepoService.TestPerson person1 = this.network1.createUser();
        RepoService.TestPerson person2 = this.network1.createUser();
        RepoService.TestSite sitePublic = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite site = systemNetwork.createSite(SiteVisibility.PUBLIC);
                return site;
            }
        }, (String)siteManager.getId(), (String)networkId);
        RepoService.TestSite site = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite site = systemNetwork.createSite(SiteVisibility.MODERATED);
                return site;
            }
        }, (String)siteManager.getId(), (String)networkId);
        RepoService.TestSite site2 = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite site = systemNetwork.createSite(SiteVisibility.MODERATED);
                return site;
            }
        }, (String)siteManager.getId(), (String)networkId);
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person1.getId()));
        SiteMembershipRequest siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(sitePublic.getSiteId());
        siteMembershipRequest.setMessage("Please can I join your site?");
        SiteMembershipRequest ret = this.siteMembershipRequestsProxy.createSiteMembershipRequest(person1.getId(), siteMembershipRequest);
        Assert.assertNotNull((Object)ret);
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person1.getId()));
        siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(site.getSiteId());
        siteMembershipRequest.setMessage("Please can I join your site?");
        ret = this.siteMembershipRequestsProxy.createSiteMembershipRequest(person1.getId(), siteMembershipRequest);
        Assert.assertNotNull((Object)ret);
        int skipCount = 0;
        int maxItems = Integer.MAX_VALUE;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, siteManager.getId()));
        PublicApiClient.ListResponse<SiteMembershipRequest> resp = this.getSiteMembershipRequests(paging, null);
        List<SiteMembershipRequest> list = resp.getList();
        Assert.assertEquals((long)1L, (long)list.size());
        SiteMembershipRequest smr = list.get(0);
        Assert.assertNotNull((Object)smr.getPerson());
        Assert.assertNotNull((Object)smr.getPerson().getUserName());
        this.publicApiClient.setRequestContext(new RequestContext(networkId, person2.getId()));
        resp = this.getSiteMembershipRequests(paging, null);
        list = resp.getList();
        Assert.assertEquals((long)0L, (long)list.size());
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person2.getId()));
        ret = this.createSiteMembershipRequest(site.getSiteId(), person2.getId());
        Assert.assertNotNull((Object)ret);
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person1.getId()));
        ret = this.createSiteMembershipRequest(site2.getSiteId(), person1.getId());
        Assert.assertNotNull((Object)ret);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, siteManager.getId()));
        resp = this.getSiteMembershipRequests(paging, null);
        list = resp.getList();
        Assert.assertEquals((long)3L, (long)list.size());
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(siteId='" + site.getSiteId() + "')");
        resp = this.getSiteMembershipRequests(paging, otherParams);
        list = resp.getList();
        Assert.assertEquals((long)2L, (long)list.size());
        otherParams = new HashMap();
        otherParams.put("where", "(personId='" + person2.getId() + "')");
        resp = this.getSiteMembershipRequests(paging, otherParams);
        list = resp.getList();
        Assert.assertEquals((long)1L, (long)list.size());
        otherParams = new HashMap();
        otherParams.put("where", "(siteId='" + site.getSiteId() + "' and personId='" + person2.getId() + "')");
        resp = this.getSiteMembershipRequests(paging, otherParams);
        list = resp.getList();
        Assert.assertEquals((long)1L, (long)list.size());
        RepoService.TestPerson person3 = this.network1.createUser();
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person3.getId()));
        ret = this.createSiteMembershipRequest(site.getSiteId(), person3.getId());
        Assert.assertNotNull((Object)ret);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, siteManager.getId()));
        this.approve(site.getSiteId(), person3.getId(), new SiteMembershipApproval(), 200, null);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, person3.getId()));
        PublicApiClient.ListResponse<SiteMembershipRequest> resp2 = this.getSiteMembershipRequests(paging, null);
        List<SiteMembershipRequest> list2 = resp2.getList();
        Assert.assertEquals((long)0L, (long)list2.size());
    }

    @Test
    public void testApproveSiteMembershipRequests() throws Exception {
        String networkId = this.network1.getId();
        final RepoService.TestNetwork systemNetwork = this.getRepoService().getSystemNetwork();
        RepoService.TestPerson siteManager = this.network1.createUser();
        RepoService.TestSite site = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite site = systemNetwork.createSite(SiteVisibility.MODERATED);
                return site;
            }
        }, (String)siteManager.getId(), (String)networkId);
        RepoService.TestPerson person1 = this.network1.createUser();
        RepoService.TestPerson person2 = this.network1.createUser();
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person1.getId()));
        SiteMembershipRequest ret = this.createSiteMembershipRequest(site.getSiteId(), person1.getId());
        Assert.assertNotNull((Object)ret);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, siteManager.getId()));
        this.approve("siteId", person1.getId(), new SiteMembershipApproval(), 404, null);
        this.approve(site.getSiteId(), null, new SiteMembershipApproval(), 404, null);
        this.approve(site.getSiteId(), person2.getId(), new SiteMembershipApproval(), 404, null);
        final RepoService.TestSite tempSite = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite site = systemNetwork.createSite(SiteVisibility.MODERATED);
                return site;
            }
        }, (String)siteManager.getId(), (String)networkId);
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person1.getId()));
        ret = this.createSiteMembershipRequest(tempSite.getSiteId(), person1.getId());
        Assert.assertNotNull((Object)ret);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, siteManager.getId()));
        final SiteInfo tempSiteInfo = tempSite.getSiteInfo();
        Assert.assertEquals((Object)SiteVisibility.MODERATED, (Object)tempSiteInfo.getVisibility());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                tempSite.setSiteVisibility(SiteVisibility.PRIVATE);
                Assert.assertEquals((Object)SiteVisibility.PRIVATE, (Object)tempSiteInfo.getVisibility());
                return null;
            }
        }, (String)siteManager.getId(), (String)networkId);
        this.approve(tempSite.getSiteId(), person1.getId(), new SiteMembershipApproval(), 404, null);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, person2.getId()));
        this.approve(site.getSiteId(), person1.getId(), new SiteMembershipApproval(), 404, null);
        RepoService.TestPerson person3 = this.network1.createUser();
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person3.getId()));
        ret = this.createSiteMembershipRequest(site.getSiteId(), person3.getId());
        Assert.assertNotNull((Object)ret);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, siteManager.getId()));
        this.approve(site.getSiteId(), person3.getId(), new SiteMembershipApproval(), 200, null);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, person3.getId()));
        MemberOfSite memberOfSite = this.publicApiClient.sites().getPersonSite(person3.getId(), site.getSiteId());
        Assert.assertNotNull((Object)memberOfSite);
        Assert.assertEquals((Object)((Object)SiteRole.SiteConsumer), (Object)((Object)memberOfSite.getRole()));
        this.approve(site.getSiteId(), person1.getId(), new SiteMembershipApproval(), 404, null);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, person1.getId()));
        this.approve(site.getSiteId(), person1.getId(), new SiteMembershipApproval(), 403, null);
        this.approve(site.getSiteId(), person1.getId(), null, 403, null);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, siteManager.getId()));
        this.approve(site.getSiteId(), person1.getId(), new SiteMembershipApproval(), 200, null);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, person1.getId()));
        MemberOfSite memberOfSite2 = this.publicApiClient.sites().getPersonSite(person1.getId(), site.getSiteId());
        Assert.assertNotNull((Object)memberOfSite2);
        Assert.assertEquals((Object)((Object)SiteRole.SiteConsumer), (Object)((Object)memberOfSite2.getRole()));
        this.approve(site.getSiteId(), person1.getId(), new SiteMembershipApproval(), 404, null);
        tempSite = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite site = systemNetwork.createSite(SiteVisibility.MODERATED);
                return site;
            }
        }, (String)siteManager.getId(), (String)networkId);
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person1.getId()));
        ret = this.createSiteMembershipRequest(tempSite.getSiteId(), person1.getId());
        Assert.assertNotNull((Object)ret);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, siteManager.getId()));
        this.approve(tempSite.getSiteId(), person1.getId(), new SiteMembershipApproval("invalidRole"), 400, null);
        this.approve(tempSite.getSiteId(), person1.getId(), new SiteMembershipApproval(SiteRole.SiteCollaborator.toString()), 200, null);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, person1.getId()));
        memberOfSite = this.publicApiClient.sites().getPersonSite(person1.getId(), tempSite.getSiteId());
        Assert.assertNotNull((Object)memberOfSite);
        Assert.assertEquals((Object)((Object)SiteRole.SiteCollaborator), (Object)((Object)memberOfSite.getRole()));
    }

    @Test
    public void testRejectSiteMembershipRequests() throws Exception {
        String networkId = this.network1.getId();
        final RepoService.TestNetwork systemNetwork = this.getRepoService().getSystemNetwork();
        RepoService.TestPerson siteManager = this.network1.createUser();
        RepoService.TestSite site = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite site = systemNetwork.createSite(SiteVisibility.MODERATED);
                return site;
            }
        }, (String)siteManager.getId(), (String)networkId);
        RepoService.TestPerson person1 = this.network1.createUser();
        RepoService.TestPerson person2 = this.network1.createUser();
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person1.getId()));
        SiteMembershipRequest ret = this.createSiteMembershipRequest(site.getSiteId(), person1.getId());
        Assert.assertNotNull((Object)ret);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, siteManager.getId()));
        this.reject("siteId", person1.getId(), new SiteMembershipRejection(), 404, null);
        this.reject(site.getSiteId(), null, new SiteMembershipRejection(), 404, null);
        this.reject(site.getSiteId(), person2.getId(), new SiteMembershipRejection(), 404, null);
        final RepoService.TestSite tempSite = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite site = systemNetwork.createSite(SiteVisibility.MODERATED);
                return site;
            }
        }, (String)siteManager.getId(), (String)networkId);
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person1.getId()));
        ret = this.createSiteMembershipRequest(tempSite.getSiteId(), person1.getId());
        Assert.assertNotNull((Object)ret);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, siteManager.getId()));
        final SiteInfo tempSiteInfo = tempSite.getSiteInfo();
        Assert.assertEquals((Object)SiteVisibility.MODERATED, (Object)tempSiteInfo.getVisibility());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                tempSite.setSiteVisibility(SiteVisibility.PRIVATE);
                Assert.assertEquals((Object)SiteVisibility.PRIVATE, (Object)tempSiteInfo.getVisibility());
                return null;
            }
        }, (String)siteManager.getId(), (String)networkId);
        this.reject(tempSite.getSiteId(), person1.getId(), new SiteMembershipRejection(), 404, null);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, person1.getId()));
        this.reject(site.getSiteId(), person1.getId(), new SiteMembershipRejection(), 403, null);
        this.reject(site.getSiteId(), person1.getId(), null, 403, null);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, person2.getId()));
        this.reject(site.getSiteId(), person1.getId(), new SiteMembershipRejection(), 404, null);
        RepoService.TestPerson person3 = this.network1.createUser();
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person3.getId()));
        ret = this.createSiteMembershipRequest(site.getSiteId(), person3.getId());
        Assert.assertNotNull((Object)ret);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, siteManager.getId()));
        this.approve(site.getSiteId(), person3.getId(), new SiteMembershipApproval(), 200, null);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, person3.getId()));
        MemberOfSite memberOfSite = this.publicApiClient.sites().getPersonSite(person3.getId(), site.getSiteId());
        Assert.assertNotNull((Object)memberOfSite);
        Assert.assertEquals((Object)((Object)SiteRole.SiteConsumer), (Object)((Object)memberOfSite.getRole()));
        this.reject(site.getSiteId(), person1.getId(), new SiteMembershipRejection(), 404, null);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, siteManager.getId()));
        this.reject(site.getSiteId(), person1.getId(), new SiteMembershipRejection(), 200, null);
        int skipCount = 0;
        int maxItems = Integer.MAX_VALUE;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(siteId='" + site.getSiteId() + "')");
        PublicApiClient.ListResponse<SiteMembershipRequest> resp = this.getSiteMembershipRequests(paging, otherParams);
        List<SiteMembershipRequest> list = resp.getList();
        Assert.assertEquals((long)0L, (long)list.size());
        this.reject(site.getSiteId(), person1.getId(), new SiteMembershipRejection(), 404, null);
    }

    private PublicApiClient.ListResponse<SiteMembershipRequest> getSiteMembershipRequests(PublicApiClient.Paging paging, Map<String, String> otherParams) throws Exception {
        return this.siteMembershipRequestsProxy.getSiteMembershipRequests(this.createParams(paging, otherParams), "Failed to get site membership requests", 200);
    }

    private SiteMembershipRequest createSiteMembershipRequest(String siteId, String personId) throws ParseException, PublicApiException {
        SiteMembershipRequest siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(siteId);
        siteMembershipRequest.setMessage("Please can I join your site?");
        return this.siteMembershipRequestsProxy.createSiteMembershipRequest(personId, siteMembershipRequest);
    }

    private void approve(String siteId, String inviteeId, SiteMembershipApproval siteMembershipApproval, int expectedStatus, Map<String, String> parameters) throws Exception {
        String scope = "public";
        String url = this.getMembershipRequestApprovalUrl(siteId, inviteeId);
        String body = siteMembershipApproval != null ? RestApiUtil.toJsonAsString((Object)siteMembershipApproval) : null;
        HttpResponse response = this.publicApiClient.post(scope, url, null, null, null, body);
        this.checkStatus(expectedStatus, response.getStatusCode());
    }

    private void reject(String siteId, String inviteeId, SiteMembershipRejection siteMembershipRejection, int expectedStatus, Map<String, String> parameters) throws Exception {
        String scope = "public";
        String url = this.getMembershipRequestRejectionUrl(siteId, inviteeId);
        String body = siteMembershipRejection != null ? RestApiUtil.toJsonAsString((Object)siteMembershipRejection) : null;
        HttpResponse response = this.publicApiClient.post(scope, url, null, null, null, body);
        this.checkStatus(expectedStatus, response.getStatusCode());
    }

    private String getMembershipRequestApprovalUrl(String siteId, String inviteeId) {
        return this.getMembershipRequestUrlByAction(siteId, inviteeId, "approve");
    }

    private String getMembershipRequestRejectionUrl(String siteId, String inviteeId) {
        return this.getMembershipRequestUrlByAction(siteId, inviteeId, "reject");
    }

    private String getMembershipRequestUrlByAction(String siteId, String inviteeId, String action) {
        return "sites/" + siteId + "/site-membership-requests/" + inviteeId + "/" + action;
    }

    private void checkStatus(int expectedStatus, int actualStatus) {
        if (expectedStatus > 0 && expectedStatus != actualStatus) {
            Assert.fail((String)("Status code " + actualStatus + " returned, but expected " + expectedStatus));
        }
    }
}

