/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.Collections;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.favourites.PersonFavourite;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.impl.FavouritesImpl;
import org.alfresco.rest.api.model.Document;
import org.alfresco.rest.api.model.DocumentTarget;
import org.alfresco.rest.api.model.Favourite;
import org.alfresco.rest.api.model.Target;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.favourites.FavouritesService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespaceService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class FavouritesImplUnitTest {
    static final String NODE_ID = "12345678";
    static final NodeRef NODE_REF = new NodeRef("favourite://node/12345678");
    static final String PERSON_ID = "personId";
    static final String ASPECT_NAME = "some:aspect";
    @InjectMocks
    FavouritesImpl favouritesImpl;
    @Mock
    People people;
    @Mock
    Nodes nodes;
    @Mock
    FavouritesService favouritesService;
    @Mock
    NamespaceService namespaceService;
    @Mock
    Favourite favourite;
    @Mock
    Document document;
    @Mock
    PersonFavourite personFavourite;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        Mockito.when((Object)this.nodes.getDocument(NODE_REF)).thenReturn((Object)this.document);
        Mockito.when((Object)this.nodes.nodeMatches(NODE_REF, Collections.singleton(ContentModel.TYPE_CONTENT), null)).thenReturn((Object)true);
        Mockito.when((Object)this.document.getGuid()).thenReturn((Object)NODE_REF);
        Mockito.when((Object)this.people.validatePerson(PERSON_ID, true)).thenReturn((Object)PERSON_ID);
        Mockito.when((Object)this.personFavourite.getNodeRef()).thenReturn((Object)NODE_REF);
        Mockito.when((Object)this.personFavourite.getType()).thenReturn((Object)FavouritesService.Type.FILE);
        Mockito.when((Object)this.favouritesService.addFavourite(PERSON_ID, NODE_REF)).thenReturn((Object)this.personFavourite);
        Mockito.when((Object)this.namespaceService.getPrefixes(ArgumentMatchers.anyString())).thenReturn(List.of("prefix"));
    }

    @Test
    public void testAddFavourite() {
        DocumentTarget documentTarget = new DocumentTarget(this.document);
        Mockito.when((Object)this.favourite.getTarget()).thenReturn((Object)documentTarget);
        Favourite response = this.favouritesImpl.addFavourite(PERSON_ID, this.favourite);
        Favourite expected = new Favourite();
        expected.setTarget((Target)documentTarget);
        expected.setTargetGuid(NODE_ID);
        Assert.assertEquals((Object)expected, (Object)response);
    }

    @Test
    public void testAddFavouriteIncludeAspectNames() {
        List<String> includes = List.of("aspectNames");
        DocumentTarget documentTarget = new DocumentTarget(this.document);
        Mockito.when((Object)this.favourite.getTarget()).thenReturn((Object)documentTarget);
        Mockito.when((Object)this.nodes.getFolderOrDocument(NODE_REF, null, null, includes, null)).thenReturn((Object)this.document);
        Mockito.when((Object)this.document.getAspectNames()).thenReturn(List.of(ASPECT_NAME));
        Parameters parameters = (Parameters)Mockito.mock(Parameters.class);
        Mockito.when((Object)parameters.getInclude()).thenReturn(includes);
        Favourite response = this.favouritesImpl.addFavourite(PERSON_ID, this.favourite, parameters);
        Favourite expected = new Favourite();
        expected.setTarget((Target)documentTarget);
        expected.setTargetGuid(NODE_ID);
        expected.setAspectNames(List.of(ASPECT_NAME));
        Assert.assertEquals((Object)expected, (Object)response);
    }
}

