/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.forms;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public abstract class AbstractTestFormRestApi
extends BaseWebScriptTest {
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String TEST_FORM_DESCRIPTION = "Test form description";
    protected static final String TEST_FORM_TITLE = "Test form title";
    protected static final String FORM_DEF_URL = "/api/formdefinitions";
    protected String referencingNodeUpdateUrl;
    protected String containingNodeUpdateUrl;
    protected String containingNodeUrl;
    protected NodeRef referencingDocNodeRef;
    protected Map<QName, Serializable> refNodePropertiesAfterCreation;
    protected NodeRef associatedDoc_A;
    protected NodeRef associatedDoc_B;
    protected NodeRef associatedDoc_C;
    protected NodeRef associatedDoc_D;
    protected NodeRef associatedDoc_E;
    protected NodeRef childDoc_A;
    protected NodeRef childDoc_B;
    protected NodeRef childDoc_C;
    protected NodeRef childDoc_D;
    protected NodeRef childDoc_E;
    protected NodeRef testFolderNodeRef;
    protected NodeService nodeService;
    private FileFolderService fileFolderService;
    private ContentService contentService;
    private Repository repositoryHelper;
    protected NodeRef containerNodeRef;
    protected TransactionService transactionService;

    protected void setUp() throws Exception {
        super.setUp();
        this.fileFolderService = (FileFolderService)this.getServer().getApplicationContext().getBean("FileFolderService");
        this.contentService = (ContentService)this.getServer().getApplicationContext().getBean("ContentService");
        this.repositoryHelper = (Repository)this.getServer().getApplicationContext().getBean("repositoryHelper");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.transactionService = (TransactionService)this.getServer().getApplicationContext().getBean("transactionService");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                NodeRef companyHomeNodeRef = AbstractTestFormRestApi.this.repositoryHelper.getCompanyHome();
                String guid = GUID.generate();
                FileInfo referencingDoc = AbstractTestFormRestApi.this.fileFolderService.create(companyHomeNodeRef, "referencingDoc" + guid + ".txt", ContentModel.TYPE_CONTENT);
                AbstractTestFormRestApi.this.referencingDocNodeRef = referencingDoc.getNodeRef();
                HashMap<QName, String> aspectProps = new HashMap<QName, String>(2);
                aspectProps.put(ContentModel.PROP_TITLE, AbstractTestFormRestApi.TEST_FORM_TITLE);
                aspectProps.put(ContentModel.PROP_DESCRIPTION, AbstractTestFormRestApi.TEST_FORM_DESCRIPTION);
                AbstractTestFormRestApi.this.nodeService.addAspect(AbstractTestFormRestApi.this.referencingDocNodeRef, ContentModel.ASPECT_TITLED, aspectProps);
                ContentWriter contentWriter = AbstractTestFormRestApi.this.contentService.getWriter(referencingDoc.getNodeRef(), ContentModel.PROP_CONTENT, true);
                contentWriter.setEncoding("UTF-8");
                contentWriter.setMimetype("text/plain");
                contentWriter.putContent("The quick brown fox jumped over the lazy dog.");
                FileInfo associatedDocsFolder = AbstractTestFormRestApi.this.fileFolderService.create(companyHomeNodeRef, "testFolder" + guid, ContentModel.TYPE_FOLDER);
                AbstractTestFormRestApi.this.testFolderNodeRef = associatedDocsFolder.getNodeRef();
                AbstractTestFormRestApi.this.associatedDoc_A = AbstractTestFormRestApi.this.createTestNode("associatedDoc_A" + guid);
                AbstractTestFormRestApi.this.associatedDoc_B = AbstractTestFormRestApi.this.createTestNode("associatedDoc_B" + guid);
                AbstractTestFormRestApi.this.associatedDoc_C = AbstractTestFormRestApi.this.createTestNode("associatedDoc_C" + guid);
                AbstractTestFormRestApi.this.associatedDoc_D = AbstractTestFormRestApi.this.createTestNode("associatedDoc_D" + guid);
                AbstractTestFormRestApi.this.associatedDoc_E = AbstractTestFormRestApi.this.createTestNode("associatedDoc_E" + guid);
                aspectProps.clear();
                AbstractTestFormRestApi.this.nodeService.addAspect(AbstractTestFormRestApi.this.referencingDocNodeRef, ContentModel.ASPECT_REFERENCING, aspectProps);
                AbstractTestFormRestApi.this.nodeService.createAssociation(AbstractTestFormRestApi.this.referencingDocNodeRef, AbstractTestFormRestApi.this.associatedDoc_A, ContentModel.ASSOC_REFERENCES);
                AbstractTestFormRestApi.this.nodeService.createAssociation(AbstractTestFormRestApi.this.referencingDocNodeRef, AbstractTestFormRestApi.this.associatedDoc_B, ContentModel.ASSOC_REFERENCES);
                HashMap containerProps = new HashMap();
                AbstractTestFormRestApi.this.containerNodeRef = AbstractTestFormRestApi.this.nodeService.createNode(companyHomeNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testContainer" + guid)), ContentModel.TYPE_CONTAINER, containerProps).getChildRef();
                AbstractTestFormRestApi.this.childDoc_A = AbstractTestFormRestApi.this.createTestNode("childDoc_A" + guid);
                AbstractTestFormRestApi.this.childDoc_B = AbstractTestFormRestApi.this.createTestNode("childDoc_B" + guid);
                AbstractTestFormRestApi.this.childDoc_C = AbstractTestFormRestApi.this.createTestNode("childDoc_C" + guid);
                AbstractTestFormRestApi.this.childDoc_D = AbstractTestFormRestApi.this.createTestNode("childDoc_D" + guid);
                AbstractTestFormRestApi.this.childDoc_E = AbstractTestFormRestApi.this.createTestNode("childDoc_E" + guid);
                AbstractTestFormRestApi.this.nodeService.addChild(AbstractTestFormRestApi.this.containerNodeRef, AbstractTestFormRestApi.this.childDoc_A, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"childA"));
                AbstractTestFormRestApi.this.nodeService.addChild(AbstractTestFormRestApi.this.containerNodeRef, AbstractTestFormRestApi.this.childDoc_B, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"childB"));
                StringBuilder builder = new StringBuilder();
                builder.append("/api/node/workspace/").append(AbstractTestFormRestApi.this.referencingDocNodeRef.getStoreRef().getIdentifier()).append("/").append(AbstractTestFormRestApi.this.referencingDocNodeRef.getId()).append("/formprocessor");
                AbstractTestFormRestApi.this.referencingNodeUpdateUrl = builder.toString();
                builder = new StringBuilder();
                builder.append("/api/node/workspace/").append(AbstractTestFormRestApi.this.containerNodeRef.getStoreRef().getIdentifier()).append("/").append(AbstractTestFormRestApi.this.containerNodeRef.getId()).append("/formprocessor");
                AbstractTestFormRestApi.this.containingNodeUpdateUrl = builder.toString();
                AbstractTestFormRestApi.this.refNodePropertiesAfterCreation = AbstractTestFormRestApi.this.nodeService.getProperties(AbstractTestFormRestApi.this.referencingDocNodeRef);
                AbstractTestFormRestApi.this.refNodePropertiesAfterCreation.toString();
                return null;
            }
        });
    }

    public void tearDown() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.referencingDocNodeRef);
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.associatedDoc_A);
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.associatedDoc_B);
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.associatedDoc_C);
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.associatedDoc_D);
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.associatedDoc_E);
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.childDoc_A);
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.childDoc_B);
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.childDoc_C);
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.childDoc_D);
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.childDoc_E);
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.testFolderNodeRef);
                AbstractTestFormRestApi.this.nodeService.deleteNode(AbstractTestFormRestApi.this.containerNodeRef);
                return null;
            }
        });
    }

    protected TestWebScriptServer.Response sendGetReq(String url, int expectedStatusCode) throws IOException, UnsupportedEncodingException {
        TestWebScriptServer.Response result = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), expectedStatusCode);
        return result;
    }

    protected NodeRef createTestNode(String associatedDocName) {
        HashMap<QName, CallSite> docProps = new HashMap<QName, CallSite>(1);
        docProps.put(ContentModel.PROP_NAME, (CallSite)((Object)(associatedDocName + ".txt")));
        return this.nodeService.createNode(this.testFolderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)(associatedDocName + ".txt")), ContentModel.TYPE_CONTENT, docProps).getChildRef();
    }
}

