/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.io.InputStream;
import org.alfresco.repo.content.directurl.DirectAccessUrlDisabledException;
import org.alfresco.rest.api.DirectAccessUrlHelper;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.model.DirectAccessUrlRequest;
import org.alfresco.rest.api.model.LockInfo;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.NodeTarget;
import org.alfresco.rest.framework.BinaryProperties;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.content.BasicContentInfo;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="nodes", title="Nodes")
public class NodesEntityResource
implements EntityResourceAction.ReadById<Node>,
EntityResourceAction.Delete,
EntityResourceAction.Update<Node>,
BinaryResourceAction.Read,
BinaryResourceAction.Update<Node>,
InitializingBean {
    private Nodes nodes;
    private DirectAccessUrlHelper directAccessUrlHelper;

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setDirectAccessUrlHelper(DirectAccessUrlHelper directAccessUrlHelper) {
        this.directAccessUrlHelper = directAccessUrlHelper;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"nodes", (Object)this.nodes);
    }

    @Override
    @WebApiDescription(title="Get Node Information", description="Get information for the node with id 'nodeId'")
    @WebApiParam(name="nodeId", title="The node id")
    public Node readById(String nodeId, Parameters parameters) {
        return this.nodes.getFolderOrDocument(nodeId, parameters);
    }

    @Override
    @WebApiDescription(title="Download content", description="Download content")
    @BinaryProperties(value={"content"})
    public BinaryResource readProperty(String fileNodeId, Parameters parameters) throws EntityNotFoundException {
        return this.nodes.getContent(fileNodeId, parameters, true);
    }

    @Override
    @WebApiDescription(title="Upload content", description="Upload content")
    @BinaryProperties(value={"content"})
    public Node updateProperty(String fileNodeId, BasicContentInfo contentInfo, InputStream stream, Parameters parameters) {
        return this.nodes.updateContent(fileNodeId, contentInfo, stream, parameters);
    }

    @Override
    @WebApiDescription(title="Updates a node (file or folder) with id 'nodeId'")
    public Node update(String nodeId, Node nodeInfo, Parameters parameters) {
        return this.nodes.updateNode(nodeId, nodeInfo, parameters);
    }

    @Override
    @WebApiDescription(title="Delete Node", description="Delete the file or folder with id 'nodeId'. Folder will cascade delete")
    public void delete(String nodeId, Parameters parameters) {
        this.nodes.deleteNode(nodeId, parameters);
    }

    @Operation(value="copy")
    @WebApiDescription(title="Copy Node", description="Copy one or more nodes (files or folders) to a new target folder, with option to rename.")
    public Node copyById(String nodeId, NodeTarget target, Parameters parameters, WithResponse withResponse) {
        return this.nodes.moveOrCopyNode(nodeId, target.getTargetParentId(), target.getName(), parameters, true);
    }

    @Operation(value="move")
    @WebApiDescription(title="Move Node", description="Moves one or more nodes (files or folders) to a new target folder, with option to rename.", successStatus=200)
    public Node moveById(String nodeId, NodeTarget target, Parameters parameters, WithResponse withResponse) {
        return this.nodes.moveOrCopyNode(nodeId, target.getTargetParentId(), target.getName(), parameters, false);
    }

    @Operation(value="lock")
    @WebApiDescription(title="Lock Node", description="Places a lock on a node.", successStatus=200)
    public Node lock(String nodeId, LockInfo lockInfo, Parameters parameters, WithResponse withResponse) {
        return this.nodes.lock(nodeId, lockInfo, parameters);
    }

    @Operation(value="unlock")
    @WebApiDescription(title="Unlock Node", description="Removes a lock on a node.", successStatus=200)
    public Node unlock(String nodeId, Void ignore, Parameters parameters, WithResponse withResponse) {
        return this.nodes.unlock(nodeId, parameters);
    }

    @Operation(value="request-direct-access-url")
    @WebApiParam(name="directAccessUrlRequest", title="Request direct access url", description="Options for direct access url request", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Request content url", description="Generates a direct access URL.", successStatus=200)
    public DirectAccessUrl requestContentDirectUrl(String nodeId, DirectAccessUrlRequest directAccessUrlRequest, Parameters parameters, WithResponse withResponse) {
        DirectAccessUrl directAccessUrl;
        boolean attachment = this.directAccessUrlHelper.getAttachment(directAccessUrlRequest);
        Long validFor = this.directAccessUrlHelper.getDefaultExpiryTimeInSec();
        String fileName = this.directAccessUrlHelper.getFileName(directAccessUrlRequest);
        NodeRef nodeRef = this.nodes.validateNode(nodeId);
        try {
            directAccessUrl = this.nodes.requestContentDirectUrl(nodeRef, attachment, validFor, fileName);
        }
        catch (DirectAccessUrlDisabledException ex) {
            throw new DisabledServiceException(ex.getMessage());
        }
        return directAccessUrl;
    }
}

