/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.List;
import org.alfresco.rest.api.model.CustomAspect;
import org.alfresco.rest.api.model.CustomModel;
import org.alfresco.rest.api.model.CustomType;
import org.alfresco.rest.api.tests.BaseCustomModelApiTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class TestCustomModel
extends BaseCustomModelApiTest {
    @Test
    public void testCreateBasicModel() throws Exception {
        String modelName = "testModel" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        CustomModel customModel = new CustomModel();
        customModel.setName(modelName);
        customModel.setNamespaceUri((String)namespacePair.getFirst());
        customModel.setNamespacePrefix((String)namespacePair.getSecond());
        customModel.setDescription("Test model description");
        customModel.setStatus(CustomModel.ModelStatus.DRAFT);
        this.setRequestContext(this.nonAdminUserName);
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 403);
        this.setRequestContext(this.customModelAdmin);
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 201);
        HttpResponse response = this.getSingle("cmm", modelName, 200);
        CustomModel returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        this.compareCustomModels(customModel, returnedModel, "author");
    }

    @Test
    public void testCreateBasicModel_Invalid() throws Exception {
        String modelName = "testModel" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        CustomModel customModel = new CustomModel();
        customModel.setName(modelName);
        customModel.setNamespaceUri((String)namespacePair.getFirst());
        customModel.setNamespacePrefix((String)namespacePair.getSecond());
        this.setRequestContext(this.customModelAdmin);
        customModel.setName(modelName + "<script>alert('oops')</script>");
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 400);
        customModel.setName("prefix:" + modelName);
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 400);
        customModel.setName("prefix " + modelName);
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 400);
        customModel.setName(modelName);
        customModel.setNamespacePrefix((String)namespacePair.getSecond() + " space");
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 400);
        customModel.setNamespacePrefix((String)namespacePair.getSecond() + "invalid/");
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 400);
        customModel.setNamespacePrefix((String)namespacePair.getSecond());
        customModel.setNamespaceUri((String)namespacePair.getFirst() + " space");
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 400);
        customModel.setNamespaceUri((String)namespacePair.getFirst() + "\\");
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 400);
        customModel.setName("");
        customModel.setNamespacePrefix((String)namespacePair.getSecond());
        customModel.setNamespaceUri((String)namespacePair.getFirst());
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 400);
        customModel.setName(modelName);
        customModel.setNamespaceUri(null);
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 400);
        customModel.setName(modelName);
        customModel.setNamespaceUri((String)namespacePair.getFirst());
        customModel.setNamespacePrefix(null);
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 400);
        customModel.setName("contentmodel");
        customModel.setNamespaceUri((String)namespacePair.getFirst());
        customModel.setNamespacePrefix((String)namespacePair.getSecond());
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 409);
        customModel.setName(modelName);
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 201);
        namespacePair = this.getTestNamespaceUriPrefixPair();
        customModel.setNamespaceUri((String)namespacePair.getFirst());
        customModel.setNamespacePrefix((String)namespacePair.getSecond());
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 409);
        String modelNameTwo = "testModelTwo" + System.currentTimeMillis();
        Pair<String, String> namespacePairTwo = this.getTestNamespaceUriPrefixPair();
        CustomModel customModelTwo = new CustomModel();
        customModelTwo.setName(modelNameTwo);
        customModelTwo.setNamespaceUri((String)namespacePairTwo.getFirst());
        customModelTwo.setNamespacePrefix((String)namespacePairTwo.getSecond());
        this.post("cmm", RestApiUtil.toJsonAsString(customModelTwo), 201);
        String modelNameThree = "testModelThree" + System.currentTimeMillis();
        Pair<String, String> namespacePairThree = this.getTestNamespaceUriPrefixPair();
        CustomModel customModelThree = new CustomModel();
        customModelThree.setName(modelNameThree);
        customModelThree.setNamespaceUri((String)namespacePairTwo.getFirst());
        customModelThree.setNamespacePrefix((String)namespacePairThree.getSecond());
        this.post("cmm", RestApiUtil.toJsonAsString(customModelThree), 409);
        customModelThree.setNamespaceUri((String)namespacePairThree.getFirst());
        customModelThree.setNamespacePrefix((String)namespacePairTwo.getSecond());
        this.post("cmm", RestApiUtil.toJsonAsString(customModelThree), 409);
    }

    @Test
    public void testListBasicModels() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName_1 = "testModel1" + System.currentTimeMillis();
        CustomModel customModel_1 = this.createCustomModel(modelName_1, this.getTestNamespaceUriPrefixPair(), CustomModel.ModelStatus.DRAFT);
        String modelName_2 = "testModel2" + System.currentTimeMillis();
        CustomModel customModel_2 = this.createCustomModel(modelName_2, this.getTestNamespaceUriPrefixPair(), CustomModel.ModelStatus.DRAFT);
        String modelName_3 = "testModel3" + System.currentTimeMillis();
        CustomModel customModel_3 = this.createCustomModel(modelName_3, this.getTestNamespaceUriPrefixPair(), CustomModel.ModelStatus.DRAFT);
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HttpResponse response = this.getAll("cmm", paging, 200);
        List<CustomModel> models = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), CustomModel.class);
        Assert.assertTrue((models.size() >= 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)models.contains(customModel_1));
        Assert.assertTrue((boolean)models.contains(customModel_2));
        Assert.assertTrue((boolean)models.contains(customModel_3));
    }

    @Test
    public void testActivateCustomModel() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelNameOne = "testActivateModelOne" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        CustomModel customModelOne = this.createCustomModel(modelNameOne, namespacePair, CustomModel.ModelStatus.DRAFT, "Test model description", "Jane Doe");
        HttpResponse response = this.getSingle("cmm", modelNameOne, 200);
        CustomModel returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)CustomModel.ModelStatus.DRAFT, (Object)returnedModel.getStatus());
        CustomModel updatePayload = new CustomModel();
        updatePayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.setRequestContext(this.nonAdminUserName);
        this.put("cmm", modelNameOne, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 403);
        this.setRequestContext(this.customModelAdmin);
        this.put("cmm", modelNameOne, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 200);
        response = this.getSingle("cmm", modelNameOne, 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)CustomModel.ModelStatus.ACTIVE, (Object)returnedModel.getStatus());
        this.compareCustomModels(customModelOne, returnedModel, "status");
        this.put("cmm", modelNameOne, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 500);
        String modelNameTwo = "testActivateModelTwo" + System.currentTimeMillis();
        Pair<String, String> namespacePairTwo = this.getTestNamespaceUriPrefixPair();
        CustomModel customModelTwo = this.createCustomModel(modelNameTwo, namespacePairTwo, CustomModel.ModelStatus.DRAFT, null, "John Doe");
        customModelTwo.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelNameTwo, RestApiUtil.toJsonAsString(customModelTwo), "?select=status", 200);
        response = this.getSingle("cmm", modelNameTwo, 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)CustomModel.ModelStatus.ACTIVE, (Object)returnedModel.getStatus());
        this.compareCustomModels(customModelTwo, returnedModel, "status");
    }

    @Test
    public void testDeactivateCustomModel() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelNameOne = "testDeactivateModelOne" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        CustomModel customModelOne = this.createCustomModel(modelNameOne, namespacePair, CustomModel.ModelStatus.ACTIVE, null, "Mark Moe");
        HttpResponse response = this.getSingle("cmm", modelNameOne, 200);
        CustomModel returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)CustomModel.ModelStatus.ACTIVE, (Object)returnedModel.getStatus());
        CustomModel updatePayload = new CustomModel();
        updatePayload.setStatus(CustomModel.ModelStatus.DRAFT);
        this.setRequestContext(this.nonAdminUserName);
        this.put("cmm", modelNameOne, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 403);
        this.setRequestContext(this.customModelAdmin);
        this.put("cmm", modelNameOne, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 200);
        response = this.getSingle("cmm", modelNameOne, 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)CustomModel.ModelStatus.DRAFT, (Object)returnedModel.getStatus());
        this.compareCustomModels(customModelOne, returnedModel, "status");
        this.put("cmm", modelNameOne, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 500);
        String modelNameTwo = "testDeactivateModelTwo" + System.currentTimeMillis();
        Pair<String, String> namespacePairTwo = this.getTestNamespaceUriPrefixPair();
        CustomModel customModelTwo = this.createCustomModel(modelNameTwo, namespacePairTwo, CustomModel.ModelStatus.DRAFT, null, "Mark Moe");
        CustomAspect aspect = new CustomAspect();
        aspect.setName("testMarkerAspect");
        this.post("cmm/" + modelNameTwo + "/aspects", RestApiUtil.toJsonAsString(aspect), 201);
        this.getSingle("cmm/" + modelNameTwo + "/aspects", aspect.getName(), 200);
        customModelTwo.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelNameTwo, RestApiUtil.toJsonAsString(customModelTwo), "?select=status", 200);
        response = this.getSingle("cmm", modelNameTwo, 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)CustomModel.ModelStatus.ACTIVE, (Object)returnedModel.getStatus());
        updatePayload = new CustomModel();
        updatePayload.setStatus(CustomModel.ModelStatus.DRAFT);
        this.put("cmm", modelNameTwo, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 200);
        response = this.getSingle("cmm", modelNameTwo, 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)CustomModel.ModelStatus.DRAFT, (Object)returnedModel.getStatus());
    }

    @Test
    public void testDeleteCustomModel() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testDeleteModel" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        CustomModel customModel = this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT, null, "Joe Bloggs");
        HttpResponse response = this.getSingle("cmm", modelName, 200);
        CustomModel returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        this.compareCustomModels(customModel, returnedModel, new String[0]);
        this.setRequestContext(this.nonAdminUserName);
        this.delete("cmm", modelName, 403);
        this.setRequestContext(this.customModelAdmin);
        this.delete("cmm", modelName, 204);
        this.post("cmm", RestApiUtil.toJsonAsString(customModel), 201);
        CustomModel updatePayload = new CustomModel();
        updatePayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 200);
        this.delete("cmm", modelName, 409);
        updatePayload = new CustomModel();
        updatePayload.setStatus(CustomModel.ModelStatus.DRAFT);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 200);
        this.delete("cmm", modelName, 204);
    }

    @Test
    public void testUpdateBasicModel() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModel" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT, "Test model description", null);
        CustomModel updatePayload = new CustomModel();
        String newName = modelName + "Modified";
        updatePayload.setName(newName);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 400);
        updatePayload = new CustomModel();
        updatePayload.setNamespaceUri("http://www.alfresco.org/model/content/1.0");
        updatePayload.setNamespacePrefix("newPrefix");
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 409);
        updatePayload = new CustomModel();
        updatePayload.setNamespaceUri((String)this.getTestNamespaceUriPrefixPair().getFirst());
        updatePayload.setNamespacePrefix("cm");
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 409);
        updatePayload = new CustomModel();
        updatePayload.setNamespaceUri((String)this.getTestNamespaceUriPrefixPair().getFirst());
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 400);
        updatePayload = new CustomModel();
        updatePayload.setNamespacePrefix((String)namespacePair.getSecond());
        Pair<String, String> newURI = this.getTestNamespaceUriPrefixPair();
        updatePayload.setNamespaceUri((String)newURI.getFirst());
        HttpResponse response = this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 200);
        CustomModel returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)newURI.getFirst(), (Object)returnedModel.getNamespaceUri());
        Assert.assertEquals((String)"The namespace prefix shouldn't have changed.", (Object)namespacePair.getSecond(), (Object)returnedModel.getNamespacePrefix());
        updatePayload = new CustomModel();
        updatePayload.setNamespacePrefix("newPrefix");
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 400);
        updatePayload = new CustomModel();
        updatePayload.setNamespaceUri((String)namespacePair.getFirst());
        Pair<String, String> newPrefix = this.getTestNamespaceUriPrefixPair();
        updatePayload.setNamespacePrefix((String)newPrefix.getSecond());
        response = this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)newPrefix.getSecond(), (Object)returnedModel.getNamespacePrefix());
        Assert.assertEquals((String)"The namespace URI shouldn't have changed.", (Object)namespacePair.getFirst(), (Object)returnedModel.getNamespaceUri());
        updatePayload = new CustomModel();
        Pair<String, String> newNamespacePair = this.getTestNamespaceUriPrefixPair();
        updatePayload.setNamespaceUri((String)newNamespacePair.getFirst());
        updatePayload.setNamespacePrefix((String)newNamespacePair.getSecond());
        updatePayload.setDescription("Test model description Modified");
        updatePayload.setAuthor("John Moe");
        updatePayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.setRequestContext(this.nonAdminUserName);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 403);
        this.setRequestContext(this.customModelAdmin);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 200);
        response = this.getSingle("cmm", modelName, 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        this.compareCustomModels(updatePayload, returnedModel, "name", "status");
        Assert.assertEquals((String)"The model status should only be updated via '?select=status' request.", (Object)CustomModel.ModelStatus.DRAFT, (Object)returnedModel.getStatus());
        updatePayload = new CustomModel();
        updatePayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        response = this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), "?select=status", 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)CustomModel.ModelStatus.ACTIVE, (Object)returnedModel.getStatus());
        updatePayload = new CustomModel();
        newNamespacePair = this.getTestNamespaceUriPrefixPair();
        updatePayload.setNamespaceUri((String)newNamespacePair.getFirst());
        updatePayload.setNamespacePrefix(returnedModel.getNamespacePrefix());
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 409);
        updatePayload = new CustomModel();
        updatePayload.setNamespaceUri(returnedModel.getNamespaceUri());
        updatePayload.setNamespacePrefix("myNewPrefix");
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 409);
        updatePayload = new CustomModel();
        updatePayload.setNamespaceUri(returnedModel.getNamespaceUri());
        updatePayload.setNamespacePrefix(returnedModel.getNamespacePrefix());
        updatePayload.setDescription("Test modifying active model description");
        updatePayload.setAuthor("Mark Miller");
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 200);
        response = this.getSingle("cmm", modelName, 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        this.compareCustomModels(updatePayload, returnedModel, "name", "status");
    }

    @Test
    public void testUpdateModel_WithAspectsAndTypes() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModel" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String typeBaseName = "testTypeBase" + System.currentTimeMillis();
        String typeBaseNameWithPrefix = (String)namespacePair.getSecond() + ":" + typeBaseName;
        this.createTypeAspect(CustomType.class, modelName, typeBaseName, "test typeBase title", null, "cm:content");
        String aspectName = "testAspect" + System.currentTimeMillis();
        String aspectNameWithPrefix = (String)namespacePair.getSecond() + ":" + aspectName;
        this.createTypeAspect(CustomAspect.class, modelName, aspectName, null, null, null);
        CustomModel modelOneStatusPayload = new CustomModel();
        modelOneStatusPayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(modelOneStatusPayload), "?select=status", 200);
        String childTypeName = "testTypeChild" + System.currentTimeMillis();
        this.createTypeAspect(CustomType.class, modelName, childTypeName, "test typeChild title", "test typeChild Desc", typeBaseNameWithPrefix);
        String childAspectName = "testChildAspect" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, childAspectName, "test child aspect title", null, aspectNameWithPrefix);
        modelOneStatusPayload = new CustomModel();
        modelOneStatusPayload.setStatus(CustomModel.ModelStatus.DRAFT);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(modelOneStatusPayload), "?select=status", 200);
        CustomModel updatePayload = new CustomModel();
        String modifiedPrefix = (String)namespacePair.getSecond() + "Modified";
        updatePayload.setNamespacePrefix(modifiedPrefix);
        updatePayload.setNamespaceUri((String)namespacePair.getFirst());
        HttpResponse response = this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 200);
        CustomModel returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)modifiedPrefix, (Object)returnedModel.getNamespacePrefix());
        Assert.assertEquals((String)"The namespace URI shouldn't have changed.", (Object)namespacePair.getFirst(), (Object)returnedModel.getNamespaceUri());
        updatePayload = new CustomModel();
        updatePayload.setNamespacePrefix(modifiedPrefix);
        String modifiedURI = (String)namespacePair.getFirst() + "Modified";
        updatePayload.setNamespaceUri(modifiedURI);
        response = this.put("cmm", modelName, RestApiUtil.toJsonAsString(updatePayload), null, 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)modifiedURI, (Object)returnedModel.getNamespaceUri());
        Assert.assertEquals((String)"The namespace prefix shouldn't have changed.", (Object)modifiedPrefix, (Object)returnedModel.getNamespacePrefix());
        response = this.getSingle("cmm/" + modelName + "/types", childTypeName, 200);
        CustomType returnedChildType = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomType.class);
        String newTypeParentName = modifiedPrefix + ":" + typeBaseName;
        Assert.assertEquals((String)"The parent name prefix should have been updated.", (Object)newTypeParentName, (Object)returnedChildType.getParentName());
        response = this.getSingle("cmm/" + modelName + "/aspects", childAspectName, 200);
        CustomAspect returnedChildAspect = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomAspect.class);
        String newAspectParentName = modifiedPrefix + ":" + aspectName;
        Assert.assertEquals((String)"The parent name prefix should have been updated.", (Object)newAspectParentName, (Object)returnedChildAspect.getParentName());
    }

    @Test
    public void testModelsCircularDependency() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelNameOne = "testModelOne" + System.currentTimeMillis();
        Pair<String, String> namespacePairOne = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelNameOne, namespacePairOne, CustomModel.ModelStatus.DRAFT);
        String typeA_M1 = "testTypeA_M1" + System.currentTimeMillis();
        String typeA_M1_WithPrefix = (String)namespacePairOne.getSecond() + ":" + typeA_M1;
        this.createTypeAspect(CustomType.class, modelNameOne, typeA_M1, "test typeA_M1 title", null, "cm:content");
        CustomModel modelOneStatusPayload = new CustomModel();
        modelOneStatusPayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelNameOne, RestApiUtil.toJsonAsString(modelOneStatusPayload), "?select=status", 200);
        String typeB_M1 = "testTypeB_M1" + System.currentTimeMillis();
        String typeB_M1_WithPrefix = (String)namespacePairOne.getSecond() + ":" + typeB_M1;
        this.createTypeAspect(CustomType.class, modelNameOne, typeB_M1, "test typeB_M1 title", "test typeB_M1 Desc", typeA_M1_WithPrefix);
        String modelNameTwo = "testModelTwo" + System.currentTimeMillis();
        Pair<String, String> namespacePairTwo = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelNameTwo, namespacePairTwo, CustomModel.ModelStatus.DRAFT);
        String type1_M2 = "testType1_M2" + System.currentTimeMillis();
        String type1_M2_WithPrefix = (String)namespacePairTwo.getSecond() + ":" + type1_M2;
        this.createTypeAspect(CustomType.class, modelNameTwo, type1_M2, "test type1_M2 title", null, typeB_M1_WithPrefix);
        CustomModel modelTwoStatusPayload = new CustomModel();
        modelTwoStatusPayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelNameTwo, RestApiUtil.toJsonAsString(modelTwoStatusPayload), "?select=status", 200);
        String typeC_M1 = "testTypeC_M1" + System.currentTimeMillis();
        CustomType typeC_M1_Payload = new CustomType();
        typeC_M1_Payload.setName(typeC_M1);
        typeC_M1_Payload.setTitle("test typeC_M1 title");
        typeC_M1_Payload.setParentName(type1_M2_WithPrefix);
        this.post("cmm/" + modelNameOne + "/types", RestApiUtil.toJsonAsString(typeC_M1_Payload), 409);
        String modelNameThree = "testModelThree" + System.currentTimeMillis();
        Pair<String, String> namespacePairThree = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelNameThree, namespacePairThree, CustomModel.ModelStatus.DRAFT);
        String type1_M3 = "testType1_M3" + System.currentTimeMillis();
        String type1_M3_WithPrefix = (String)namespacePairThree.getSecond() + ":" + type1_M3;
        this.createTypeAspect(CustomType.class, modelNameThree, type1_M3, "test type1_M3 title", null, type1_M2_WithPrefix);
        CustomModel modelThreeStatusPayload = new CustomModel();
        modelThreeStatusPayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelNameThree, RestApiUtil.toJsonAsString(modelThreeStatusPayload), "?select=status", 200);
        String typeC_M12 = "testTypeC_M1" + System.currentTimeMillis();
        CustomType typeC_M1_Payload2 = new CustomType();
        typeC_M1_Payload2.setName(typeC_M12);
        typeC_M1_Payload2.setTitle("test typeC_M1 title");
        typeC_M1_Payload2.setParentName(type1_M3_WithPrefix);
        this.post("cmm/" + modelNameOne + "/types", RestApiUtil.toJsonAsString(typeC_M1_Payload2), 409);
        String modelNameFour = "testModelFour" + System.currentTimeMillis();
        Pair<String, String> namespacePairFour = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelNameFour, namespacePairFour, CustomModel.ModelStatus.DRAFT);
        String type1_M4 = "testType1_M4" + System.currentTimeMillis();
        String type1_M4_WithPrefix = (String)namespacePairFour.getSecond() + ":" + type1_M4;
        this.createTypeAspect(CustomType.class, modelNameFour, type1_M4, "test type1_M4 title", null, type1_M3_WithPrefix);
        CustomModel modelFourStatusPayload = new CustomModel();
        modelFourStatusPayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelNameFour, RestApiUtil.toJsonAsString(modelFourStatusPayload), "?select=status", 200);
        String typeC_M13 = "testTypeC_M1" + System.currentTimeMillis();
        CustomType typeC_M1_Payload3 = new CustomType();
        typeC_M1_Payload3.setName(typeC_M13);
        typeC_M1_Payload3.setTitle("test typeC_M1 title");
        typeC_M1_Payload3.setParentName(type1_M4_WithPrefix);
        this.post("cmm/" + modelNameOne + "/types", RestApiUtil.toJsonAsString(typeC_M1_Payload3), 409);
        String type2_M2 = "testType2_M2" + System.currentTimeMillis();
        CustomType type2_M2_Payload = new CustomType();
        type2_M2_Payload.setName(type2_M2);
        type2_M2_Payload.setTitle("test type2_M2 title");
        type2_M2_Payload.setParentName(type1_M4_WithPrefix);
        this.post("cmm/" + modelNameTwo + "/types", RestApiUtil.toJsonAsString(type2_M2_Payload), 409);
    }
}

