/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.site;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.site.AbstractSiteServiceTest;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class SurfConfigTest
extends AbstractSiteServiceTest {
    private SiteService siteService;
    private NodeService nodeService;
    private PermissionService permissionService;
    private FileFolderService fileFolderService;
    private static final long RD = System.currentTimeMillis();
    private static final String USER_ONE = "SiteUserOne" + RD;
    private static final String USER_TWO = "SiteUserTwo" + RD;
    private static final String USER_THREE = "SiteUserThree" + RD;
    private static final String URL_SITES = "/api/sites";
    private static final String URL_MEMBERSHIPS = "/memberships";
    private static final String URL_ADM = "/remoteadm/";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.permissionService = (PermissionService)this.getServer().getApplicationContext().getBean("PermissionService");
        this.fileFolderService = (FileFolderService)this.getServer().getApplicationContext().getBean("FileFolderService");
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        this.createUser(USER_THREE);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.deleteUser(USER_ONE);
        this.deleteUser(USER_TWO);
        this.deleteUser(USER_THREE);
        this.deleteSites();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testSurfConfigPermissions() throws Exception {
        String shortName = UUID.randomUUID().toString();
        JSONObject result = this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        SurfConfigTest.assertEquals((Object)"myPreset", (Object)result.get("sitePreset"));
        SurfConfigTest.assertEquals((Object)shortName, (Object)result.get("shortName"));
        SurfConfigTest.assertEquals((Object)"myTitle", (Object)result.get("title"));
        SurfConfigTest.assertEquals((Object)"myDescription", (Object)result.get("description"));
        SurfConfigTest.assertEquals((Object)SiteVisibility.PUBLIC.toString(), (Object)result.get("visibility"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/remoteadm/CREATE/alfresco/site-data/pages/site/" + shortName + "/dashboard.xml?s=sitestore", new JSONObject().toString(), "application/json"), 200);
        NodeRef surfConfigFolderRef = this.nodeService.getChildByName(this.siteService.getSite(shortName).getNodeRef(), ContentModel.ASSOC_CONTAINS, "surf-config");
        SurfConfigTest.assertEquals((Object)"surf-config", (Object)this.nodeService.getProperty(surfConfigFolderRef, ContentModel.PROP_NAME));
        String owner = (String)((Object)this.nodeService.getProperty(surfConfigFolderRef, ContentModel.PROP_OWNER));
        SurfConfigTest.assertFalse((boolean)USER_ONE.equalsIgnoreCase(owner));
        SurfConfigTest.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)owner);
        SurfConfigTest.assertFalse((String)"Inherit Permissions should be off.", (boolean)this.permissionService.getInheritParentPermissions(surfConfigFolderRef));
        Set permissions = this.permissionService.getAllSetPermissions(surfConfigFolderRef);
        SurfConfigTest.assertEquals((int)1, (int)permissions.size());
        String siteManagerGroup = this.siteService.getSiteRoleGroup(shortName, "SiteManager");
        AccessPermission accessPermission = (AccessPermission)permissions.iterator().next();
        SurfConfigTest.assertEquals((String)siteManagerGroup, (String)accessPermission.getAuthority());
        SurfConfigTest.assertEquals((String)"SiteManager", (String)accessPermission.getPermission());
        SurfConfigTest.assertTrue((accessPermission.getAccessStatus() == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PagingResults pageResults = this.fileFolderService.list(surfConfigFolderRef, true, true, null, null, null, new PagingRequest(Integer.MAX_VALUE));
        List fileInfos = pageResults.getPage();
        SurfConfigTest.assertNotNull((Object)fileInfos);
        SurfConfigTest.assertEquals((int)1, (int)fileInfos.size());
        SurfConfigTest.assertEquals((String)"pages", (String)((FileInfo)fileInfos.get(0)).getName());
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteCollaborator");
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        result = new JSONObject(response.getContentAsString());
        SurfConfigTest.assertEquals((Object)"SiteCollaborator", (Object)result.get("role"));
        SurfConfigTest.assertEquals((Object)USER_TWO, (Object)result.getJSONObject("authority").get("userName"));
        membership.put("role", (Object)"SiteManager");
        person.put("userName", (Object)USER_THREE);
        membership.put("person", (Object)person);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        result = new JSONObject(response.getContentAsString());
        SurfConfigTest.assertEquals((Object)"SiteManager", (Object)result.get("role"));
        SurfConfigTest.assertEquals((Object)USER_THREE, (Object)result.getJSONObject("authority").get("userName"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        try {
            this.fileFolderService.list(surfConfigFolderRef, true, true, null, null, null, new PagingRequest(Integer.MAX_VALUE));
            SurfConfigTest.fail((String)"USER_TWO dose not have the appropriate permissions to perform this operation.");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_THREE);
        pageResults = this.fileFolderService.list(surfConfigFolderRef, true, true, null, null, null, new PagingRequest(Integer.MAX_VALUE));
        fileInfos = pageResults.getPage();
        SurfConfigTest.assertNotNull((Object)fileInfos);
        SurfConfigTest.assertEquals((int)1, (int)fileInfos.size());
        SurfConfigTest.assertEquals((String)"pages", (String)((FileInfo)fileInfos.get(0)).getName());
        membership.put("role", (Object)"SiteContributor");
        person.put("userName", (Object)USER_ONE);
        membership.put("person", (Object)person);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        result = new JSONObject(response.getContentAsString());
        SurfConfigTest.assertEquals((Object)"SiteContributor", (Object)result.get("role"));
        SurfConfigTest.assertEquals((Object)USER_ONE, (Object)result.getJSONObject("authority").get("userName"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        try {
            this.fileFolderService.list(surfConfigFolderRef, true, true, null, null, null, new PagingRequest(Integer.MAX_VALUE));
            SurfConfigTest.fail((String)"USER_ONE is not the owner and he is no longer a site manager, so does not have the appropriate permissions to perform this operation");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        try {
            this.fileFolderService.list(((FileInfo)fileInfos.get(0)).getNodeRef(), true, true, null, null, null, new PagingRequest(Integer.MAX_VALUE));
            SurfConfigTest.fail((String)"USER_ONE is not the owner and he is no longer a site manager, so does not have the appropriate permissions to perform this operation");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }
}

