/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.util.paging;

import java.io.Serializable;
import org.alfresco.repo.web.util.paging.Cursor;
import org.alfresco.repo.web.util.paging.Paging;

public class WindowedCursor
implements Cursor,
Serializable {
    private static final long serialVersionUID = 521131539938276413L;
    private boolean zeroBasedRow;
    private int totalRows;
    private int skipRows;
    private int maxRows;
    private int rowsPerPage;

    WindowedCursor(boolean zeroBasedRow, int totalRows, int skipRows, int maxRows) {
        this.zeroBasedRow = zeroBasedRow;
        this.totalRows = totalRows;
        this.skipRows = skipRows;
        this.maxRows = maxRows;
        this.rowsPerPage = maxRows <= 0 ? totalRows - skipRows : maxRows;
    }

    @Override
    public String getPageType() {
        return Paging.PageType.WINDOW.toString();
    }

    @Override
    public int getPageSize() {
        return this.maxRows;
    }

    @Override
    public int getTotalPages() {
        return -1;
    }

    @Override
    public int getTotalRows() {
        return this.totalRows;
    }

    @Override
    public int getCurrentPage() {
        return this.skipRows;
    }

    @Override
    public int getFirstPage() {
        if (this.totalRows <= 0) {
            return -1;
        }
        return this.zeroBasedRow ? 0 : 1;
    }

    @Override
    public int getLastPage() {
        return -1;
    }

    @Override
    public int getNextPage() {
        return this.skipRows + this.rowsPerPage < this.totalRows ? this.skipRows + this.maxRows : -1;
    }

    @Override
    public int getPrevPage() {
        return this.skipRows > 0 ? Math.max(0, this.skipRows - this.maxRows) : -1;
    }

    @Override
    public boolean isInRange() {
        return this.skipRows >= 0 && this.skipRows < this.totalRows;
    }

    @Override
    public boolean getHasFirstPage() {
        return this.getFirstPage() != -1;
    }

    @Override
    public boolean getHasLastPage() {
        return this.getLastPage() != -1;
    }

    @Override
    public boolean getHasNextPage() {
        return this.getNextPage() != -1;
    }

    @Override
    public boolean getHasPrevPage() {
        return this.getPrevPage() != -1;
    }

    @Override
    public int getStartRow() {
        if (this.totalRows <= 0) {
            return 0;
        }
        return this.skipRows + (this.zeroBasedRow ? 0 : 1);
    }

    @Override
    public int getEndRow() {
        if (this.totalRows <= 0) {
            return -1;
        }
        return this.getStartRow() + Math.min(this.rowsPerPage, this.totalRows - this.skipRows) - 1;
    }

    @Override
    public int getRowCount() {
        if (this.totalRows <= 0) {
            return 0;
        }
        return this.getEndRow() - this.getStartRow() + 1;
    }
}

