/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.UserTransaction;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.webdav.DeleteMethod;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Category(value={LuceneTests.class})
public class DeleteMethodTest {
    private static ApplicationContext ctx;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private DeleteMethod method;
    private UserTransaction txn = null;
    private SearchService searchService;
    private TransactionService transactionService;
    private NodeService nodeService;
    private ContentService contentService;
    private WebDAVHelper webDAVHelper;
    private Repository repositoryHelper;
    private NodeRef companyHomeNodeRef;
    private NodeRef versionableDoc;
    private String versionableDocName;
    private StoreRef storeRef = new StoreRef("workspace", "SpacesStore");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:alfresco/remote-api-context.xml"});
    }

    @Before
    public void setUp() throws Exception {
        this.transactionService = (TransactionService)ctx.getBean("transactionService", TransactionService.class);
        this.searchService = (SearchService)ctx.getBean("SearchService", SearchService.class);
        this.nodeService = (NodeService)ctx.getBean("NodeService", NodeService.class);
        this.contentService = (ContentService)ctx.getBean("contentService", ContentService.class);
        this.webDAVHelper = (WebDAVHelper)ctx.getBean("webDAVHelper", WebDAVHelper.class);
        this.repositoryHelper = (Repository)ctx.getBean("repositoryHelper");
        this.companyHomeNodeRef = this.repositoryHelper.getCompanyHome();
    }

    @After
    public void tearDown() throws Exception {
        this.method = null;
        this.request = null;
        this.response = null;
        if (this.txn.getStatus() == 1) {
            this.txn.rollback();
        } else {
            this.txn.commit();
        }
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.nodeService.deleteNode(this.versionableDoc);
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        HashMap<QName, CallSite> properties = new HashMap<QName, CallSite>();
        String nodeName = "leak-session-doc-" + GUID.generate();
        properties.put(ContentModel.PROP_NAME, (CallSite)((Object)nodeName));
        NodeRef nodeRef = this.nodeService.createNode(this.companyHomeNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)nodeName), ContentModel.TYPE_CONTENT, properties).getChildRef();
        this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true).putContent("WebDAVTestContent");
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.nodeService.deleteNode(nodeRef);
        this.txn.commit();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void testDeleteFileWithVersionableAspect() throws Exception {
        this.createFileWithVersionableAscpect();
        this.method = new DeleteMethod();
        this.request = new MockHttpServletRequest("DELETE", "/alfresco/webdav/" + this.versionableDocName);
        this.response = new MockHttpServletResponse();
        this.request.setServerPort(8080);
        this.request.setServletPath("/webdav");
        this.method.setDetails((HttpServletRequest)this.request, (HttpServletResponse)this.response, this.webDAVHelper, this.companyHomeNodeRef);
        this.method.execute();
        Assert.assertEquals((long)200L, (long)this.response.getStatus());
    }

    private void createFileWithVersionableAscpect() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        HashMap<QName, String> properties = new HashMap<QName, String>();
        this.versionableDocName = "doc-" + GUID.generate();
        properties.put(ContentModel.PROP_NAME, this.versionableDocName);
        this.versionableDoc = this.nodeService.createNode(this.companyHomeNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)this.versionableDocName), ContentModel.TYPE_CONTENT, properties).getChildRef();
        this.contentService.getWriter(this.versionableDoc, ContentModel.PROP_CONTENT, true).putContent("WebDAVTestContent");
        this.nodeService.addAspect(this.versionableDoc, ContentModel.ASPECT_VERSIONABLE, null);
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
    }
}

