/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.forum.CommentService;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.impl.CommentsImpl;
import org.alfresco.rest.api.model.Comment;
import org.alfresco.rest.api.model.Person;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TypeConstraint;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CommentsImplUnitTest {
    private CommentsImpl commentsImpl;
    private Nodes nodes;
    private TypeConstraint typeConstraint;
    private CommentService commentService;
    private NodeService nodeService;
    private ContentService contentService;
    private People people;

    @Before
    public void setUp() {
        this.commentsImpl = new CommentsImpl();
        this.nodes = (Nodes)Mockito.mock(Nodes.class);
        this.typeConstraint = (TypeConstraint)Mockito.mock(TypeConstraint.class);
        this.commentService = (CommentService)Mockito.mock(CommentService.class);
        this.nodeService = (NodeService)Mockito.mock(NodeService.class);
        this.contentService = (ContentService)Mockito.mock(ContentService.class);
        this.people = (People)Mockito.mock(People.class);
        this.commentsImpl.setNodes(this.nodes);
        this.commentsImpl.setTypeConstraint(this.typeConstraint);
        this.commentsImpl.setCommentService(this.commentService);
        this.commentsImpl.setNodeService(this.nodeService);
        this.commentsImpl.setContentService(this.contentService);
        this.commentsImpl.setPeople(this.people);
    }

    @Test
    public void createComment() {
        String nodeId = "node-id";
        Comment comment = new Comment();
        NodeRef nodeRef = new NodeRef("protocol", "identifier", "id");
        NodeRef commentNode = new NodeRef("protocol", "identifier", "comment-id");
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("canEdit", true);
        map.put("canDelete", true);
        HashMap<QName, String> nodeProps = new HashMap<QName, String>();
        nodeProps.put(ContentModel.PROP_CREATOR, "user1");
        nodeProps.put(ContentModel.PROP_MODIFIER, "user2");
        Person person1 = new Person();
        person1.setUserName("user1");
        person1.setEmail("user1@alfresco.com");
        Person person2 = new Person();
        person2.setUserName("user2");
        person2.setEmail("user2@alfresco.com");
        Mockito.when((Object)this.nodes.validateNode(nodeId)).thenReturn((Object)nodeRef);
        Mockito.when((Object)this.typeConstraint.matches(nodeRef)).thenReturn((Object)true);
        Mockito.when((Object)this.commentService.createComment(nodeRef, comment.getTitle(), comment.getContent(), false)).thenReturn((Object)commentNode);
        Mockito.when((Object)this.nodeService.getProperties(commentNode)).thenReturn(nodeProps);
        Mockito.when((Object)this.commentService.getCommentPermissions((NodeRef)ArgumentMatchers.any(NodeRef.class), (NodeRef)ArgumentMatchers.any(NodeRef.class))).thenReturn(map);
        Mockito.when((Object)this.people.getPerson((String)ArgumentMatchers.eq((Object)"user1"), (List)ArgumentMatchers.any(List.class))).thenReturn((Object)person1);
        Mockito.when((Object)this.people.getPerson((String)ArgumentMatchers.eq((Object)"user2"), (List)ArgumentMatchers.any(List.class))).thenReturn((Object)person2);
        Comment resultComment = this.commentsImpl.createComment(nodeId, comment);
        Assert.assertNotNull((Object)resultComment);
        Assert.assertNotNull((Object)resultComment.getCreatedBy());
        Assert.assertEquals((Object)"user1", (Object)resultComment.getCreatedBy().getUserName());
        Assert.assertEquals((Object)"user1@alfresco.com", (Object)resultComment.getCreatedBy().getEmail());
        Assert.assertNotNull((Object)resultComment.getModifiedBy());
        Assert.assertEquals((Object)"user2", (Object)resultComment.getModifiedBy().getUserName());
        Assert.assertEquals((Object)"user2@alfresco.com", (Object)resultComment.getModifiedBy().getEmail());
    }

    @Test
    public void testCreateCommentForDeletedUser() {
        String nodeId = "node-id";
        Comment comment = new Comment();
        NodeRef nodeRef = new NodeRef("protocol", "identifier", "id");
        NodeRef commentNode = new NodeRef("protocol", "identifier", "comment-id");
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("canEdit", true);
        map.put("canDelete", true);
        HashMap<QName, String> nodeProps = new HashMap<QName, String>();
        nodeProps.put(ContentModel.PROP_CREATOR, "user1");
        nodeProps.put(ContentModel.PROP_MODIFIER, "user2");
        Mockito.when((Object)this.nodes.validateNode(nodeId)).thenReturn((Object)nodeRef);
        Mockito.when((Object)this.typeConstraint.matches(nodeRef)).thenReturn((Object)true);
        Mockito.when((Object)this.commentService.createComment(nodeRef, comment.getTitle(), comment.getContent(), false)).thenReturn((Object)commentNode);
        Mockito.when((Object)this.nodeService.getProperties(commentNode)).thenReturn(nodeProps);
        Mockito.when((Object)this.commentService.getCommentPermissions((NodeRef)ArgumentMatchers.any(NodeRef.class), (NodeRef)ArgumentMatchers.any(NodeRef.class))).thenReturn(map);
        Mockito.when((Object)this.people.getPerson((String)ArgumentMatchers.eq((Object)"user1"), (List)ArgumentMatchers.any(List.class))).thenThrow(EntityNotFoundException.class);
        Mockito.when((Object)this.people.getPerson((String)ArgumentMatchers.eq((Object)"user2"), (List)ArgumentMatchers.any(List.class))).thenThrow(EntityNotFoundException.class);
        Comment resultComment = this.commentsImpl.createComment(nodeId, comment);
        Assert.assertNotNull((Object)resultComment);
        Assert.assertNotNull((Object)resultComment.getCreatedBy());
        Assert.assertEquals((Object)"user1", (Object)resultComment.getCreatedBy().getUserName());
        Assert.assertNull((Object)resultComment.getCreatedBy().getEmail());
        Assert.assertNotNull((Object)resultComment.getModifiedBy());
        Assert.assertEquals((Object)"user2", (Object)resultComment.getModifiedBy().getUserName());
        Assert.assertNull((Object)resultComment.getCreatedBy().getEmail());
    }
}

