/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.rest.api.model.Network;
import org.alfresco.rest.api.model.Quota;
import org.alfresco.rest.framework.resource.UniqueId;

public class NetworkImpl
implements Comparable<NetworkImpl>,
Network {
    private String id;
    private Date createdAt;
    private List<Quota> quotas = new LinkedList<Quota>();
    private Boolean isEnabled;
    private String subscriptionLevel;
    private Boolean paidNetwork;

    public NetworkImpl(org.alfresco.repo.tenant.Network network) {
        this.id = network.getTenantDomain();
        this.createdAt = network.getCreatedAt();
        this.isEnabled = network.isEnabled();
        this.paidNetwork = network.getPaidNetwork();
        this.subscriptionLevel = network.getSubscriptionLevel();
    }

    public NetworkImpl(String id, Date createdAt, Boolean isEnabled, String subscriptionLevel, Boolean paidNetwork) {
        this.id = id;
        this.createdAt = createdAt;
        this.isEnabled = isEnabled;
        this.subscriptionLevel = subscriptionLevel;
        this.paidNetwork = paidNetwork;
    }

    @Override
    @UniqueId
    public String getId() {
        return this.id;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public List<Quota> getQuotas() {
        return this.quotas;
    }

    @Override
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    @Override
    public String getSubscriptionLevel() {
        return this.subscriptionLevel;
    }

    @Override
    public Boolean getPaidNetwork() {
        return this.paidNetwork;
    }

    @Override
    public int compareTo(NetworkImpl network) {
        return this.id.compareTo(network.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Network other = (Network)obj;
        return this.id.equals(other.getId());
    }

    public String toString() {
        return "Network [id=" + this.id + ", createdAt=" + String.valueOf(this.createdAt) + ", quotas=" + String.valueOf(this.quotas) + ", isEnabled=" + this.isEnabled + ", subscriptionLevel=" + this.subscriptionLevel + "]";
    }
}

