/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.calendar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.calendar.AbstractCalendarListingWebScript;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.calendar.CalendarEntryDTO;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class UserCalendarEntriesGet
extends AbstractCalendarListingWebScript {
    private PermissionService permissionService;
    private static final long DURATION_SECOND = 1000L;
    private static final long DURATION_MINUTE = 60000L;
    private static final long DURATION_HOUR = 3600000L;
    private static final long DURATION_DAY = 86400000L;
    private static final long DURATION_WEEK = 604800000L;

    @Override
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        SiteInfo site = null;
        String siteName = (String)templateVars.get("site");
        if (siteName != null && (site = this.siteService.getSite(siteName)) == null) {
            status.setCode(404, "Site '" + siteName + "' does not exist or user has no permissions to access it.");
            return null;
        }
        return this.executeImpl(site, null, req, null, status, cache);
    }

    @Override
    protected Map<String, Object> executeImpl(SiteInfo singleSite, String eventName, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        Date fromDate = this.parseDate(req.getParameter("from"));
        Date toDate = this.parseDate(req.getParameter("to"));
        boolean repeatingFirstOnly = true;
        String repeatingEvents = req.getParameter("repeating");
        if (repeatingEvents != null) {
            if ("first".equals(repeatingEvents)) {
                repeatingFirstOnly = true;
            } else if ("all".equals(repeatingEvents)) {
                repeatingFirstOnly = false;
            }
        } else if (fromDate != null) {
            String fromDateS = req.getParameter("from");
            if (fromDateS.indexOf(45) != -1) {
                repeatingFirstOnly = true;
            }
            if (fromDateS.indexOf(47) != -1) {
                repeatingFirstOnly = false;
            }
        }
        List sites = new ArrayList<SiteInfo>();
        if (singleSite != null) {
            sites.add(singleSite);
        } else {
            int max = 0;
            String strMax = req.getParameter("size");
            if (strMax != null && strMax.length() != 0) {
                max = Integer.parseInt(strMax);
            }
            sites = this.siteService.listSites(AuthenticationUtil.getRunAsUser(), max);
        }
        String[] siteShortNames = new String[sites.size()];
        HashMap<NodeRef, SiteInfo> containerLookup = new HashMap<NodeRef, SiteInfo>();
        for (int i = 0; i < sites.size(); ++i) {
            SiteInfo site = (SiteInfo)sites.get(i);
            siteShortNames[i] = site.getShortName();
            try {
                containerLookup.put(this.siteService.getContainer(site.getShortName(), "calendar"), site);
                continue;
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
        }
        PagingRequest paging = this.buildPagingRequest(req);
        PagingResults entries = this.calendarService.listCalendarEntries(siteShortNames, fromDate, toDate, paging);
        boolean resortNeeded = false;
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (CalendarEntry entry : entries.getPage()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            boolean isAllDay = CalendarEntryDTO.isAllDay((CalendarEntry)entry);
            boolean removeTimezone = isAllDay && !entry.isOutlook();
            result.put("event", entry);
            result.put("name", entry.getSystemName());
            result.put("title", entry.getTitle());
            result.put("description", entry.getDescription());
            result.put("where", entry.getLocation());
            result.put("start", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, removeTimezone));
            result.put("end", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, removeTimezone));
            String legacyDateFormat = "yyyy-MM-dd";
            String legacyTimeFormat = "HH:mm";
            result.put("legacyDateFrom", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, removeTimezone, legacyDateFormat));
            result.put("legacyTimeFrom", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, removeTimezone, legacyTimeFormat));
            result.put("legacyDateTo", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, removeTimezone, legacyDateFormat));
            result.put("legacyTimeTo", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, removeTimezone, legacyTimeFormat));
            result.put("duration", this.buildDuration(entry));
            result.put("tags", entry.getTags());
            result.put("isoutlook", entry.isOutlook());
            result.put("allday", CalendarEntryDTO.isAllDay((CalendarEntry)entry));
            SiteInfo site = (SiteInfo)containerLookup.get(entry.getContainerNodeRef());
            result.put("site", site);
            result.put("siteName", site.getShortName());
            result.put("siteTitle", site.getTitle());
            AccessStatus canEdit = this.permissionService.hasPermission(entry.getNodeRef(), "Write");
            AccessStatus canDelete = this.permissionService.hasPermission(entry.getNodeRef(), "Delete");
            result.put("canEdit", canEdit == AccessStatus.ALLOWED);
            result.put("canDelete", canDelete == AccessStatus.ALLOWED);
            for (String key : result.keySet()) {
                if (result.get(key) != null) continue;
                result.put(key, "");
            }
            results.add(result);
            boolean orderChanged = this.handleRecurring(entry, result, results, fromDate, toDate, repeatingFirstOnly);
            if (!orderChanged) continue;
            resortNeeded = true;
        }
        if (resortNeeded) {
            Collections.sort(results, UserCalendarEntriesGet.getEventDetailsSorter());
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("events", results);
        return model;
    }

    private String buildDuration(CalendarEntry entry) {
        int seconds;
        int minutes;
        int days;
        StringBuffer duration = new StringBuffer();
        duration.append("P");
        long timeDiff = entry.getEnd().getTime() - entry.getStart().getTime();
        int weeks = (int)Math.floor(timeDiff / 604800000L);
        if (weeks > 0) {
            duration.append(weeks);
            duration.append("W");
            timeDiff -= (long)weeks * 604800000L;
        }
        if ((days = (int)Math.floor(timeDiff / 86400000L)) > 0) {
            duration.append(days);
            duration.append("D");
            timeDiff -= (long)days * 86400000L;
        }
        duration.append("T");
        int hours = (int)Math.floor(timeDiff / 3600000L);
        if (hours > 0) {
            duration.append(hours);
            duration.append("H");
            timeDiff -= (long)hours * 3600000L;
        }
        if ((minutes = (int)Math.floor(timeDiff / 60000L)) > 0) {
            duration.append(minutes);
            duration.append("M");
            timeDiff -= (long)minutes * 60000L;
        }
        if ((seconds = (int)Math.floor(timeDiff / 1000L)) > 0) {
            duration.append(seconds);
            timeDiff -= (long)minutes * 60000L;
        }
        return duration.toString();
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

