/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import org.alfresco.repo.cache.AsynchronouslyRefreshedCache;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.RepositoryContainer;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Registry;

public class TenantRepositoryContainer
extends RepositoryContainer
implements TenantDeployer {
    protected static final Log logger = LogFactory.getLog(TenantRepositoryContainer.class);
    protected TenantAdminService tenantAdminService;
    protected TransactionService transactionService;
    private AsynchronouslyRefreshedCache<Registry> registryCache;

    public void setWebScriptsRegistryCache(AsynchronouslyRefreshedCache<Registry> registryCache) {
        this.registryCache = registryCache;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    @Override
    public void setTransactionService(TransactionService transactionService) {
        super.setTransactionService(transactionService);
        this.transactionService = transactionService;
    }

    public Registry getRegistry() {
        Registry registry = (Registry)this.registryCache.get();
        boolean isUpToDate = this.registryCache.isUpToDate();
        if (!isUpToDate && logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved out of date web script registry for tenant " + this.tenantAdminService.getCurrentUserDomain()));
        }
        return registry;
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    public void init() {
        this.tenantAdminService.register((TenantDeployer)this);
        this.registryCache.refresh();
        super.reset();
    }

    public void destroy() {
        this.registryCache.refresh();
    }

    @Override
    public void reset() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                TenantRepositoryContainer.this.destroy();
                TenantRepositoryContainer.this.init();
                return null;
            }
        }, true, false);
    }
}

