/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.rest.api.impl.rules.RuleSetLoader;
import org.alfresco.rest.api.model.rules.InclusionType;
import org.alfresco.rest.api.model.rules.RuleSet;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Experimental
public class RuleSetLoaderTest
extends TestCase {
    private static final String FOLDER_ID = "dummy-folder-id";
    private static final String RULE_SET_ID = "dummy-rule-set-id";
    private static final NodeRef FOLDER_NODE = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-folder-id");
    private static final NodeRef RULE_SET_NODE = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-rule-set-id");
    private static final String LINKING_FOLDER_ID = "linking-folder";
    private static final NodeRef LINKING_FOLDER = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "linking-folder");
    private static final NodeRef INHERITING_FOLDER = new NodeRef("inheriting://folder/");
    @InjectMocks
    private RuleSetLoader ruleSetLoader;
    @Mock
    private NodeService nodeServiceMock;
    @Mock
    private RuleService ruleServiceMock;
    @Mock
    private ChildAssociationRef ruleSetAssociationMock;
    @Mock
    private ChildAssociationRef linkAssociationMock;

    @Before
    public void setUp() {
        BDDMockito.given((Object)this.ruleSetAssociationMock.getParentRef()).willReturn((Object)FOLDER_NODE);
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent(RULE_SET_NODE)).willReturn((Object)this.ruleSetAssociationMock);
        BDDMockito.given((Object)this.linkAssociationMock.getParentRef()).willReturn((Object)LINKING_FOLDER);
        BDDMockito.given((Object)this.nodeServiceMock.getParentAssocs(RULE_SET_NODE)).willReturn(List.of(this.ruleSetAssociationMock, this.linkAssociationMock));
        BDDMockito.given((Object)this.ruleServiceMock.getFoldersInheritingRuleSet((NodeRef)ArgumentMatchers.eq((Object)RULE_SET_NODE), ArgumentMatchers.anyInt())).willReturn(List.of(INHERITING_FOLDER));
        BDDMockito.given((Object)this.ruleServiceMock.getFoldersLinkingToRuleSet((NodeRef)ArgumentMatchers.eq((Object)RULE_SET_NODE), ArgumentMatchers.anyInt())).willReturn(List.of(LINKING_FOLDER));
    }

    @Test
    public void testLoadRuleSet_noIncludes() {
        RuleSet actual = this.ruleSetLoader.loadRuleSet(RULE_SET_NODE, FOLDER_NODE, null);
        RuleSet expected = RuleSet.builder().id(RULE_SET_ID).create();
        RuleSetLoaderTest.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testLoadRuleSet_includeOwningFolder() {
        RuleSet actual = this.ruleSetLoader.loadRuleSet(RULE_SET_NODE, FOLDER_NODE, List.of("owningFolder"));
        RuleSet expected = RuleSet.builder().id(RULE_SET_ID).owningFolder(FOLDER_NODE).create();
        RuleSetLoaderTest.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testLoadRuleSet_includeInclusionType() {
        RuleSet actual = this.ruleSetLoader.loadRuleSet(RULE_SET_NODE, FOLDER_NODE, List.of("inclusionType"));
        RuleSet expected = RuleSet.builder().id(RULE_SET_ID).inclusionType(InclusionType.OWNED).create();
        RuleSetLoaderTest.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testLoadRuleSet_linkedInclusionType() {
        RuleSet actual = this.ruleSetLoader.loadRuleSet(RULE_SET_NODE, LINKING_FOLDER, List.of("inclusionType"));
        RuleSet expected = RuleSet.builder().id(RULE_SET_ID).inclusionType(InclusionType.LINKED).create();
        RuleSetLoaderTest.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testLoadRuleSet_inheritedInclusionType() {
        RuleSet actual = this.ruleSetLoader.loadRuleSet(RULE_SET_NODE, INHERITING_FOLDER, List.of("inclusionType"));
        RuleSet expected = RuleSet.builder().id(RULE_SET_ID).inclusionType(InclusionType.INHERITED).create();
        RuleSetLoaderTest.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testLoadRuleSet_inheritedBy() {
        RuleSet actual = this.ruleSetLoader.loadRuleSet(RULE_SET_NODE, INHERITING_FOLDER, List.of("inheritedBy"));
        RuleSet expected = RuleSet.builder().id(RULE_SET_ID).inheritedBy(List.of(INHERITING_FOLDER)).create();
        RuleSetLoaderTest.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testLoadRuleSet_linkedToBy() {
        RuleSet actual = this.ruleSetLoader.loadRuleSet(RULE_SET_NODE, FOLDER_NODE, List.of("linkedToBy"));
        RuleSet expected = RuleSet.builder().id(RULE_SET_ID).linkedToBy(List.of(LINKING_FOLDER)).create();
        RuleSetLoaderTest.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testLoadRuleSet_isInherited() {
        RuleSet actual = this.ruleSetLoader.loadRuleSet(RULE_SET_NODE, FOLDER_NODE, List.of("isInherited"));
        RuleSet expected = RuleSet.builder().id(RULE_SET_ID).isInherited(Boolean.valueOf(true)).create();
        RuleSetLoaderTest.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testLoadRuleSet_isLinkedTo() {
        RuleSet actual = this.ruleSetLoader.loadRuleSet(RULE_SET_NODE, FOLDER_NODE, List.of("isLinkedTo"));
        RuleSet expected = RuleSet.builder().id(RULE_SET_ID).isLinkedTo(Boolean.valueOf(true)).create();
        RuleSetLoaderTest.assertEquals((Object)expected, (Object)actual);
    }
}

