/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.workflow.AbstractWorkflowWebscript;
import org.alfresco.repo.web.scripts.workflow.WorkflowModelBuilder;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class WorkflowInstanceDelete
extends AbstractWorkflowWebscript {
    public static final String PARAM_FORCED = "forced";

    @Override
    protected Map<String, Object> buildModel(WorkflowModelBuilder modelBuilder, WebScriptRequest req, Status status, Cache cache) {
        Map params = req.getServiceMatch().getTemplateVars();
        String workflowInstanceId = (String)params.get("workflow_instance_id");
        boolean forced = this.getForced(req);
        if (this.canUserEndWorkflow(workflowInstanceId)) {
            if (forced) {
                this.workflowService.deleteWorkflow(workflowInstanceId);
            } else {
                this.workflowService.cancelWorkflow(workflowInstanceId);
            }
            return null;
        }
        throw new WebScriptException(403, "Failed to " + (forced ? "delete" : "cancel") + " workflow instance with id: " + workflowInstanceId);
    }

    private boolean getForced(WebScriptRequest req) {
        String forced = req.getParameter(PARAM_FORCED);
        if (forced != null) {
            try {
                return Boolean.valueOf(forced);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean canUserEndWorkflow(String instanceId) {
        boolean canEnd = false;
        WorkflowInstance wi = this.workflowService.getWorkflowById(instanceId);
        if (wi == null) {
            throw new WebScriptException(404, "The workflow instance to delete/cancel with id " + instanceId + " doesn't exist: ");
        }
        String currentUserName = this.authenticationService.getCurrentUserName();
        if (this.authorityService.isAdminAuthority(currentUserName)) {
            canEnd = true;
        } else {
            String ownerName = null;
            NodeRef initiator = wi.getInitiator();
            if (initiator != null && this.nodeService.exists(initiator)) {
                ownerName = (String)((Object)this.nodeService.getProperty(initiator, ContentModel.PROP_USERNAME));
            } else {
                NodeRef initiatorHomeNodeRef;
                WorkflowTask startTask = this.workflowService.getStartTask(wi.getId());
                Map props = startTask.getProperties();
                ownerName = (String)props.get(ContentModel.PROP_OWNER);
                if (ownerName == null && (initiatorHomeNodeRef = (NodeRef)props.get(QName.createQName((String)"", (String)"initiatorhome"))) != null) {
                    ownerName = (String)((Object)this.nodeService.getProperty(initiatorHomeNodeRef, ContentModel.PROP_OWNER));
                }
            }
            if (currentUserName.equals(ownerName)) {
                canEnd = true;
            }
        }
        return canEnd;
    }
}

