/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.web.scripts.workflow.AbstractWorkflowWebscript;
import org.alfresco.repo.web.scripts.workflow.WorkflowModelBuilder;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ModelUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class TaskInstancesGet
extends AbstractWorkflowWebscript {
    private static final Log LOGGER = LogFactory.getLog(TaskInstancesGet.class);
    public static final String PARAM_AUTHORITY = "authority";
    public static final String PARAM_STATE = "state";
    public static final String PARAM_PRIORITY = "priority";
    public static final String PARAM_DUE_BEFORE = "dueBefore";
    public static final String PARAM_DUE_AFTER = "dueAfter";
    public static final String PARAM_PROPERTIES = "properties";
    public static final String PARAM_POOLED_TASKS = "pooledTasks";
    public static final String PARAM_PROPERTY = "property";
    public static final String VAR_WORKFLOW_INSTANCE_ID = "workflow_instance_id";
    private WorkflowTaskDueAscComparator taskComparator = new WorkflowTaskDueAscComparator(this);

    @Override
    protected Map<String, Object> buildModel(WorkflowModelBuilder modelBuilder, WebScriptRequest req, Status status, Cache cache) {
        ArrayList allTasks;
        Map params = req.getServiceMatch().getTemplateVars();
        HashMap<String, Object> filters = new HashMap<String, Object>(4);
        String authority = this.getAuthority(req);
        if (authority == null) {
            authority = this.authenticationService.getCurrentUserName();
        }
        WorkflowTaskState state = this.getState(req);
        String workflowInstanceId = (String)params.get(VAR_WORKFLOW_INSTANCE_ID);
        Boolean pooledTasksOnly = this.getPooledTasks(req);
        List<String> properties = this.getProperties(req);
        filters.put(PARAM_PRIORITY, req.getParameter(PARAM_PRIORITY));
        filters.put(PARAM_PROPERTY, req.getParameter(PARAM_PROPERTY));
        this.processDateFilter(req, PARAM_DUE_BEFORE, filters);
        this.processDateFilter(req, PARAM_DUE_AFTER, filters);
        String excludeParam = req.getParameter("exclude");
        if (excludeParam != null && excludeParam.length() > 0) {
            filters.put("exclude", new AbstractWorkflowWebscript.ExcludeFilter(this, excludeParam));
        }
        if (workflowInstanceId != null) {
            taskQuery = new WorkflowTaskQuery();
            taskQuery.setActive(null);
            taskQuery.setProcessId(workflowInstanceId);
            taskQuery.setTaskState(state);
            taskQuery.setOrderBy(new WorkflowTaskQuery.OrderBy[]{WorkflowTaskQuery.OrderBy.TaskDue_Asc});
            if (authority != null) {
                taskQuery.setActorId(authority);
            }
            allTasks = this.workflowService.queryTasks(taskQuery);
        } else {
            if (state == null) {
                state = WorkflowTaskState.IN_PROGRESS;
            }
            if (authority != null) {
                List tasks = this.workflowService.getAssignedTasks(authority, state, true);
                List pooledTasks = this.workflowService.getPooledTasks(authority, true);
                if (pooledTasksOnly != null) {
                    if (pooledTasksOnly.booleanValue()) {
                        allTasks = new ArrayList(pooledTasks.size());
                        allTasks.addAll(pooledTasks);
                    } else {
                        allTasks = new ArrayList(tasks.size());
                        allTasks.addAll(tasks);
                    }
                } else {
                    allTasks = new ArrayList(tasks.size() + pooledTasks.size());
                    allTasks.addAll(tasks);
                    allTasks.addAll(pooledTasks);
                }
                Collections.sort(allTasks, this.taskComparator);
            } else {
                taskQuery = new WorkflowTaskQuery();
                taskQuery.setTaskState(state);
                taskQuery.setActive(null);
                taskQuery.setOrderBy(new WorkflowTaskQuery.OrderBy[]{WorkflowTaskQuery.OrderBy.TaskDue_Asc});
                allTasks = this.workflowService.queryTasks(taskQuery);
            }
        }
        int maxItems = this.getIntParameter(req, "maxItems", -1);
        int skipCount = this.getIntParameter(req, "skipCount", 0);
        int totalCount = 0;
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (WorkflowTask task : allTasks) {
            if (!this.matches(task, filters) || ++totalCount <= skipCount || maxItems >= 0 && maxItems <= results.size()) continue;
            results.add(modelBuilder.buildSimple(task, properties));
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("taskInstances", results);
        if (maxItems != -1 || skipCount != 0) {
            model.put("paging", ModelUtil.buildPaging((int)totalCount, (int)(maxItems == -1 ? totalCount : maxItems), (int)skipCount));
        }
        return model;
    }

    private List<String> getProperties(WebScriptRequest req) {
        String propertiesStr = req.getParameter(PARAM_PROPERTIES);
        if (propertiesStr != null) {
            return Arrays.asList(propertiesStr.split(","));
        }
        return null;
    }

    private Boolean getPooledTasks(WebScriptRequest req) {
        Boolean result = null;
        String includePooledTasks = req.getParameter(PARAM_POOLED_TASKS);
        if (includePooledTasks != null) {
            result = Boolean.valueOf(includePooledTasks);
        }
        return result;
    }

    private WorkflowTaskState getState(WebScriptRequest req) {
        String stateName = req.getParameter(PARAM_STATE);
        if (stateName != null) {
            try {
                return WorkflowTaskState.valueOf((String)stateName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                String msg = "Unrecognised State parameter: " + stateName;
                throw new WebScriptException(400, msg);
            }
        }
        return null;
    }

    private String getAuthority(WebScriptRequest req) {
        String authority = req.getParameter(PARAM_AUTHORITY);
        if (authority == null || authority.length() == 0) {
            authority = null;
        }
        return authority;
    }

    private boolean matches(WorkflowTask task, Map<String, Object> filters) {
        boolean result = true;
        for (String key : filters.keySet()) {
            Serializable value;
            QName propertyQName;
            Date dueDate;
            Object filterValue = filters.get(key);
            if (filterValue == null) continue;
            if (key.equals("exclude")) {
                AbstractWorkflowWebscript.ExcludeFilter excludeFilter = (AbstractWorkflowWebscript.ExcludeFilter)filterValue;
                String type = task.getDefinition().getMetadata().getName().toPrefixString((NamespacePrefixResolver)this.namespaceService);
                if (!excludeFilter.isMatch(type)) continue;
                result = false;
                break;
            }
            if (key.equals(PARAM_DUE_BEFORE)) {
                dueDate = (Date)task.getProperties().get(WorkflowModel.PROP_DUE_DATE);
                if (this.isDateMatchForFilter(dueDate, filterValue, true)) continue;
                result = false;
                break;
            }
            if (key.equals(PARAM_DUE_AFTER)) {
                dueDate = (Date)task.getProperties().get(WorkflowModel.PROP_DUE_DATE);
                if (this.isDateMatchForFilter(dueDate, filterValue, false)) continue;
                result = false;
                break;
            }
            if (key.equals(PARAM_PRIORITY)) {
                if (filterValue.equals(((Serializable)task.getProperties().get(WorkflowModel.PROP_PRIORITY)).toString())) continue;
                result = false;
                break;
            }
            if (!key.equals(PARAM_PROPERTY)) continue;
            int propQNameEnd = filterValue.toString().indexOf(47);
            if (propQNameEnd < 1) {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Object)("Ignoring invalid property filter:" + filterValue.toString()));
                break;
            }
            String propValue = filterValue.toString().substring(propQNameEnd + 1);
            if (propValue.isEmpty()) {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Object)("Ignoring empty property value filter [" + propValue + "]"));
                break;
            }
            String propQNameStr = filterValue.toString().substring(0, propQNameEnd);
            try {
                propertyQName = QName.createQName((String)propQNameStr, (NamespacePrefixResolver)this.namespaceService);
            }
            catch (Exception ex) {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Object)("Ignoring invalid QName property filter [" + propQNameStr + "]"));
                break;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Filtering with property [" + propertyQName.toPrefixString((NamespacePrefixResolver)this.namespaceService) + "=" + propValue + "]"));
            }
            if ((value = (Serializable)task.getProperties().get(propertyQName)) == null || value.equals(propValue)) continue;
            result = false;
            break;
        }
        return result;
    }

    class WorkflowTaskDueAscComparator
    implements Comparator<WorkflowTask> {
        WorkflowTaskDueAscComparator(TaskInstancesGet this$0) {
        }

        @Override
        public int compare(WorkflowTask o1, WorkflowTask o2) {
            Date date2;
            long time2;
            Date date1 = (Date)o1.getProperties().get(WorkflowModel.PROP_DUE_DATE);
            long time1 = date1 == null ? Long.MAX_VALUE : date1.getTime();
            long result = time1 - (time2 = (date2 = (Date)o2.getProperties().get(WorkflowModel.PROP_DUE_DATE)) == null ? Long.MAX_VALUE : date2.getTime());
            return result > 0L ? 1 : (result < 0L ? -1 : 0);
        }
    }
}

