/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.util.JettyComponent;
import org.alfresco.rest.api.tests.PersonInfo;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.TestFixture;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.junit.Assert;
import org.springframework.context.ApplicationContext;

public abstract class AbstractTestFixture
implements TestFixture {
    public static final int DEFAULT_NUM_MEMBERS_PER_SITE = 4;
    public static final String TEST_DOMAIN_PREFIX = "acme";
    protected List<PersonInfo> people = new ArrayList<PersonInfo>(10);
    protected TreeMap<String, RepoService.TestNetwork> networks = new TreeMap();
    protected TreeMap<String, RepoService.SiteInformation> sites = new TreeMap();
    private String[] configLocations;
    private final String[] classLocations;
    private int port = 8765;
    private String contextPath = "/alfresco";
    private String servletName = "api";
    protected JettyComponent jetty;
    protected boolean cleanup;
    protected Random random = new Random();
    protected RepoService repoService;
    protected RetryingTransactionHelper transactionHelper;
    protected int numMembersPerSite;
    protected ApplicationContext applicationContext;

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected AbstractTestFixture(String[] configLocations, String[] classLocations, int port, String contextPath, String servletName, int numMembersPerSite, boolean cleanup) {
        this.configLocations = configLocations;
        this.classLocations = classLocations;
        this.port = port;
        this.contextPath = contextPath;
        this.servletName = servletName;
        this.numMembersPerSite = numMembersPerSite;
        this.cleanup = cleanup;
    }

    @Override
    public JettyComponent getJettyComponent() {
        return this.jetty;
    }

    public int getPort() {
        return this.port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String[] getConfigLocations() {
        return this.configLocations;
    }

    public String[] getClassLocations() {
        return this.classLocations;
    }

    protected abstract JettyComponent makeJettyComponent();

    protected abstract void populateTestData();

    protected abstract RepoService makeRepoService() throws Exception;

    public void setup() throws Exception {
        this.setup(true);
    }

    public void setup(boolean createTestData) throws Exception {
        this.jetty = this.makeJettyComponent();
        this.jetty.start();
        this.applicationContext = this.jetty.getApplicationContext();
        this.repoService = this.makeRepoService();
        this.transactionHelper = (RetryingTransactionHelper)this.repoService.getApplicationContext().getBean("retryingTransactionHelper");
        if (createTestData) {
            this.populateTestData();
            this.createTestData();
        }
    }

    @Override
    public RepoService getRepoService() {
        return this.repoService;
    }

    @Override
    public RepoService.TestNetwork getNetwork(String name) {
        return this.networks.get(name);
    }

    @Override
    public Iterator<RepoService.TestNetwork> getNetworksIt() {
        return this.networks.values().iterator();
    }

    public TreeMap<String, RepoService.TestNetwork> getNetworks() {
        return this.networks;
    }

    @Override
    public Iterator<RepoService.TestNetwork> networksIterator() {
        return this.networks.values().iterator();
    }

    @Override
    public RepoService.TestNetwork getRandomNetwork() {
        if (this.networks.isEmpty()) {
            this.populateTestData();
            this.createTestData();
        }
        int r = this.random.nextInt(this.networks.size());
        ArrayList<RepoService.TestNetwork> a = new ArrayList<RepoService.TestNetwork>();
        a.addAll(this.networks.values());
        return (RepoService.TestNetwork)a.get(r);
    }

    protected void addNetwork(RepoService.TestNetwork network) {
        this.networks.put(network.getId(), network);
    }

    public void addPerson(PersonInfo personInfo) {
        this.people.add(personInfo);
    }

    public void addSite(RepoService.SiteInformation siteInfo) {
        this.sites.put(siteInfo.getShortName(), siteInfo);
    }

    public TreeMap<String, RepoService.SiteInformation> getSites() {
        return this.sites;
    }

    public void createTestData() {
        for (final RepoService.TestNetwork testAccount : this.getNetworks().values()) {
            this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                    testAccount.create();
                    for (PersonInfo testPerson : AbstractTestFixture.this.people) {
                        testAccount.createUser(testPerson);
                    }
                    return null;
                }
            }, false, true);
            this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    AuthenticationUtil.clearCurrentSecurityContext();
                    if (testAccount.getPersonIds().size() > 0) {
                        List<String> people = testAccount.peopleSample(testAccount.getPersonIds().size());
                        String tenantDomain = testAccount.getId();
                        int i = 0;
                        for (final RepoService.SiteInformation site : AbstractTestFixture.this.getSites().values()) {
                            final Iterator<String> peopleIterator = RepoService.getWrappingIterator(i++, people);
                            String siteCreator = peopleIterator.next();
                            Assert.assertNotNull((Object)siteCreator);
                            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                                public Void doWork() throws Exception {
                                    RepoService.TestSite testSite = testAccount.createSite(site);
                                    for (int j = 0; j < AbstractTestFixture.this.numMembersPerSite; ++j) {
                                        String siteMember = (String)peopleIterator.next();
                                        Assert.assertNotNull((Object)siteMember);
                                        testSite.inviteToSite(siteMember, SiteRole.SiteContributor);
                                    }
                                    return null;
                                }
                            }, (String)siteCreator, (String)tenantDomain);
                        }
                    }
                    return null;
                }
            }, false, true);
        }
    }

    public void shutdown() {
        if (this.cleanup) {
            this.repoService.shutdown();
        }
        this.jetty.shutdown();
    }
}

