/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search;

import junit.framework.TestCase;
import org.alfresco.rest.api.search.impl.StoreMapper;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.junit.Assert;
import org.junit.Test;

public class StoreMapperTests {
    static StoreMapper storeMapper = new StoreMapper();

    @Test(expected=InvalidArgumentException.class)
    public void testGetStoreErrors() throws Exception {
        storeMapper.getStoreRef(null);
    }

    @Test(expected=InvalidArgumentException.class)
    public void testGetStoreWithEmpty() throws Exception {
        storeMapper.getStoreRef("");
    }

    @Test(expected=InvalidArgumentException.class)
    public void testInvalidStoreName() throws Exception {
        storeMapper.getStoreRef("bob");
    }

    @Test
    public void testGetStoreRef() throws Exception {
        TestCase.assertEquals((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, (Object)storeMapper.getStoreRef("nodes"));
        TestCase.assertEquals((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, (Object)storeMapper.getStoreRef("Nodes"));
        TestCase.assertEquals((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, (Object)storeMapper.getStoreRef("NODES"));
        TestCase.assertEquals((Object)StoreMapper.STORE_REF_VERSION2_SPACESSTORE, (Object)storeMapper.getStoreRef("Versions"));
        TestCase.assertEquals((Object)StoreMapper.STORE_REF_VERSION2_SPACESSTORE, (Object)storeMapper.getStoreRef("versions"));
        TestCase.assertEquals((Object)StoreMapper.STORE_REF_VERSION2_SPACESSTORE, (Object)storeMapper.getStoreRef("VERSIONS"));
        TestCase.assertEquals((Object)StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, (Object)storeMapper.getStoreRef("Deleted-nodes"));
        TestCase.assertEquals((Object)StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, (Object)storeMapper.getStoreRef("deleted-nodes"));
        TestCase.assertEquals((Object)StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, (Object)storeMapper.getStoreRef("DELETED-NODES"));
    }

    @Test
    public void testGetStore() throws Exception {
        TestCase.assertEquals((String)"nodes", (String)storeMapper.getStore(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "not interested")));
        TestCase.assertEquals((String)"versions", (String)storeMapper.getStore(new NodeRef(StoreMapper.STORE_REF_VERSION2_SPACESSTORE, "not interested")));
        TestCase.assertEquals((String)"deleted-nodes", (String)storeMapper.getStore(new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, "not interested")));
        Assert.assertNull((Object)storeMapper.getStore(null));
    }
}

