/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.core;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.alfresco.rest.framework.resource.content.ContentInfo;
import org.alfresco.rest.framework.resource.content.ContentInfoImpl;
import org.alfresco.rest.framework.tools.ApiAssistant;
import org.alfresco.rest.framework.tools.ResponseWriter;
import org.alfresco.rest.framework.webscripts.ResourceWebScriptDelete;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class WithResponseTest {
    @Test
    public void testDefaults() throws Exception {
        WithResponse callBack = new WithResponse(200, ResponseWriter.DEFAULT_JSON_CONTENT, ResponseWriter.CACHE_NEVER);
        Assert.assertEquals((long)200L, (long)callBack.getStatus());
        Assert.assertEquals((Object)ResponseWriter.DEFAULT_JSON_CONTENT, (Object)callBack.getContentInfo());
        Assert.assertEquals((Object)ResponseWriter.CACHE_NEVER, (Object)callBack.getCache());
        Assert.assertTrue((boolean)callBack.getHeaders().isEmpty());
    }

    @Test
    public void testSetHeader() throws Exception {
        WithResponse callBack = new WithResponse(200, ResponseWriter.DEFAULT_JSON_CONTENT, ResponseWriter.CACHE_NEVER);
        callBack.setHeader("king", "can");
        callBack.setHeader("king", "kong");
        Assert.assertTrue((callBack.getHeaders().size() == 1 ? 1 : 0) != 0);
        List vals = (List)callBack.getHeaders().get("king");
        Assert.assertTrue((vals.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"kong", vals.get(0));
    }

    @Test
    public void testAddHeader() throws Exception {
        WithResponse callBack = new WithResponse(200, ResponseWriter.DEFAULT_JSON_CONTENT, ResponseWriter.CACHE_NEVER);
        callBack.addHeader("king", "can");
        callBack.addHeader("king", "kong");
        Assert.assertTrue((callBack.getHeaders().size() == 1 ? 1 : 0) != 0);
        List vals = (List)callBack.getHeaders().get("king");
        Assert.assertTrue((vals.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)vals, Arrays.asList("can", "kong"));
    }

    @Test
    public void testSetters() throws Exception {
        WithResponse callBack = new WithResponse(200, ResponseWriter.DEFAULT_JSON_CONTENT, ResponseWriter.CACHE_NEVER);
        callBack.setStatus(410);
        Cache myCache = new Cache(new Description.RequiredCache(this){

            public boolean getNeverCache() {
                return false;
            }

            public boolean getIsPublic() {
                return true;
            }

            public boolean getMustRevalidate() {
                return true;
            }
        });
        callBack.setCache(myCache);
        ContentInfoImpl myContent = new ContentInfoImpl(Format.HTML.mimetype(), "UTF-16", 12L, Locale.FRENCH);
        callBack.setContentInfo((ContentInfo)myContent);
        Assert.assertEquals((long)410L, (long)callBack.getStatus());
        Assert.assertEquals((Object)myCache, (Object)callBack.getCache());
        Assert.assertEquals((Object)myContent, (Object)callBack.getContentInfo());
    }

    @Test
    public void testSetResponse() throws Exception {
        ResourceWebScriptDelete responseWriter = new ResourceWebScriptDelete();
        responseWriter.setAssistant(new ApiAssistant());
        WithResponse wr = new WithResponse(200, ResponseWriter.DEFAULT_JSON_CONTENT, ResponseWriter.CACHE_NEVER);
        WebScriptResponse response = (WebScriptResponse)Mockito.mock(WebScriptResponse.class);
        responseWriter.setResponse(response, wr.getStatus(), wr.getCache(), wr.getContentInfo(), wr.getHeaders());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setStatus(ArgumentMatchers.anyInt());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setCache((Cache)ArgumentMatchers.any());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setContentType(ArgumentMatchers.anyString());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).setHeader(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        response = (WebScriptResponse)Mockito.mock(WebScriptResponse.class);
        responseWriter.setResponse(response, wr.getStatus(), null, null, null);
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setStatus(ArgumentMatchers.anyInt());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).setCache((Cache)ArgumentMatchers.any());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).setContentType(ArgumentMatchers.anyString());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).setHeader(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        response = (WebScriptResponse)Mockito.mock(WebScriptResponse.class);
        wr.addHeader("king", "can");
        wr.addHeader("king", "kong");
        responseWriter.setResponse(response, wr.getStatus(), null, null, wr.getHeaders());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setStatus(ArgumentMatchers.anyInt());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).setCache((Cache)ArgumentMatchers.any());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).setContentType(ArgumentMatchers.anyString());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setHeader((String)ArgumentMatchers.eq((Object)"king"), ArgumentMatchers.anyString());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).addHeader((String)ArgumentMatchers.eq((Object)"king"), ArgumentMatchers.anyString());
        response = (WebScriptResponse)Mockito.mock(WebScriptResponse.class);
        wr.addHeader("king", "kin");
        wr.setHeader("ping", "ping");
        responseWriter.setResponse(response, wr.getStatus(), null, null, wr.getHeaders());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setStatus(ArgumentMatchers.anyInt());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).setCache((Cache)ArgumentMatchers.any());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).setContentType(ArgumentMatchers.anyString());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setHeader((String)ArgumentMatchers.eq((Object)"king"), ArgumentMatchers.anyString());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setHeader((String)ArgumentMatchers.eq((Object)"ping"), ArgumentMatchers.anyString());
        ((WebScriptResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)2))).addHeader((String)ArgumentMatchers.eq((Object)"king"), ArgumentMatchers.anyString());
    }
}

