/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.WebScriptException;

public abstract class DictionaryWebServiceBase
extends DeclarativeWebScript {
    private static final String NAME_DELIMITER = "_";
    protected static final String MODEL_PROP_KEY_MESSAGE_LOOKUP = "messages";
    protected NamespaceService namespaceService;
    protected DictionaryService dictionaryservice;
    private static final String CLASS_FILTER_OPTION_TYPE1 = "all";
    private static final String CLASS_FILTER_OPTION_TYPE2 = "aspect";
    private static final String CLASS_FILTER_OPTION_TYPE3 = "type";
    private static final String ASSOCIATION_FILTER_OPTION_TYPE1 = "all";
    private static final String ASSOCIATION_FILTER_OPTION_TYPE2 = "general";
    private static final String ASSOCIATION_FILTER_OPTION_TYPE3 = "child";

    public void setNamespaceService(NamespaceService namespaceservice) {
        this.namespaceService = namespaceservice;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryservice = dictionaryService;
    }

    protected QName createClassQName(String className) {
        QName result = null;
        int index = className.indexOf(NAME_DELIMITER);
        if (index > 0) {
            QName classQName;
            String prefix = className.substring(0, index);
            String shortName = className.substring(index + 1);
            String url = this.namespaceService.getNamespaceURI(prefix);
            if (url != null && url.length() != 0 && shortName != null && shortName.length() != 0 && this.dictionaryservice.getClass(classQName = QName.createQName((String)url, (String)shortName)) != null) {
                result = classQName;
            }
        }
        return result;
    }

    protected QName createClassQName(String prefix, String shortName) {
        QName classQName;
        QName result = null;
        String url = this.namespaceService.getNamespaceURI(prefix);
        if (url != null && url.length() != 0 && shortName != null && shortName.length() != 0 && this.dictionaryservice.getClass(classQName = QName.createQName((String)url, (String)shortName)) != null) {
            result = classQName;
        }
        return result;
    }

    public String getNamespaceURIfromQname(QName qname) {
        return qname.getNamespaceURI();
    }

    public String getFullNamespaceURI(String classname) {
        try {
            String result = null;
            String prefix = this.getPrefix(classname);
            String url = this.namespaceService.getNamespaceURI(prefix);
            String name = this.getShortName(classname);
            result = "{" + url + "}" + name;
            return result;
        }
        catch (Exception e) {
            throw new WebScriptException(404, "The exact classname - " + classname + "  parameter has not been provided in the URL");
        }
    }

    public String getFullNamespaceURI(String prefix, String shorname) {
        try {
            String result = null;
            String url = this.namespaceService.getNamespaceURI(prefix);
            result = "{" + url + "}" + shorname;
            return result;
        }
        catch (Exception e) {
            throw new WebScriptException(404, "The exact classname - " + prefix + ":" + shorname + "  parameter has not been provided in the URL");
        }
    }

    public boolean isValidClassname(String classname) {
        QName qname = null;
        try {
            qname = QName.createQName((String)this.getFullNamespaceURI(classname));
            return this.dictionaryservice.getClass(qname) != null;
        }
        catch (InvalidQNameException invalidQNameException) {
            return false;
        }
    }

    public boolean isValidClassname(String prefix, String shorname) {
        QName qname = null;
        try {
            qname = QName.createQName((String)this.getFullNamespaceURI(prefix, shorname));
            return this.dictionaryservice.getClass(qname) != null;
        }
        catch (InvalidQNameException invalidQNameException) {
            return false;
        }
    }

    public String getPrefixFromModelName(String modelname) {
        String namespaceprefix = null;
        for (QName qnameObj : this.dictionaryservice.getAllModels()) {
            if (!qnameObj.getLocalName().equals(modelname)) continue;
            Collection prefixes = this.namespaceService.getPrefixes(qnameObj.getNamespaceURI());
            if (prefixes.isEmpty()) break;
            namespaceprefix = (String)prefixes.iterator().next();
            break;
        }
        return namespaceprefix;
    }

    public boolean isValidAssociationFilter(String af) {
        return af.equalsIgnoreCase("all") || af.equalsIgnoreCase(ASSOCIATION_FILTER_OPTION_TYPE2) || af.equalsIgnoreCase(ASSOCIATION_FILTER_OPTION_TYPE3);
    }

    public boolean isValidTypeorAspect(String classname) {
        try {
            QName qname = QName.createQName((String)this.getFullNamespaceURI(classname));
            return this.dictionaryservice.getClass(qname) != null && this.dictionaryservice.getClass(qname).isAspect();
        }
        catch (InvalidQNameException invalidQNameException) {
            return false;
        }
    }

    public boolean isValidTypeorAspect(String prefix, String shorname) {
        try {
            QName qname = QName.createQName((String)this.getFullNamespaceURI(prefix, shorname));
            return this.dictionaryservice.getClass(qname) != null && this.dictionaryservice.getClass(qname).isAspect();
        }
        catch (InvalidQNameException invalidQNameException) {
            return false;
        }
    }

    public boolean isValidModelName(String modelname) {
        boolean value = false;
        for (QName qnameObj : this.dictionaryservice.getAllModels()) {
            if (!qnameObj.getLocalName().equalsIgnoreCase(modelname)) continue;
            value = true;
            break;
        }
        return value;
    }

    public String getPrefix(String classname) {
        String prefix = null;
        int index = classname.indexOf(NAME_DELIMITER);
        if (index > 0) {
            prefix = classname.substring(0, index);
        }
        return prefix;
    }

    public String getShortName(String classname) {
        String shortname = null;
        int index = classname.indexOf(NAME_DELIMITER);
        if (index > 0) {
            shortname = classname.substring(index + 1);
        }
        return shortname;
    }

    public String getValidInput(String input) {
        if (input != null && input.length() != 0) {
            return input;
        }
        return null;
    }

    public boolean isValidClassFilter(String classfilter) {
        return classfilter.equals("all") || classfilter.equals(CLASS_FILTER_OPTION_TYPE2) || classfilter.equals(CLASS_FILTER_OPTION_TYPE3);
    }

    protected <T> Collection<T> reorderedValues(List<ClassDefinition> sortedClassDefs, Map<QName, T> dependent) {
        ArrayList<T> result = new ArrayList<T>(sortedClassDefs.size());
        for (ClassDefinition classDef : sortedClassDefs) {
            result.add(dependent.get(classDef.getName()));
        }
        return result;
    }
}

