/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.Timer;
import java.util.TimerTask;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.webdav.ActivityPostProducer;
import org.alfresco.repo.webdav.WebDAVActivityPoster;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.webdav.WebDavService;
import org.alfresco.util.FileFilterMode;

public class DeleteMethod
extends WebDAVMethod
implements ActivityPostProducer {
    private WebDAVActivityPoster activityPoster;
    @Deprecated
    private static final Timer deleteDelayTimer = new Timer();

    @Override
    protected void parseRequestHeaders() throws WebDAVServerException {
        this.parseIfHeader();
    }

    @Override
    protected void parseRequestBody() throws WebDAVServerException {
    }

    @Override
    protected void executeImpl() throws WebDAVServerException, Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WebDAV DELETE: " + this.getPath()));
        }
        final FileFolderService fileFolderService = this.getFileFolderService();
        PermissionService permissionService = this.getPermissionService();
        NodeRef rootNodeRef = this.getRootNodeRef();
        String path = this.getPath();
        FileInfo fileInfo = null;
        try {
            fileInfo = this.getNodeForPath(rootNodeRef, path);
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Node not found: " + this.getPath()));
            }
            throw new WebDAVServerException(404);
        }
        this.checkNode(fileInfo);
        final NodeService nodeService = this.getNodeService();
        final NodeRef nodeRef = fileInfo.getNodeRef();
        if (permissionService.hasPermission(nodeRef, "Delete") == AccessStatus.ALLOWED) {
            String siteId = this.getSiteId();
            NodeRef deletedNodeRef = fileInfo.getNodeRef();
            FileInfo parentFile = this.getDAVHelper().getParentNodeForPath(this.getRootNodeRef(), path);
            if (!this.getDAVHelper().isRenameShuffle(path)) {
                this.postActivity(parentFile, fileInfo, siteId);
            }
            if (nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY) || nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                fileFolderService.setHidden(nodeRef, true);
                final String deleteDelayUser = AuthenticationUtil.getFullyAuthenticatedUser();
                TimerTask deleteDelayTask = new TimerTask(this){

                    @Override
                    public void run() {
                        AuthenticationUtil.RunAsWork<Void> deleteDelayRunAs = new AuthenticationUtil.RunAsWork<Void>(){

                            public Void doWork() throws Exception {
                                if (!nodeService.exists(nodeRef) || !fileFolderService.isHidden(nodeRef)) {
                                    return null;
                                }
                                FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.webdav);
                                fileFolderService.setHidden(nodeRef, false);
                                fileFolderService.delete(nodeRef);
                                return null;
                            }
                        };
                        try {
                            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)deleteDelayRunAs, (String)deleteDelayUser);
                        }
                        catch (Throwable e) {
                            WebDAVMethod.logger.info((Object)"Exception thrown during WebDAV delete timer task.", e);
                        }
                    }
                };
                deleteDelayTimer.schedule(deleteDelayTask, 5000L);
                if (this.getDAVLockService().getLockInfo(nodeRef).isLocked()) {
                    this.getDAVLockService().unlock(nodeRef);
                }
            } else if (fileFolderService.isHidden(nodeRef)) {
                this.getDAVLockService().unlock(nodeRef);
            } else {
                fileFolderService.delete(deletedNodeRef);
            }
        } else {
            throw new WebDAVServerException(403);
        }
    }

    protected void postActivity(FileInfo parent, FileInfo deletedFile, String siteId) throws WebDAVServerException {
        WebDavService davService = this.getDAVHelper().getServiceRegistry().getWebDavService();
        if (!davService.activitiesEnabled()) {
            return;
        }
        String tenantDomain = this.getTenantDomain();
        if (!siteId.equals("")) {
            String parentPath;
            block4: {
                SiteService siteService = this.getServiceRegistry().getSiteService();
                NodeRef documentLibrary = siteService.getContainer(siteId, "documentLibrary");
                parentPath = "/";
                try {
                    parentPath = this.getDAVHelper().getPathFromNode(documentLibrary, parent.getNodeRef());
                }
                catch (FileNotFoundException error) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"No documentLibrary container found.");
                }
            }
            this.activityPoster.postFileFolderDeleted(siteId, tenantDomain, parentPath, parent, deletedFile);
        }
    }

    @Override
    public void setActivityPoster(WebDAVActivityPoster activityPoster) {
        this.activityPoster = activityPoster;
    }
}

