/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowObjectFactory;
import org.alfresco.repo.workflow.WorkflowQNameConverter;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.content.FileBinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.ProcessDefinitions;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.rest.workflow.api.impl.WorkflowRestImpl;
import org.alfresco.rest.workflow.api.model.FormModelElement;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.io.IOUtils;

public class ProcessDefinitionsImpl
extends WorkflowRestImpl
implements ProcessDefinitions {
    private static final Set<String> PROCESS_DEFINITION_COLLECTION_EQUALS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("category", "key", "name", "deploymentId", "version"));
    private static final Set<String> PROCESS_DEFINITION_COLLECTION_MATCHES_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("category", "key", "name"));
    private static final Set<String> PROCESS_DEFINITION_COLLECTION_SORT_PROPERTIES = new HashSet<String>(Arrays.asList("deploymentId", "key", "category", "id", "version", "name"));
    MessageService messageService;
    String engineId;
    WorkflowQNameConverter qNameConverter;
    QName defaultStartTaskType = WorkflowModel.TYPE_ACTIVTI_START_TASK;
    WorkflowObjectFactory workflowFactory;

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    @Override
    public CollectionWithPagingInfo<org.alfresco.rest.workflow.api.model.ProcessDefinition> getProcessDefinitions(Parameters parameters) {
        ProcessDefinitionQuery query = this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionCategoryNotEquals("http://alfresco.org/workflows/internal");
        MapBasedQueryWalker propertyWalker = new MapBasedQueryWalker(PROCESS_DEFINITION_COLLECTION_EQUALS_QUERY_PROPERTIES, PROCESS_DEFINITION_COLLECTION_MATCHES_QUERY_PROPERTIES);
        boolean keyQueryIncluded = false;
        if (parameters.getQuery() != null) {
            String nameLikeProperty;
            String keyMatchesProperty;
            String categoryMatchesProperty;
            String deploymentProperty;
            Integer versionProperty;
            String nameProperty;
            String keyProperty;
            QueryHelper.walk(parameters.getQuery(), propertyWalker);
            String categoryProperty = propertyWalker.getProperty("category", 8);
            if (categoryProperty != null) {
                query.processDefinitionCategory(categoryProperty);
            }
            if ((keyProperty = propertyWalker.getProperty("key", 8)) != null) {
                query.processDefinitionKey(this.getProcessDefinitionKey(keyProperty));
                keyQueryIncluded = true;
            }
            if ((nameProperty = propertyWalker.getProperty("name", 8)) != null) {
                query.processDefinitionName(nameProperty);
            }
            if ((versionProperty = propertyWalker.getProperty("version", 8, Integer.class)) != null) {
                query.processDefinitionVersion(versionProperty);
            }
            if ((deploymentProperty = propertyWalker.getProperty("deploymentId", 8)) != null) {
                query.deploymentId(deploymentProperty);
            }
            if ((categoryMatchesProperty = propertyWalker.getProperty("category", 20)) != null) {
                query.processDefinitionCategoryLike(categoryMatchesProperty);
            }
            if ((keyMatchesProperty = propertyWalker.getProperty("key", 20)) != null) {
                query.processDefinitionKeyLike(this.getProcessDefinitionKey(keyMatchesProperty));
                keyQueryIncluded = true;
            }
            if ((nameLikeProperty = propertyWalker.getProperty("name", 20)) != null) {
                query.processDefinitionNameLike(nameLikeProperty);
            }
        }
        if (!keyQueryIncluded && this.tenantService.isEnabled() && this.deployWorkflowsInTenant) {
            query.processDefinitionKeyLike("@" + TenantUtil.getCurrentDomain() + "@%");
        }
        List<SortColumn> sortList = parameters.getSorting();
        SortColumn sortColumn = null;
        if (sortList != null && sortList.size() > 0) {
            if (sortList.size() != 1) {
                throw new InvalidArgumentException("Only one orderBy parameter is supported");
            }
            sortColumn = sortList.get(0);
            switch (sortColumn.column) {
                case "id": {
                    query.orderByProcessDefinitionId();
                    break;
                }
                case "deploymentId": {
                    query.orderByDeploymentId();
                    break;
                }
                case "key": {
                    query.orderByProcessDefinitionKey();
                    break;
                }
                case "category": {
                    query.orderByProcessDefinitionCategory();
                    break;
                }
                case "version": {
                    query.orderByProcessDefinitionVersion();
                    break;
                }
                case "name": {
                    query.orderByProcessDefinitionName();
                    break;
                }
                default: {
                    throw new InvalidArgumentException("OrderBy " + sortColumn.column + " is not supported, supported items are " + String.valueOf(PROCESS_DEFINITION_COLLECTION_SORT_PROPERTIES));
                }
            }
            if (sortColumn.asc) {
                query.asc();
            } else {
                query.desc();
            }
        } else {
            query.orderByProcessDefinitionId().asc();
        }
        List processDefinitions = query.listPage(parameters.getPaging().getSkipCount(), parameters.getPaging().getMaxItems());
        int totalCount = (int)query.count();
        ArrayList<org.alfresco.rest.workflow.api.model.ProcessDefinition> page = new ArrayList<org.alfresco.rest.workflow.api.model.ProcessDefinition>(processDefinitions.size());
        for (ProcessDefinition processDefinition : processDefinitions) {
            page.add(this.createProcessDefinitionRest((ProcessDefinitionEntity)processDefinition));
        }
        return CollectionWithPagingInfo.asPaged(parameters.getPaging(), page, page.size() + parameters.getPaging().getSkipCount() < totalCount, totalCount);
    }

    @Override
    public org.alfresco.rest.workflow.api.model.ProcessDefinition getProcessDefinition(String definitionId) {
        ProcessDefinition processDefinition;
        ProcessDefinitionQuery query = this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(definitionId);
        if (this.tenantService.isEnabled() && this.deployWorkflowsInTenant) {
            query.processDefinitionKeyLike("@" + TenantUtil.getCurrentDomain() + "@%");
        }
        if ((processDefinition = (ProcessDefinition)query.singleResult()) == null) {
            throw new EntityNotFoundException(definitionId);
        }
        org.alfresco.rest.workflow.api.model.ProcessDefinition deploymentRest = this.createProcessDefinitionRest((ProcessDefinitionEntity)processDefinition);
        return deploymentRest;
    }

    @Override
    public BinaryResource getProcessDefinitionImage(String definitionId) {
        ProcessDefinition processDefinition;
        ProcessDefinitionQuery query = this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(definitionId);
        if (this.tenantService.isEnabled() && this.deployWorkflowsInTenant) {
            query.processDefinitionKeyLike("@" + TenantUtil.getCurrentDomain() + "@%");
        }
        if ((processDefinition = (ProcessDefinition)query.singleResult()) == null) {
            throw new EntityNotFoundException(definitionId);
        }
        try {
            InputStream processDiagram = this.activitiProcessEngine.getRepositoryService().getProcessDiagram(definitionId);
            if (processDiagram != null) {
                File file = TempFileProvider.createTempFile((String)(definitionId + String.valueOf(UUID.randomUUID())), (String)".png");
                FileOutputStream fos = new FileOutputStream(file);
                IOUtils.copy((InputStream)processDiagram, (OutputStream)fos);
                fos.close();
                return new FileBinaryResource(file);
            }
            throw new ApiException("No image available for definitionId " + definitionId);
        }
        catch (IOException error) {
            throw new ApiException("Error while getting process definition image.");
        }
    }

    @Override
    public CollectionWithPagingInfo<FormModelElement> getStartFormModel(String definitionId, Paging paging) {
        StartFormData startFormData;
        if (this.tenantService.isEnabled() && this.deployWorkflowsInTenant) {
            ProcessDefinitionQuery query = this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(definitionId);
            query.processDefinitionKeyLike("@" + TenantUtil.getCurrentDomain() + "@%");
            ProcessDefinition processDefinition = (ProcessDefinition)query.singleResult();
            if (processDefinition == null) {
                throw new EntityNotFoundException(definitionId);
            }
        }
        if ((startFormData = this.activitiProcessEngine.getFormService().getStartFormData(definitionId)) == null) {
            throw new EntityNotFoundException(definitionId);
        }
        if (this.qNameConverter == null) {
            this.qNameConverter = new WorkflowQNameConverter((NamespacePrefixResolver)this.namespaceService);
        }
        if (this.workflowFactory == null) {
            this.workflowFactory = new WorkflowObjectFactory(this.qNameConverter, this.tenantService, this.messageService, this.dictionaryService, this.engineId, this.defaultStartTaskType);
        }
        TypeDefinition startTaskType = this.workflowFactory.getTaskFullTypeDefinition(startFormData.getFormKey(), true);
        return this.getFormModelElements(startTaskType, paging);
    }

    protected String getProcessDefinitionKey(String key) {
        Object processDefKey = null;
        processDefKey = this.tenantService.isEnabled() && this.deployWorkflowsInTenant ? "@" + TenantUtil.getCurrentDomain() + "@" + key : key;
        return processDefKey;
    }

    protected String getLocalProcessDefinitionKey(String key) {
        String processDefKey = null;
        processDefKey = this.tenantService.isEnabled() && this.deployWorkflowsInTenant ? key.substring(key.lastIndexOf("@") + 1) : key;
        return processDefKey;
    }

    protected org.alfresco.rest.workflow.api.model.ProcessDefinition createProcessDefinitionRest(ProcessDefinitionEntity processDefinition) {
        org.alfresco.rest.workflow.api.model.ProcessDefinition processDefinitionRest = new org.alfresco.rest.workflow.api.model.ProcessDefinition((ProcessDefinition)processDefinition);
        String localKey = this.getLocalProcessDefinitionKey(processDefinition.getKey());
        processDefinitionRest.setKey(localKey);
        String displayId = localKey + ".workflow";
        processDefinitionRest.setTitle(this.getLabel(displayId, "title"));
        processDefinitionRest.setDescription(this.getLabel(displayId, "description"));
        processDefinitionRest.setGraphicNotationDefined(processDefinition.isGraphicalNotationDefined());
        if (processDefinition.hasStartFormKey()) {
            try {
                StartFormData startFormData = this.activitiProcessEngine.getFormService().getStartFormData(processDefinition.getId());
                if (startFormData != null) {
                    processDefinitionRest.setStartFormResourceKey(startFormData.getFormKey());
                }
            }
            catch (Exception e) {
                throw new ApiException("Error while retrieving start form key");
            }
        }
        return processDefinitionRest;
    }

    protected String getLabel(String displayId, String labelKey) {
        String keyBase = displayId.replace(":", "_");
        String key = keyBase + "." + labelKey;
        String label = this.messageService.getMessage(key);
        return label;
    }
}

