/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.discussion;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.discussion.AbstractDiscussionWebScript;
import org.alfresco.service.cmr.discussion.PostInfo;
import org.alfresco.service.cmr.discussion.TopicInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ForumPostRepliesPost
extends AbstractDiscussionWebScript {
    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef nodeRef, TopicInfo topic, PostInfo post, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        if (post == null) {
            post = this.discussionService.getPrimaryPost(topic);
            if (post == null) {
                throw new WebScriptException(412, "First (primary) post was missing from the topic, can't fetch");
            }
        } else if (topic == null) {
            String error = "Node was of the wrong type, only Topic and Post are supported";
            throw new WebScriptException(400, error);
        }
        PostInfo reply = this.doCreatePost(post, topic, req, json);
        this.addActivityEntry("reply", "created", topic, reply, site, req, json);
        Map<String, Object> model = this.buildCommonModel(site, topic, reply, req);
        model.put("postData", this.renderPost(reply, site));
        return model;
    }

    private PostInfo doCreatePost(PostInfo post, TopicInfo topic, WebScriptRequest req, JSONObject json) {
        String title = null;
        if (json.containsKey((Object)"title")) {
            title = (String)json.get((Object)"title");
        }
        String contents = null;
        if (json.containsKey((Object)"content")) {
            contents = (String)json.get((Object)"content");
        }
        PostInfo reply = this.discussionService.createReply(post, contents);
        if (title != null && title.length() > 0) {
            this.nodeService.setProperty(reply.getNodeRef(), ContentModel.PROP_TITLE, (Serializable)((Object)title));
            reply = this.discussionService.getPost(topic, reply.getSystemName());
        }
        return reply;
    }
}

