/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.lookups;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.rest.api.lookups.PropertyLookup;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.service.ServiceRegistry;

public class PersonPropertyLookup
implements PropertyLookup<String> {
    private Set<String> supported = new HashSet<String>();
    private ServiceRegistry serviceRegistry;

    @Override
    public String lookup(String propertyValue) {
        Map mapUserInfo = TransactionalResourceHelper.getMap((Object)"PERSON_PROPERTY_LOOKUP_USER_INFO_CACHE");
        UserInfo user = Node.lookupUserInfo(propertyValue, mapUserInfo, this.serviceRegistry.getPersonService());
        if (user != null) {
            return user.getDisplayName();
        }
        return null;
    }

    @Override
    public Set<String> supports() {
        return this.supported;
    }

    public void setSupported(Set<String> supported) {
        this.supported = supported;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }
}

