/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.search.SearchTrackingComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class AclsGet
extends DeclarativeWebScript {
    protected static final Log logger = LogFactory.getLog(AclsGet.class);
    private SearchTrackingComponent searchTrackingComponent;

    public void setSearchTrackingComponent(SearchTrackingComponent searchTrackingComponent) {
        this.searchTrackingComponent = searchTrackingComponent;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        try {
            Map<String, Object> model = this.buildModel(req);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Result: \n\tRequest: " + String.valueOf(req) + "\n\tModel: " + String.valueOf(model)));
            }
            return model;
        }
        catch (IOException e) {
            throw new WebScriptException("IO exception parsing request", (Throwable)e);
        }
        catch (JSONException e) {
            throw new WebScriptException("Invalid JSON", (Throwable)e);
        }
    }

    private Map<String, Object> buildModel(WebScriptRequest req) throws JSONException, IOException {
        JSONArray aclChangeSetIdsJSON;
        ArrayList<Long> aclChangeSetIds = null;
        Content content = req.getContent();
        if (content == null) {
            throw new WebScriptException("Request content is empty");
        }
        JSONObject o = new JSONObject(content.getContent());
        JSONArray jSONArray = aclChangeSetIdsJSON = o.has("aclChangeSetIds") ? o.getJSONArray("aclChangeSetIds") : null;
        if (aclChangeSetIdsJSON == null) {
            throw new WebScriptException(400, "Parameter 'aclChangeSetIds' not provided in request content.");
        }
        if (aclChangeSetIdsJSON.length() == 0) {
            throw new WebScriptException(400, "Parameter 'aclChangeSetIds' must hold from 1 or more IDs.");
        }
        aclChangeSetIds = new ArrayList<Long>(aclChangeSetIdsJSON.length());
        for (int i = 0; i < aclChangeSetIdsJSON.length(); ++i) {
            aclChangeSetIds.add(aclChangeSetIdsJSON.getLong(i));
        }
        String fromIdParam = req.getParameter("fromId");
        String maxResultsParam = req.getParameter("maxResults");
        Long fromId = fromIdParam == null ? null : Long.valueOf(fromIdParam);
        int maxResults = maxResultsParam == null ? 1024 : Integer.valueOf(maxResultsParam);
        List acls = this.searchTrackingComponent.getAcls(aclChangeSetIds, fromId, maxResults);
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        model.put("acls", acls);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result: \n\tRequest: " + String.valueOf(req) + "\n\tModel: " + String.valueOf(model)));
        }
        return model;
    }
}

