/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.MBeanServerConnection;
import org.alfresco.repo.management.JmxDumpUtil;
import org.alfresco.repo.web.scripts.content.StreamContent;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.FileCopyUtils;

public class StreamJMXDump
extends StreamContent {
    private static Log logger = LogFactory.getLog(StreamJMXDump.class);
    private MBeanServerConnection mbeanServer;

    public void setMBeanServer(MBeanServerConnection mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    @Override
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        PrintWriter tempFileOut = null;
        ZipOutputStream zout = null;
        try {
            res.setContentType("application/zip");
            Cache cache = new Cache();
            cache.setNeverCache(true);
            cache.setMustRevalidate(true);
            cache.setMaxAge(Long.valueOf(0L));
            res.setCache(cache);
            Date date = new Date();
            String attachFileName = "jmxdump_" + (date.getYear() + 1900) + "_" + (date.getMonth() + 1) + "_" + date.getDate();
            String headerValue = "attachment; filename=\"" + attachFileName + ".zip\"";
            res.setHeader("Content-Disposition", headerValue);
            File tempFile = TempFileProvider.createTempFile((String)"jmxdump", (String)".txt");
            tempFileOut = new PrintWriter(tempFile);
            JmxDumpUtil.dumpConnection((MBeanServerConnection)this.mbeanServer, (PrintWriter)tempFileOut);
            tempFileOut.flush();
            tempFileOut.close();
            tempFileOut = null;
            zout = new ZipOutputStream(res.getOutputStream());
            ZipEntry zipEntry = new ZipEntry(attachFileName + ".txt");
            zout.putNextEntry(zipEntry);
            FileCopyUtils.copy((InputStream)new FileInputStream(tempFile), (OutputStream)zout);
            zout = null;
        }
        catch (IOException ioe) {
            throw new WebScriptException(400, "Could not output JMX dump: " + ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            if (tempFileOut != null) {
                tempFileOut.close();
            }
            try {
                if (zout != null) {
                    zout.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

