/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpMethodParams;

public class MultiPartBuilder {
    private FileData fileData;
    private String relativePath;
    private String updateNodeRef;
    private String description;
    private String contentTypeQNameStr;
    private String versioningEnabled;
    private List<String> aspects = Collections.emptyList();
    private Boolean majorVersion;
    private Boolean overwrite;
    private Boolean autoRename;
    private String nodeType;
    private List<String> renditionIds = Collections.emptyList();
    private Map<String, String> properties = Collections.emptyMap();

    private MultiPartBuilder() {
    }

    private MultiPartBuilder(MultiPartBuilder that) {
        this.fileData = that.fileData;
        this.relativePath = that.relativePath;
        this.updateNodeRef = that.updateNodeRef;
        this.description = that.description;
        this.contentTypeQNameStr = that.contentTypeQNameStr;
        this.versioningEnabled = that.versioningEnabled;
        this.aspects = new ArrayList<String>(that.aspects);
        this.majorVersion = that.majorVersion;
        this.overwrite = that.overwrite;
        this.autoRename = that.autoRename;
        this.nodeType = that.nodeType;
        this.renditionIds = that.renditionIds;
        this.properties = new HashMap<String, String>(that.properties);
    }

    public static MultiPartBuilder create() {
        return new MultiPartBuilder();
    }

    public static MultiPartBuilder copy(MultiPartBuilder copy) {
        return new MultiPartBuilder(copy);
    }

    public MultiPartBuilder setFileData(FileData fileData) {
        this.fileData = fileData;
        return this;
    }

    public MultiPartBuilder setRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    public MultiPartBuilder setUpdateNoderef(String updateNodeRef) {
        this.updateNodeRef = updateNodeRef;
        return this;
    }

    public MultiPartBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public MultiPartBuilder setContentTypeQNameStr(String contentTypeQNameStr) {
        this.contentTypeQNameStr = contentTypeQNameStr;
        return this;
    }

    public MultiPartBuilder setVersioningEnabled(String versioningEnabled) {
        this.versioningEnabled = versioningEnabled;
        return this;
    }

    public MultiPartBuilder setAspects(List<String> aspects) {
        this.aspects = aspects;
        return this;
    }

    public MultiPartBuilder setMajorVersion(boolean majorVersion) {
        this.majorVersion = majorVersion;
        return this;
    }

    public MultiPartBuilder setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public MultiPartBuilder setAutoRename(boolean autoRename) {
        this.autoRename = autoRename;
        return this;
    }

    public MultiPartBuilder setNodeType(String nodeType) {
        this.nodeType = nodeType;
        return this;
    }

    public MultiPartBuilder setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public MultiPartBuilder setRenditions(List<String> renditionIds) {
        this.renditionIds = renditionIds;
        return this;
    }

    private String getCommaSeparated(List<String> names) {
        if (!names.isEmpty()) {
            StringBuilder sb = new StringBuilder(names.size() * 2);
            for (String str : names) {
                sb.append(str).append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }

    public MultiPartRequest build() throws IOException {
        ArrayList<Part> parts = new ArrayList<Part>();
        if (this.fileData != null) {
            FilePart fp = new FilePart("filedata", this.fileData.getFileName(), this.fileData.getFile(), this.fileData.getMimetype(), null);
            fp.setCharSet(this.fileData.getEncoding());
            fp.setContentType(this.fileData.getMimetype());
            parts.add((Part)fp);
            this.addPartIfNotNull(parts, "name", this.fileData.getFileName());
        }
        this.addPartIfNotNull(parts, "relativepath", this.relativePath);
        this.addPartIfNotNull(parts, "updatenoderef", this.updateNodeRef);
        this.addPartIfNotNull(parts, "description", this.description);
        this.addPartIfNotNull(parts, "contenttype", this.contentTypeQNameStr);
        this.addPartIfNotNull(parts, "versioningenabled", this.versioningEnabled);
        this.addPartIfNotNull(parts, "aspects", this.getCommaSeparated(this.aspects));
        this.addPartIfNotNull(parts, "majorversion", this.majorVersion);
        this.addPartIfNotNull(parts, "overwrite", this.overwrite);
        this.addPartIfNotNull(parts, "autorename", this.autoRename);
        this.addPartIfNotNull(parts, "nodetype", this.nodeType);
        this.addPartIfNotNull(parts, "renditions", this.getCommaSeparated(this.renditionIds));
        HttpMethodParams params = new HttpMethodParams();
        if (!this.properties.isEmpty()) {
            for (String propertyName : this.properties.keySet()) {
                Serializable expected = (Serializable)((Object)this.properties.get(propertyName));
                if (expected instanceof List) {
                    List multipleValues = (List)((Object)expected);
                    for (String value : multipleValues) {
                        parts.add((Part)new StringPart(propertyName, value));
                    }
                    continue;
                }
                parts.add((Part)new StringPart(propertyName, (String)((Object)expected)));
            }
        }
        MultipartRequestEntity req = new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), new HttpMethodParams());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        req.writeRequest((OutputStream)os);
        return new MultiPartRequest(os.toByteArray(), req.getContentType(), req.getContentLength());
    }

    private void addPartIfNotNull(List<Part> list, String partName, Object partValue) {
        if (partValue != null) {
            list.add((Part)new StringPart(partName, partValue.toString()));
        }
    }

    public static class FileData {
        private final String fileName;
        private final File file;
        private final String mimetype;
        private final String encoding;

        public FileData(String fileName, File file) {
            this(fileName, file, null, null);
        }

        public FileData(String fileName, File file, String mimetype) {
            this(fileName, file, mimetype, null);
        }

        public FileData(String fileName, File file, String mimetype, String encoding) {
            this.fileName = fileName;
            this.file = file;
            this.mimetype = mimetype;
            this.encoding = encoding;
        }

        public String getFileName() {
            return this.fileName;
        }

        public File getFile() {
            return this.file;
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }

    public static class MultiPartRequest {
        private final byte[] body;
        private final String contentType;
        private final long contentLength;

        public MultiPartRequest(byte[] body, String contentType, long contentLength) {
            this.body = body;
            this.contentType = contentType;
            this.contentLength = contentLength;
        }

        public byte[] getBody() {
            return this.body;
        }

        public String getContentType() {
            return this.contentType;
        }

        public long getContentLength() {
            return this.contentLength;
        }
    }
}

