/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.collections.CollectionUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class FacetRestApiTest
extends BaseWebScriptTest {
    private static final String SEARCH_ADMIN_USER = "searchAdmin";
    private static final String NON_SEARCH_ADMIN_USER = "nonSearchAdmin";
    private static final String FACETS = "facets";
    private static final String GET_ALL_FACETABLE_PROPERTIES_URL = "/api/facet/facetable-properties";
    private static final String GET_SPECIFIC_FACETABLE_PROPERTIES_URL = "/api/facet/classes/{classname}/facetable-properties";
    private static final String GET_FACETS_URL = "/api/facet/facet-config";
    private static final String PUT_FACET_URL_FORMAT = "/api/facet/facet-config/{0}?relativePos={1}";
    private static final String POST_FACETS_URL = "/api/facet/facet-config";
    private static final String PUT_FACETS_URL = "/api/facet/facet-config";
    private MutableAuthenticationService authenticationService;
    private AuthorityService authorityService;
    private PersonService personService;
    private RetryingTransactionHelper transactionHelper;
    private List<String> filters = new ArrayList<String>();

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService", MutableAuthenticationService.class);
        this.authorityService = (AuthorityService)this.getServer().getApplicationContext().getBean("AuthorityService", AuthorityService.class);
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService", PersonService.class);
        this.transactionHelper = (RetryingTransactionHelper)this.getServer().getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        AuthenticationUtil.clearCurrentSecurityContext();
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FacetRestApiTest.this.createUser(FacetRestApiTest.SEARCH_ADMIN_USER);
                FacetRestApiTest.this.createUser(FacetRestApiTest.NON_SEARCH_ADMIN_USER);
                if (!FacetRestApiTest.this.authorityService.getContainingAuthorities(AuthorityType.GROUP, FacetRestApiTest.SEARCH_ADMIN_USER, true).contains("GROUP_ALFRESCO_SEARCH_ADMINISTRATORS")) {
                    FacetRestApiTest.this.authorityService.addAuthority("GROUP_ALFRESCO_SEARCH_ADMINISTRATORS", FacetRestApiTest.SEARCH_ADMIN_USER);
                }
                return null;
            }
        });
    }

    public void tearDown() throws Exception {
        super.tearDown();
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FacetRestApiTest.this.deleteFilters();
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FacetRestApiTest.this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        FacetRestApiTest.this.deleteUser(FacetRestApiTest.SEARCH_ADMIN_USER);
                        FacetRestApiTest.this.deleteUser(FacetRestApiTest.NON_SEARCH_ADMIN_USER);
                        return null;
                    }
                });
                return null;
            }
        });
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testNonSearchAdminUserCannotCreateUpdateSolrFacets() throws Exception {
        final JSONObject filter = new JSONObject();
        final String filterName = "filter" + System.currentTimeMillis();
        this.filters.add(filterName);
        filter.put("filterID", (Object)filterName);
        filter.put("facetQName", (Object)"cm:test1");
        filter.put("displayName", (Object)"facet-menu.facet.test1");
        filter.put("displayControl", (Object)"alfresco/search/FacetFilters/test1");
        filter.put("maxFilters", 5);
        filter.put("hitThreshold", 1);
        filter.put("minFilterValueLength", 4);
        filter.put("sortBy", (Object)"ALPHABETICALLY");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/facet/facet-config", filter.toString(), "application/json"), 403);
                return null;
            }
        }, (String)NON_SEARCH_ADMIN_USER);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/facet/facet-config", filter.toString(), "application/json"), 200);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestWebScriptServer.Response response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config/" + filterName), 200);
                JSONObject jsonRsp = new JSONObject(new JSONTokener(response.getContentAsString()));
                TestCase.assertEquals((String)filterName, (String)jsonRsp.getString("filterID"));
                TestCase.assertEquals((int)5, (int)jsonRsp.getInt("maxFilters"));
                jsonRsp.put("maxFilters", 10);
                FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/facet/facet-config", jsonRsp.toString(), "application/json"), 403);
                return null;
            }
        }, (String)NON_SEARCH_ADMIN_USER);
    }

    public void testNonSearchAdminUserCanGetFacets() throws Exception {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestWebScriptServer.Response response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config"), 200);
                JSONObject jsonRsp = new JSONObject(new JSONTokener(response.getContentAsString()));
                List<String> filters = FacetRestApiTest.this.getListFromJsonArray(jsonRsp.getJSONArray(FacetRestApiTest.FACETS));
                TestCase.assertTrue((filters.size() > 0 ? 1 : 0) != 0);
                return null;
            }
        }, (String)NON_SEARCH_ADMIN_USER);
    }

    public void testSearchAdminCanGetFacets() throws Exception {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestWebScriptServer.Response rsp = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config"), 200);
                String contentAsString = rsp.getContentAsString();
                JSONObject jsonRsp = new JSONObject(new JSONTokener(contentAsString));
                JSONArray facetsArray = (JSONArray)jsonRsp.get(FacetRestApiTest.FACETS);
                TestCase.assertNotNull((String)"JSON 'facets' array was null", (Object)facetsArray);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
    }

    public void testSearchAdminReordersFacets() throws Exception {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestWebScriptServer.Response rsp = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config"), 200);
                JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
                JSONArray facetsArray = (JSONArray)jsonRsp.get(FacetRestApiTest.FACETS);
                TestCase.assertNotNull((String)"JSON 'facets' array was null", (Object)facetsArray);
                System.out.println("Received " + facetsArray.length() + " facets");
                List<String> idsIndexes = FacetRestApiTest.this.getListFromJsonArray(facetsArray);
                System.out.println(" IDs, indexes = " + String.valueOf(idsIndexes));
                TestCase.assertTrue((String)"There should be more than 1 built-in facet", (facetsArray.length() > 1 ? 1 : 0) != 0);
                String lastIndexId = idsIndexes.get(idsIndexes.size() - 1);
                String url = FacetRestApiTest.PUT_FACET_URL_FORMAT.replace("{0}", lastIndexId).replace("{1}", "-1");
                rsp = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(url, "", "application/json"), 200);
                rsp = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config"), 200);
                jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
                JSONArray newfacetsArray = (JSONArray)jsonRsp.get(FacetRestApiTest.FACETS);
                TestCase.assertNotNull((String)"JSON 'facets' array was null", (Object)newfacetsArray);
                System.out.println("Received " + newfacetsArray.length() + " facets");
                List<String> newIdsIndexes = FacetRestApiTest.this.getListFromJsonArray(newfacetsArray);
                System.out.println(" IDs, indexes = " + String.valueOf(newIdsIndexes));
                TestCase.assertEquals((Object)CollectionUtils.moveLeft((int)1, (Object)lastIndexId, idsIndexes), newIdsIndexes);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
    }

    public void testDefaultValues() throws Exception {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                JSONObject filter_one = new JSONObject();
                String filterNameOne = "filterOne" + System.currentTimeMillis();
                FacetRestApiTest.this.filters.add(filterNameOne);
                filter_one.put("filterID", (Object)filterNameOne);
                filter_one.put("facetQName", (Object)"cm:test1");
                filter_one.put("displayName", (Object)"facet-menu.facet.test1");
                filter_one.put("displayControl", (Object)"alfresco/search/FacetFilters/test1");
                filter_one.put("maxFilters", 5);
                filter_one.put("hitThreshold", 1);
                filter_one.put("minFilterValueLength", 4);
                filter_one.put("sortBy", (Object)"ALPHABETICALLY");
                TestWebScriptServer.Response response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/facet/facet-config", filter_one.toString(), "application/json"), 200);
                response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config/" + filterNameOne), 200);
                JSONObject jsonRsp = new JSONObject(new JSONTokener(response.getContentAsString()));
                TestCase.assertEquals((String)filterNameOne, (String)jsonRsp.getString("filterID"));
                TestCase.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}test1", (String)jsonRsp.getString("facetQName"));
                TestCase.assertEquals((String)"facet-menu.facet.test1", (String)jsonRsp.getString("displayName"));
                TestCase.assertEquals((String)"alfresco/search/FacetFilters/test1", (String)jsonRsp.getString("displayControl"));
                TestCase.assertEquals((int)5, (int)jsonRsp.getInt("maxFilters"));
                TestCase.assertEquals((int)1, (int)jsonRsp.getInt("hitThreshold"));
                TestCase.assertEquals((int)4, (int)jsonRsp.getInt("minFilterValueLength"));
                TestCase.assertEquals((String)"ALPHABETICALLY", (String)jsonRsp.getString("sortBy"));
                TestCase.assertEquals((String)"ALL", (String)jsonRsp.getString("scope"));
                TestCase.assertFalse((boolean)jsonRsp.getBoolean("isEnabled"));
                TestCase.assertFalse((boolean)jsonRsp.getBoolean("isDefault"));
                JSONObject filter_two = new JSONObject();
                String filterNameTwo = "filterTwo" + System.currentTimeMillis();
                FacetRestApiTest.this.filters.add(filterNameTwo);
                filter_two.put("filterID", (Object)filterNameTwo);
                filter_two.put("facetQName", (Object)"cm:test2");
                filter_two.put("displayName", (Object)"facet-menu.facet.test2");
                filter_two.put("displayControl", (Object)"alfresco/search/FacetFilters/test2");
                filter_two.put("maxFilters", 5);
                filter_two.put("hitThreshold", 1);
                filter_two.put("minFilterValueLength", 4);
                filter_two.put("sortBy", (Object)"ALPHABETICALLY");
                filter_two.put("scope", (Object)"SCOPED_SITES");
                List<String> expectedValues = Arrays.asList("sit1", "site2", "site3");
                filter_two.put("scopedSites", expectedValues);
                filter_two.put("isEnabled", true);
                response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/facet/facet-config", filter_two.toString(), "application/json"), 200);
                response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config/" + filterNameTwo), 200);
                jsonRsp = new JSONObject(new JSONTokener(response.getContentAsString()));
                TestCase.assertEquals((String)filterNameTwo, (String)jsonRsp.getString("filterID"));
                TestCase.assertEquals((String)"SCOPED_SITES", (String)jsonRsp.getString("scope"));
                TestCase.assertTrue((boolean)jsonRsp.getBoolean("isEnabled"));
                JSONArray jsonArray = jsonRsp.getJSONArray("scopedSites");
                List<String> retrievedValues = FacetRestApiTest.this.getListFromJsonArray(jsonArray);
                Collections.sort(retrievedValues);
                TestCase.assertEquals(expectedValues, retrievedValues);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
    }

    public void testFacetCustomProperties() throws Exception {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                JSONObject filter = new JSONObject();
                String filterName = "filter" + System.currentTimeMillis();
                FacetRestApiTest.this.filters.add(filterName);
                filter.put("filterID", (Object)filterName);
                filter.put("facetQName", (Object)"cm:content.size.test");
                filter.put("displayName", (Object)"facet-menu.facet.size.test");
                filter.put("displayControl", (Object)"alfresco/search/FacetFilters/test");
                filter.put("maxFilters", 5);
                filter.put("hitThreshold", 1);
                filter.put("minFilterValueLength", 4);
                filter.put("sortBy", (Object)"ALPHABETICALLY");
                JSONObject customProp = new JSONObject();
                JSONObject blockIncludeRequest = new JSONObject();
                blockIncludeRequest.put("name", (Object)"blockIncludeFacetRequest");
                blockIncludeRequest.put("value", (Object)"true");
                customProp.put("blockIncludeFacetRequest", (Object)blockIncludeRequest);
                JSONObject multipleValue = new JSONObject();
                multipleValue.put("name", (Object)"multipleValueTest");
                List<String> expectedValues = Arrays.asList("sit1", "site2", "site3");
                multipleValue.put("value", expectedValues);
                customProp.put("multipleValueTest", (Object)multipleValue);
                filter.put("customProperties", (Object)customProp);
                TestWebScriptServer.Response response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/facet/facet-config", filter.toString(), "application/json"), 200);
                response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config/" + filterName), 200);
                JSONObject jsonRsp = new JSONObject(new JSONTokener(response.getContentAsString()));
                customProp = jsonRsp.getJSONObject("customProperties");
                blockIncludeRequest = customProp.getJSONObject("blockIncludeFacetRequest");
                TestCase.assertEquals((Object)"{http://www.alfresco.org/model/solrfacetcustomproperty/1.0}blockIncludeFacetRequest", (Object)blockIncludeRequest.get("name"));
                TestCase.assertEquals((Object)"true", (Object)blockIncludeRequest.get("value"));
                multipleValue = customProp.getJSONObject("multipleValueTest");
                TestCase.assertEquals((Object)"{http://www.alfresco.org/model/solrfacetcustomproperty/1.0}multipleValueTest", (Object)multipleValue.get("name"));
                JSONArray jsonArray = (JSONArray)multipleValue.get("value");
                List<String> retrievedValues = FacetRestApiTest.this.getListFromJsonArray(jsonArray);
                Collections.sort(retrievedValues);
                TestCase.assertEquals(expectedValues, retrievedValues);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
    }

    public void testCreateUpdateFacetWithInvalidFilterId() throws Exception {
        final JSONObject filter = new JSONObject();
        final String filterName = "filter" + System.currentTimeMillis();
        this.filters.add(filterName);
        filter.put("filterID", (Object)filterName);
        filter.put("facetQName", (Object)"cm:test1");
        filter.put("displayName", (Object)"facet-menu.facet.test1");
        filter.put("displayControl", (Object)"alfresco/search/FacetFilters/test1");
        filter.put("maxFilters", 5);
        filter.put("hitThreshold", 1);
        filter.put("minFilterValueLength", 4);
        filter.put("sortBy", (Object)"ALPHABETICALLY");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/facet/facet-config", filter.toString(), "application/json"), 200);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestWebScriptServer.Response response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config/" + filterName), 200);
                JSONObject jsonRsp = new JSONObject(new JSONTokener(response.getContentAsString()));
                TestCase.assertEquals((String)filterName, (String)jsonRsp.getString("filterID"));
                jsonRsp.put("filterID", (Object)(filterName + "Modified"));
                FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/facet/facet-config", jsonRsp.toString(), "application/json"), 400);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/facet/facet-config", filter.toString(), "application/json"), 400);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestWebScriptServer.Response response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config"), 200);
                JSONObject jsonRsp = new JSONObject(new JSONTokener(response.getContentAsString()));
                JSONArray facetsArray = (JSONArray)jsonRsp.get(FacetRestApiTest.FACETS);
                TestCase.assertNotNull((String)"JSON 'facets' array was null", (Object)facetsArray);
                List<String> facets = FacetRestApiTest.this.getListFromJsonArray(facetsArray);
                filter.put("filterID", (Object)"<script>alert('Maliciouse-FilterID')</script>");
                FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/facet/facet-config", filter.toString(), "application/json"), 400);
                response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config"), 200);
                jsonRsp = new JSONObject(new JSONTokener(response.getContentAsString()));
                facetsArray = (JSONArray)jsonRsp.get(FacetRestApiTest.FACETS);
                TestCase.assertNotNull((String)"JSON 'facets' array was null", (Object)facetsArray);
                List<String> newFacets = FacetRestApiTest.this.getListFromJsonArray(facetsArray);
                TestCase.assertEquals(facets, newFacets);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
    }

    public void testCreateFacetWithLongFormQnameFilterId() throws Exception {
        final JSONObject filter = new JSONObject();
        String filterName = "filter" + GUID.generate();
        this.filters.add(filterName);
        filter.put("filterID", (Object)filterName);
        filter.put("facetQName", (Object)"{http://www.alfresco.org/model/content/1.0}testLongQname");
        filter.put("displayName", (Object)"facet-menu.facet.testLongQname");
        filter.put("displayControl", (Object)"alfresco/search/FacetFilters/testLongQname");
        filter.put("maxFilters", 5);
        filter.put("hitThreshold", 1);
        filter.put("minFilterValueLength", 4);
        filter.put("sortBy", (Object)"ALPHABETICALLY");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/facet/facet-config", filter.toString(), "application/json"), 200);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
    }

    public void testUpdateSingleValue() throws Exception {
        final JSONObject filter = new JSONObject();
        final String filterName = "filter" + System.currentTimeMillis();
        this.filters.add(filterName);
        filter.put("filterID", (Object)filterName);
        filter.put("facetQName", (Object)"cm:test");
        filter.put("displayName", (Object)"facet-menu.facet.test1");
        filter.put("displayControl", (Object)"alfresco/search/FacetFilters/test");
        filter.put("maxFilters", 5);
        filter.put("hitThreshold", 1);
        filter.put("minFilterValueLength", 4);
        filter.put("sortBy", (Object)"ALPHABETICALLY");
        filter.put("isEnabled", true);
        JSONObject customProp = new JSONObject();
        JSONObject blockIncludeRequest = new JSONObject();
        blockIncludeRequest.put("name", (Object)"blockIncludeFacetRequest");
        blockIncludeRequest.put("value", (Object)"true");
        customProp.put("blockIncludeFacetRequest", (Object)blockIncludeRequest);
        filter.put("customProperties", (Object)customProp);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/facet/facet-config", filter.toString(), "application/json"), 200);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestWebScriptServer.Response response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config/" + filterName), 200);
                JSONObject jsonRsp = new JSONObject(new JSONTokener(response.getContentAsString()));
                TestCase.assertEquals((String)filterName, (String)jsonRsp.getString("filterID"));
                TestCase.assertEquals((String)"facet-menu.facet.test1", (String)jsonRsp.getString("displayName"));
                TestCase.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}test", (String)jsonRsp.getString("facetQName"));
                TestCase.assertTrue((boolean)jsonRsp.getBoolean("isEnabled"));
                JSONObject singleValueJson = new JSONObject();
                singleValueJson.put("filterID", (Object)filterName);
                singleValueJson.put("displayName", (Object)"facet-menu.facet.modifiedValue");
                FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/facet/facet-config", singleValueJson.toString(), "application/json"), 200);
                singleValueJson = new JSONObject();
                singleValueJson.put("filterID", (Object)filterName);
                singleValueJson.put("isEnabled", false);
                FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/facet/facet-config", singleValueJson.toString(), "application/json"), 200);
                response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config/" + filterName), 200);
                jsonRsp = new JSONObject(new JSONTokener(response.getContentAsString()));
                TestCase.assertEquals((String)"facet-menu.facet.modifiedValue", (String)jsonRsp.getString("displayName"));
                TestCase.assertFalse((boolean)jsonRsp.getBoolean("isEnabled"));
                TestCase.assertEquals((String)filterName, (String)jsonRsp.getString("filterID"));
                TestCase.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}test", (String)jsonRsp.getString("facetQName"));
                TestCase.assertEquals((String)"alfresco/search/FacetFilters/test", (String)jsonRsp.getString("displayControl"));
                TestCase.assertEquals((int)5, (int)jsonRsp.getInt("maxFilters"));
                TestCase.assertEquals((int)1, (int)jsonRsp.getInt("hitThreshold"));
                TestCase.assertEquals((int)4, (int)jsonRsp.getInt("minFilterValueLength"));
                TestCase.assertEquals((String)"ALPHABETICALLY", (String)jsonRsp.getString("sortBy"));
                TestCase.assertEquals((String)"ALL", (String)jsonRsp.getString("scope"));
                TestCase.assertFalse((boolean)jsonRsp.getBoolean("isDefault"));
                JSONObject retrievedCustomProp = jsonRsp.getJSONObject("customProperties");
                JSONObject retrievedBlockIncludeRequest = retrievedCustomProp.getJSONObject("blockIncludeFacetRequest");
                TestCase.assertEquals((Object)"{http://www.alfresco.org/model/solrfacetcustomproperty/1.0}blockIncludeFacetRequest", (Object)retrievedBlockIncludeRequest.get("name"));
                TestCase.assertEquals((Object)"true", (Object)retrievedBlockIncludeRequest.get("value"));
                singleValueJson = new JSONObject();
                singleValueJson.put("filterID", (Object)filterName);
                singleValueJson.put("facetQName", (Object)"cm:testModifiedValue");
                singleValueJson.put("customProperties", (Object)new JSONObject());
                FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/facet/facet-config", singleValueJson.toString(), "application/json"), 200);
                response = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/facet/facet-config/" + filterName), 200);
                jsonRsp = new JSONObject(new JSONTokener(response.getContentAsString()));
                TestCase.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}testModifiedValue", (String)jsonRsp.getString("facetQName"));
                TestCase.assertNull((String)"Custom properties should have been deleted.", (Object)jsonRsp.opt("customProperties"));
                TestCase.assertEquals((String)filterName, (String)jsonRsp.getString("filterID"));
                TestCase.assertEquals((String)"facet-menu.facet.modifiedValue", (String)jsonRsp.getString("displayName"));
                TestCase.assertEquals((String)"alfresco/search/FacetFilters/test", (String)jsonRsp.getString("displayControl"));
                TestCase.assertEquals((int)5, (int)jsonRsp.getInt("maxFilters"));
                TestCase.assertEquals((int)1, (int)jsonRsp.getInt("hitThreshold"));
                TestCase.assertEquals((int)4, (int)jsonRsp.getInt("minFilterValueLength"));
                TestCase.assertEquals((String)"ALPHABETICALLY", (String)jsonRsp.getString("sortBy"));
                TestCase.assertFalse((boolean)jsonRsp.getBoolean("isDefault"));
                TestCase.assertEquals((String)"ALL", (String)jsonRsp.getString("scope"));
                TestCase.assertFalse((boolean)jsonRsp.getBoolean("isEnabled"));
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
    }

    public void testGetAllFacetableProperties() throws Exception {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestWebScriptServer.Response rsp = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(FacetRestApiTest.GET_ALL_FACETABLE_PROPERTIES_URL), 200);
                JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
                JSONObject data = jsonRsp.getJSONObject("data");
                JSONArray properties = data.getJSONArray("properties");
                int arbitraryLimit = 25;
                TestCase.assertTrue((String)"Expected 'many' properties, but found 'not very many'", (properties.length() > 25 ? 1 : 0) != 0);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
    }

    public void testGetFacetablePropertiesForSpecificContentClasses() throws Exception {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestWebScriptServer.Response rsp = FacetRestApiTest.this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(FacetRestApiTest.GET_SPECIFIC_FACETABLE_PROPERTIES_URL.replace("{classname}", "cm:content")), 200);
                JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
                JSONObject data = jsonRsp.getJSONObject("data");
                JSONArray properties = data.getJSONArray("properties");
                int arbitraryLimit = 100;
                TestCase.assertTrue((String)"Expected 'not very many' properties, but found 'many'", (properties.length() < 100 ? 1 : 0) != 0);
                return null;
            }
        }, (String)SEARCH_ADMIN_USER);
    }

    private List<String> getListFromJsonArray(JSONArray facetsArray) throws JSONException {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < facetsArray.length(); ++i) {
            Object object = facetsArray.get(i);
            if (object instanceof JSONObject) {
                JSONObject nextFacet = (JSONObject)object;
                String nextId = nextFacet.getString("filterID");
                result.add(nextId);
                continue;
            }
            result.add((String)object);
        }
        return result;
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    private void deleteUser(String userName) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
    }

    private void deleteFilters() throws IOException {
        for (String filter : this.filters) {
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/facet/facet-config/" + filter), 200);
        }
    }
}

